/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text.md;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mythruna.text.md.BulletElement;
import mythruna.text.md.HeaderElement;
import mythruna.text.md.HighlightElement;
import mythruna.text.md.MdElement;
import mythruna.text.md.TextElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownBuffer
implements Iterable<MdElement> {
    static Logger log = LoggerFactory.getLogger(MarkdownBuffer.class);
    private List<MdElement> elements = new ArrayList<MdElement>();
    private MdElement currentElement;

    public MarkdownBuffer() {
    }

    public MarkdownBuffer(String text) {
        this.append(text);
    }

    @Override
    public Iterator<MdElement> iterator() {
        return this.elements.iterator();
    }

    public void append(String text) {
        int length = text.length();
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\r' || c != '\n') continue;
            String line = text.substring(start, i);
            start = i + 1;
            this.appendLine(line);
        }
        if (start < length) {
            String line = text.substring(start);
            this.appendLine(line);
        }
    }

    protected void appendLine(String line) {
        if (line.trim().length() == 0) {
            this.currentElement = null;
            return;
        }
        if (line.charAt(0) == '#') {
            this.elements.add(new HeaderElement(line));
            this.currentElement = null;
            return;
        }
        if (line.charAt(0) == '=') {
            this.currentElement = new HighlightElement(line);
            this.elements.add(this.currentElement);
            return;
        }
        if (line.charAt(0) == '-' || line.charAt(0) == '*') {
            this.currentElement = new BulletElement(line);
            this.elements.add(this.currentElement);
            return;
        }
        if (this.currentElement == null) {
            this.currentElement = new TextElement();
            this.elements.add(this.currentElement);
        }
        this.currentElement.append(line);
    }
}

