#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Parallax.glsllib"
#import "Common/ShaderLib/Optics.glsllib"
#ifndef VERTEX_LIGHTING
    #import "Common/ShaderLib/BlinnPhongLighting.glsllib"
    #import "Common/ShaderLib/Lighting.glsllib"
#endif

// fog - jayfella
#ifdef USE_FOG
#import "Common/ShaderLib/MaterialFog.glsllib"
varying float fog_distance;
uniform vec4 m_FogColor;

#ifdef FOG_LINEAR
uniform vec2 m_LinearFog;
#endif

#ifdef FOG_EXP
uniform float m_ExpFog;
#endif

#ifdef FOG_EXPSQ
uniform float m_ExpSqFog;
#endif

#endif // end fog

varying vec2 texCoord;
#ifdef SEPARATE_TEXCOORD
  varying vec2 texCoord2;
#endif

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;

varying vec4 modelLight;
//uniform vec3 g_CameraDirection;
varying vec3 localLightDir;


#ifndef VERTEX_LIGHTING
  uniform vec4 g_LightDirection;
  //varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
  varying vec3 lightVec;
#else
  varying vec2 vertexLightValues;
#endif

#ifdef DIFFUSEMAP
  uniform sampler2D m_DiffuseMap;
#endif

#ifdef SPECULARMAP
  uniform sampler2D m_SpecularMap;
#endif

#ifdef PARALLAXMAP
  uniform sampler2D m_ParallaxMap;  
#endif
#if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
    uniform float m_ParallaxHeight;
    varying vec3 vViewDirPrlx;
#endif

#ifdef LIGHTMAP
  uniform sampler2D m_LightMap;
#endif
  
#ifdef NORMALMAP
  uniform sampler2D m_NormalMap;   
#else
  varying vec3 vNormal;
#endif

#ifdef ALPHAMAP
  uniform sampler2D m_AlphaMap;
#endif

#ifdef COLORRAMP
  uniform sampler2D m_ColorRamp;
#endif

uniform float m_AlphaDiscardThreshold;

#ifndef VERTEX_LIGHTING
    uniform float m_Shininess;
    #ifdef USE_REFLECTION 
        uniform float m_ReflectionPower;
        uniform float m_ReflectionIntensity;
        varying vec4 refVec;

        uniform ENVMAP m_EnvMap;
    #endif
#endif

// I don't remember why I have this and Mac M1's don't like
// it so I'm going to hang it off of test mode so I can turn
// it on/off to see what it does.
// It was added with the glass specular stuff and may have been
// related to the screen door transparency that I was testing.
#ifdef TEST_MODE
//layout(pixel_center_integer) in vec4 gl_FragCoord;
//layout(pixel_center_integer) vec4 gl_FragCoord;
layout(pixel_center_integer) in vec4 gl_FragCoord;
// It appears to make no difference at all.
// I'm going to leave it off by default and hooked to "test mode" 
// so I can play with it if I want to.
#endif

void main(){
    vec2 newTexCoord;
     
    #if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
     
       #ifdef STEEP_PARALLAX
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map         
               newTexCoord = steepParallaxOffset(m_NormalMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = steepParallaxOffset(m_ParallaxMap, vViewDirPrlx, texCoord, m_ParallaxHeight);         
           #endif
       #else
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map         
               newTexCoord = classicParallaxOffset(m_NormalMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = classicParallaxOffset(m_ParallaxMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #endif
       #endif
    #else
       newTexCoord = texCoord;    
    #endif
    
   #ifdef DIFFUSEMAP
      vec4 diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
    #else
      vec4 diffuseColor = vec4(1.0);
    #endif
 
    /*
    // Goofing around with screen door transparency
    float on = step(600.0, gl_FragCoord.x) * mod(gl_FragCoord.x, 2) * mod(gl_FragCoord.y, 2);
    diffuseColor *= (1.0 - on);
    //diffuseColor *= mod(gl_FragCoord.x, 2); 
    //diffuseColor *= mod(gl_FragCoord.y, 2);
    //diffuseColor *= step(2, mod(gl_FragCoord.x, 3)); 
    //diffuseColor *= step(2, mod(gl_FragCoord.y, 3)); 

    //alpha = (mod(gl_FragCoord.x, 8) / 8.0) * alpha;
    */
    
    float alpha = DiffuseSum.a * diffuseColor.a;
    
    #ifdef ALPHAMAP
       alpha = alpha * texture2D(m_AlphaMap, newTexCoord).r;
    #endif

    //alpha = 1.0;
    
    #ifndef GLASS_SPECULAR
        // Then we can discard early
        #ifdef DISCARD_ALPHA
            if(alpha < m_AlphaDiscardThreshold){
                discard;
            }
        #endif
    #endif



    // ***********************
    // Read from textures
    // ***********************
    #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
      vec4 normalHeight = texture2D(m_NormalMap, newTexCoord);
      //Note the -2.0 and -1.0. We invert the green channel of the normal map, 
      //as it's complient with normal maps generated with blender.
      //see http://hub.jmonkeyengine.org/forum/topic/parallax-mapping-fundamental-bug/#post-256898
      //for more explanation.
      vec3 normal = normalize((normalHeight.xyz * vec3(2.0,-2.0,2.0) - vec3(1.0,-1.0,1.0)));
      #ifdef LATC
        normal.z = sqrt(1.0 - (normal.x * normal.x) - (normal.y * normal.y));
      #endif      
    #elif !defined(VERTEX_LIGHTING)
      vec3 normal = vNormal;
      #if !defined(LOW_QUALITY) && !defined(V_TANGENT)
         normal = normalize(normal);
      #endif
    #endif

    #ifdef SPECULARMAP
      vec4 specularColor = texture2D(m_SpecularMap, newTexCoord);
    #else
      vec4 specularColor = vec4(1.0);
    #endif

    #ifdef LIGHTMAP
       vec3 lightMapColor;
       #ifdef SEPARATE_TEXCOORD
          lightMapColor = texture2D(m_LightMap, texCoord2).rgb;
       #else
          lightMapColor = texture2D(m_LightMap, texCoord).rgb;
       #endif
       specularColor.rgb *= lightMapColor;
       diffuseColor.rgb  *= lightMapColor;
    #endif

    #ifdef VERTEX_LIGHTING
       vec2 light = vertexLightValues.xy;
       #ifdef COLORRAMP
            diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
            specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
            light.xy = vec2(1.0);
       #endif

       gl_FragColor.rgb =  AmbientSum     * diffuseColor.rgb + 
                           DiffuseSum.rgb * diffuseColor.rgb  * vec3(light.x) +
                           SpecularSum    * specularColor.rgb * vec3(light.y);
    #else
       vec4 lightDir = vLightDir;
       lightDir.xyz = normalize(lightDir.xyz);
       vec3 viewDir = normalize(vViewDir);
       float spotFallOff = 1.0;

       #if __VERSION__ >= 110
        // allow use of control flow
        if(g_LightDirection.w != 0.0){
       #endif
          spotFallOff =  computeSpotFalloff(g_LightDirection, lightVec);
       #if __VERSION__ >= 110
          if(spotFallOff <= 0.0){
              gl_FragColor.rgb = AmbientSum * diffuseColor.rgb;
              gl_FragColor.a   = alpha;
              return;
          }
         }        
       #endif

       vec2   sunlight = computeLighting(normal, viewDir, lightDir.xyz, lightDir.w * spotFallOff, m_Shininess) ;
       vec2   localLight = computeLighting(normal, viewDir, localLightDir, 1.0, m_Shininess) ;
       #ifdef COLORRAMP
            shouldn't work right now because it doesn't use local light yet
            diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(sunlight.x, 0.0)).rgb;
            specularColor.rgb *= texture2D(m_ColorRamp, vec2(sunlight.y, 0.0)).rgb;
            sunlight.xy = vec2(1.0);
       #endif

       // Workaround, since it is not possible to modify varying variables
       vec4 SpecularSum2 = vec4(SpecularSum, 1.0);
       #ifdef USE_REFLECTION
            vec4 refColor = Optics_GetEnvColor(m_EnvMap, refVec.xyz);

            // Interpolate light specularity toward reflection color
            // Multiply result by specular map
            specularColor = mix(SpecularSum2 * sunlight.y, refColor, refVec.w) * specularColor;

            SpecularSum2 = vec4(1.0);
            sunlight.y = 1.0;
       #endif

       // Sunlight contribution
       gl_FragColor.rgb =  AmbientSum       * diffuseColor.rgb  +
                           DiffuseSum.rgb   * diffuseColor.rgb  * vec3(sunlight.x) +
                           SpecularSum2.rgb * specularColor.rgb * vec3(sunlight.y);
 
        #ifdef GLASS_SPECULAR
            alpha = max(0.0, alpha) + max(sunlight.y, localLight.y);
        #endif 
 
       // We want to dull the local light contribution in direct daylight.
       float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.a * sunlight.x + length(AmbientSum.rgb) * modelLight.a);
       //float localContrib = length(modelLight.xyz) * localLight.x;
       //float localContrib = min(1.25 - (sunlight.x * modelLight.a), length(modelLight.xyz));
       float localContrib = max(0.0, min(1.0, 1.25 - sunContrib));
 
       // Local light contribution                          
       gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb * localContrib 
                           + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x) * localContrib 
                           + 1.0 * specularColor.rgb * vec3(localLight.y) * localContrib;
       //gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb
       //                      + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x)
       //                      + 1.0 * specularColor.rgb * vec3(localLight.y);       
                           
       //gl_FragColor.rgb = vec3(sunContrib);
    #endif


    // add fog after the lighting because shadows will cause the fog to darken
    // which just results in the geometry looking like it's changed color
    #ifdef USE_FOG
        #ifdef FOG_LINEAR
            gl_FragColor = getFogLinear(gl_FragColor, m_FogColor, m_LinearFog.x, m_LinearFog.y, fog_distance);
        #endif
        #ifdef FOG_EXP
            gl_FragColor = getFogExp(gl_FragColor, m_FogColor, m_ExpFog, fog_distance);
        #endif
        #ifdef FOG_EXPSQ
            gl_FragColor = getFogExpSquare(gl_FragColor, m_FogColor, m_ExpSqFog, fog_distance);
        #endif
    #endif // end fog

    //gl_FragColor.rgb = mix(vec3(0.0), gl_FragColor.rgb, alpha);
    gl_FragColor.a = 1.0; //alpha;
 
    #ifdef GLASS_SPECULAR       
        #ifdef DISCARD_ALPHA
            if(alpha < m_AlphaDiscardThreshold){
                discard;
            }
        #endif
    #endif
    
}
