/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.jme3.network.AbstractMessage;
import com.jme3.network.serializing.Serializable;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.net.SentState;
import java.io.IOException;

@Serializable
public class ObjectStateMessage
extends AbstractMessage {
    public static final int HEADER_SIZE = 15;
    private int id;
    private long time;
    private byte[] buffer;

    public ObjectStateMessage() {
    }

    public ObjectStateMessage(int id, long nanoTime, byte[] buffer) {
        this.id = id;
        this.time = nanoTime;
        this.buffer = buffer;
    }

    public int getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public SentState getState(ObjectStateProtocol protocol) {
        if (this.buffer == null) {
            return null;
        }
        try {
            return SentState.fromByteArray(this.id, this.buffer, protocol);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading frame states", e);
        }
    }

    public void setState(SentState state, ObjectStateProtocol protocol) {
        if (state == null) {
            this.buffer = null;
            return;
        }
        try {
            state.messageId = this.id;
            this.buffer = SentState.toByteArray(state, protocol);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing frame states", e);
        }
    }

    public String toString() {
        if (this.buffer == null) {
            return "ObjectStateMessage[]";
        }
        return "ObjectStateMessage[id=" + this.id + ", time=" + this.time + ", size=" + this.buffer.length + "]";
    }
}

