/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import java.util.ArrayList;
import java.util.List;
import mythruna.assembly.Joint;
import mythruna.client.ui.assembly.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointDurationEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(JointDurationEditor.class);
    private List<Joint> joints = new ArrayList<Joint>();
    private Spinner<Double> duration;
    private VersionedReference<Double> durationRef;
    private Label mixStart;
    private Label mixEnd;
    private Slider mix;
    private Action open;
    private Action close;
    private double mixDir = 0.0;

    public JointDurationEditor() {
        Container properties = (Container)this.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Duration (s):"), new Object[0]);
        this.duration = (Spinner)properties.addChild(Vec3dEditor.createDoubleSpinner(0.0, 5.0, 0.1, 0.1, 1.0, "%.1f"), new Object[]{1});
        this.durationRef = this.duration.getModel().createReference();
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.open = new CallMethodAction((Object)this, "open");
        this.close = new CallMethodAction((Object)this, "close");
        buttons.addChild((Node)new ActionButton(this.close), new Object[0]);
        buttons.addChild((Node)new ActionButton(this.open), new Object[0]);
        Container cont = (Container)this.addChild((Node)new Container((GuiLayout)new BorderLayout()), new Object[0]);
        this.mixStart = (Label)cont.addChild((Node)new Label("Start"), new Object[]{BorderLayout.Position.West});
        this.mix = (Slider)cont.addChild((Node)new Slider(Axis.X), new Object[]{BorderLayout.Position.Center});
        this.mixEnd = (Label)cont.addChild((Node)new Label("End"), new Object[]{BorderLayout.Position.East});
    }

    public void setJoints(List<Joint> joints) {
        this.joints = joints;
        this.resetFields(joints);
    }

    public VersionedReference<Double> createMixReference() {
        return this.mix.getModel().createReference();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.mixDir != 0.0) {
            double length = (Double)this.duration.getValue();
            if (length == 0.0) {
                if (this.mixDir > 0.0) {
                    this.mix.getModel().setPercent(1.0);
                } else {
                    this.mix.getModel().setPercent(0.0);
                }
                this.mixDir = 0.0;
            } else {
                double val = this.mix.getModel().getPercent();
                double current = val * length;
                if ((current += this.mixDir * (double)tpf) > length) {
                    current = length;
                    this.mixDir = 0.0;
                } else if (current < 0.0) {
                    current = 0.0;
                    this.mixDir = 0.0;
                }
                this.mix.getModel().setPercent(current / length);
            }
        }
        if (this.durationRef.update()) {
            this.setDuration((Double)this.durationRef.get());
        }
    }

    protected void open() {
        log.info("open()");
        this.mixDir = 1.0;
    }

    protected void close() {
        log.info("close()");
        this.mixDir = -1.0;
    }

    protected void setDuration(double duration) {
        for (Joint j : this.joints) {
            j.setDuration(duration);
        }
    }

    protected void resetFields(List<Joint> joints) {
        double d = 0.0;
        if (!joints.isEmpty()) {
            d = joints.get(0).getDuration();
        }
        this.duration.setValue((Object)d);
    }
}

