/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import mythruna.client.view.object.AbstractModel;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelCounts;
import mythruna.client.view.object.ModelFactory;
import mythruna.client.view.object.SpatialUtils;
import mythruna.net.client.DestructibleSessionClientService;
import mythruna.shape.ShapeName;
import mythruna.sim.DestructibleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaxModelFactory
implements ModelFactory {
    static Logger log = LoggerFactory.getLogger(FaxModelFactory.class);
    private static final String COUNT_FAXES = "Faxes";
    private static final String COUNT_ACTIVE_FAXES = "Actv Faxes";
    private ShapeFactory<MBlockShape> shapeFactory;
    private GeometryFactory geomFactory;
    private Predicate<Geometry> carveIncludes;
    private JobState workers;
    private ModelCounts counts;
    private DestructibleSessionClientService destructibles;
    private DestructibleObserver observer = new DestructibleObserver();
    private int modelCount;
    private Map<EntityId, FaxModel> activeModels = new ConcurrentHashMap<EntityId, FaxModel>();

    public FaxModelFactory(ShapeFactory<MBlockShape> shapeFactory, DestructibleSessionClientService destructibles, GeometryFactory geomFactory, Predicate<Geometry> carveIncludes, JobState workers, ModelCounts counts) {
        this.shapeFactory = shapeFactory;
        this.geomFactory = geomFactory;
        this.carveIncludes = carveIncludes;
        this.workers = workers;
        this.counts = counts;
        this.destructibles = destructibles;
        destructibles.addDestructibleListener((DestructibleListener)this.observer);
        counts.createView(COUNT_FAXES);
        counts.createView(COUNT_ACTIVE_FAXES);
        counts.updateCount(COUNT_FAXES, this.modelCount);
        counts.updateCount(COUNT_ACTIVE_FAXES, this.activeModels.size());
    }

    protected void updateCounts() {
        this.counts.updateCount(COUNT_ACTIVE_FAXES, this.activeModels.size());
    }

    @Override
    public Model createModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
        log.info("createModel(" + entityId + ", " + name + ", " + shapeInfo + ")");
        MBlockShape shape = (MBlockShape)this.shapeFactory.createShape(name.getFullName(), shapeInfo.getScale(), null);
        CellArrayPart part = (CellArrayPart)shape.getPart();
        FaxModel result = new FaxModel(entityId, name, shapeInfo, part);
        return result;
    }

    protected class DestructibleObserver
    implements DestructibleListener {
        protected DestructibleObserver() {
        }

        public void cellChanged(EntityId objectId, int x, int y, int z, int value) {
            log.info("cellChanged(" + objectId + ", " + x + ", " + y + ", " + z + ", " + value + ")");
            FaxModel model = (FaxModel)FaxModelFactory.this.activeModels.get(objectId);
            log.info(objectId + " -> updating:" + model);
            if (model != null) {
                model.setCell(x, y, z, value);
            }
        }
    }

    protected class FaxModel
    extends AbstractModel {
        private ColorRGBA localLighting;
        private Vec3d center;
        private CellArrayPart part;
        private CellArray cells;
        private UpdateQueue updateQueue;

        public FaxModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo, CellArrayPart part) {
            super(entityId, name, shapeInfo);
            this.localLighting = new ColorRGBA();
            this.center = new Vec3d();
            FaxModelFactory.this.modelCount++;
            FaxModelFactory.this.counts.updateCount(FaxModelFactory.COUNT_FAXES, FaxModelFactory.this.modelCount);
            this.updateQueue = new UpdateQueue(this, part.getCells().clone(), part.getScale());
            this.updateQueue.enqueue(uq -> {
                log.info(((UpdateQueue)uq).target.getEntityId() + ": initial update");
                return false;
            }, uq -> {
                FaxModelFactory.this.activeModels.put(((UpdateQueue)uq).target.getEntityId(), ((UpdateQueue)uq).target);
                log.info(((UpdateQueue)uq).target.getEntityId() + ": cell update");
                CellArray cells = FaxModelFactory.this.destructibles.getObjectCellArray(((UpdateQueue)uq).target.getEntityId());
                if (cells != null) {
                    ((UpdateQueue)uq).cells = cells;
                }
                log.info(((UpdateQueue)uq).target.getEntityId() + ": updated cells to:" + cells);
                return true;
            });
        }

        public void setCell(int x, int y, int z, int value) {
            this.updateQueue.enqueue(uq -> {
                ((UpdateQueue)uq).cells.setCell(x, y, z, value);
                return true;
            });
        }

        @Override
        protected void updateSpatial(Spatial spatial) {
            log.info("updateSpatial() for:" + this.getEntityId());
            super.updateSpatial(spatial);
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "LocalLighting", (Object)this.localLighting));
            spatial.setCullHint(Spatial.CullHint.Always);
        }

        @Override
        public void setLighting(int lighting) {
            float s = (float)LightUtils.sun((int)lighting) / 15.0f;
            float r = (float)LightUtils.red((int)lighting) / 15.0f;
            float g = (float)LightUtils.green((int)lighting) / 15.0f;
            float b = (float)LightUtils.blue((int)lighting) / 15.0f;
            this.localLighting.set(r, g, b, s);
        }

        @Override
        public Vec3d getCenterOffset() {
            Spatial spatial = (Spatial)this.getSpatialHolder().getObject();
            if (spatial == null) {
                return this.center;
            }
            this.center.set(spatial.getWorldBound().getCenter());
            this.center.subtractLocal(new Vec3d(spatial.getWorldTranslation()));
            return this.center;
        }

        @Override
        public void release() {
            super.release();
            this.updateQueue.setCanceled();
            FaxModelFactory.this.workers.cancel((Job)this.updateQueue);
            FaxModelFactory.this.activeModels.remove(this.getEntityId());
            FaxModelFactory.this.modelCount--;
            FaxModelFactory.this.counts.updateCount(FaxModelFactory.COUNT_FAXES, FaxModelFactory.this.modelCount);
            FaxModelFactory.this.updateCounts();
        }
    }

    protected class UpdateQueue
    implements Job {
        private FaxModel target;
        private ConcurrentLinkedQueue<Function<UpdateQueue, Boolean>> queue = new ConcurrentLinkedQueue();
        private AtomicBoolean enqueued = new AtomicBoolean(false);
        private AtomicBoolean canceled = new AtomicBoolean(false);
        private CellArray cells;
        private double scale;
        private volatile Spatial spatial;

        public UpdateQueue(FaxModel target, CellArray cells, double scale) {
            this.target = target;
            this.cells = cells;
            this.scale = scale;
        }

        public void enqueue(Function<UpdateQueue, Boolean> r) {
            this.queue.add(r);
            this.enqueueIfNeeded();
        }

        @SafeVarargs
        public final void enqueue(Function<UpdateQueue, Boolean> ... tasks) {
            this.queue.addAll(Arrays.asList(tasks));
            this.enqueueIfNeeded();
        }

        protected synchronized void setCanceled() {
            this.canceled.set(true);
        }

        protected synchronized void enqueueIfNeeded() {
            if (this.queue.isEmpty()) {
                return;
            }
            if (this.canceled.get()) {
                return;
            }
            if (this.enqueued.get()) {
                return;
            }
            this.enqueued.set(true);
            FaxModelFactory.this.workers.execute((Job)this, -1);
        }

        protected synchronized void clearEnqueued() {
            this.enqueued.set(false);
        }

        protected void applyUpdates() {
            Function<UpdateQueue, Boolean> r = null;
            while ((r = this.queue.poll()) != null) {
                if (this.canceled.get()) {
                    return;
                }
                try {
                    Boolean result = r.apply(this);
                    if (result != null && result.booleanValue()) continue;
                    break;
                }
                catch (Exception e) {
                    log.error("Error applying update:" + r + " for:" + this.target, (Throwable)e);
                }
            }
        }

        protected void rebuildSpatial() {
            if (this.canceled.get()) {
                return;
            }
            try {
                MaskUtils.calculateSideMasks((CellArray)this.cells);
                this.spatial = SpatialUtils.createCellArraySpatial(String.valueOf(this.target.getEntityId()), this.cells, this.scale, FaxModelFactory.this.geomFactory, false, FaxModelFactory.this.carveIncludes);
                log.info("created:" + this.spatial);
            }
            catch (Exception e) {
                log.error("Error creating spatial for:" + this.target, (Throwable)e);
                this.spatial = SpatialUtils.createDebugSphere("bad:" + this.target.getEntityId(), (float)this.scale, ColorRGBA.Orange, null);
            }
            this.spatial.setUserData("oid", (Object)this.target.getEntityId().getId());
        }

        public void runOnWorker() {
            this.applyUpdates();
            this.rebuildSpatial();
            this.clearEnqueued();
            this.enqueueIfNeeded();
        }

        public double runOnUpdate() {
            FaxModelFactory.this.updateCounts();
            if (this.canceled.get()) {
                return 0.0;
            }
            this.target.updateSpatial(this.spatial);
            return 0.1;
        }
    }
}

