/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.asset.AssetManager;
import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.AttachmentControl;
import com.simsilica.crig.jme.SpatialRigType;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.character.CharacterDecorator;
import mythruna.client.character.CharacterDecorators;
import mythruna.client.view.object.AbstractModel;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelFactory;
import mythruna.client.view.object.RigModel;
import mythruna.client.view.object.SpatialUtils;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigModelFactory
implements ModelFactory {
    static Logger log = LoggerFactory.getLogger(RigModelFactory.class);
    private ShapeFactory<MBlockShape> shapeFactory;
    private AssetManager assets;
    private JobState workers;
    private Function<CellArrayId, CellArray> cellStorage;
    private VersionedReference<EntityId> avatarIdRef;

    public RigModelFactory(ShapeFactory<MBlockShape> shapeFactory, AssetManager assets, VersionedReference<EntityId> avatarIdRef, Function<CellArrayId, CellArray> cellStorage, JobState workers) {
        this.shapeFactory = shapeFactory;
        this.assets = assets;
        this.avatarIdRef = avatarIdRef;
        this.cellStorage = cellStorage;
        this.workers = workers;
    }

    @Override
    public Model createModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
        RigModelImpl result = new RigModelImpl(entityId, name, shapeInfo);
        this.workers.execute((Job)new ModelLoader(result, name, shapeInfo), -1);
        return result;
    }

    protected boolean hasAppearanceStuff(ShapeName shapeName) {
        for (ShapeName addOn : shapeName.getAddOns()) {
            if ("fab".equals(addOn.getType())) {
                return true;
            }
            if ("sc".equals(addOn.getType())) {
                return true;
            }
            if ("hc".equals(addOn.getType())) {
                return true;
            }
            if (!"sv".equals(addOn.getType())) continue;
            return true;
        }
        return false;
    }

    protected class RigModelImpl
    extends AbstractModel
    implements RigModel {
        private ColorRGBA localLighting;
        private AttachmentPoint centerOfMass;
        private CharacterRig characterRig;
        private CharacterDecorator decorator;

        public RigModelImpl(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
            super(entityId, name, shapeInfo);
            this.localLighting = new ColorRGBA();
            if (Objects.equals(entityId, RigModelFactory.this.avatarIdRef.get())) {
                this.setDynamicVisibility(false);
            }
        }

        @Override
        public CharacterRig getCharacterRig() {
            return this.characterRig;
        }

        @Override
        protected void onAddOnUpdate(ShapeName shapeName) {
            super.onAddOnUpdate(shapeName);
            Spatial spatial = (Spatial)this.getSpatialHolder().getObject();
            if (spatial == null) {
                return;
            }
            if (!RigModelFactory.this.hasAppearanceStuff(shapeName)) {
                this.decorator = null;
                return;
            }
            DecoratorUpdater updater = new DecoratorUpdater(this, this.decorator, spatial, shapeName);
            RigModelFactory.this.workers.execute((Job)updater, -1);
        }

        protected void updateDecorator(ShapeName loadName, CharacterDecorator decorator) {
            if (Objects.equals(this.getShapeName(), loadName)) {
                this.decorator = decorator;
                return;
            }
            if (!RigModelFactory.this.hasAppearanceStuff(this.getShapeName())) {
                this.decorator = null;
                return;
            }
            Spatial spatial = (Spatial)this.getSpatialHolder().getObject();
            DecoratorUpdater updater = new DecoratorUpdater(this, decorator, spatial, this.getShapeName());
            RigModelFactory.this.workers.execute((Job)updater, -1);
        }

        protected void updateSpatial(Spatial spatial, CharacterRig characterRig) {
            super.updateSpatial(spatial);
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "LocalLighting", (Object)this.localLighting));
            spatial.setCullHint(Spatial.CullHint.Always);
            AttachmentControl attachments = (AttachmentControl)spatial.getControl(AttachmentControl.class);
            if (attachments != null) {
                this.centerOfMass = attachments.getAttachment("com");
            }
            if (this.centerOfMass == null) {
                log.warn("Rig has no center of mass:" + this);
            }
            log.info("characterRig = " + characterRig);
            this.characterRig = characterRig;
        }

        @Override
        public void setLighting(int lighting) {
            float s = (float)LightUtils.sun((int)lighting) / 15.0f;
            float r = (float)LightUtils.red((int)lighting) / 15.0f;
            float g = (float)LightUtils.green((int)lighting) / 15.0f;
            float b = (float)LightUtils.blue((int)lighting) / 15.0f;
            this.localLighting.set(r, g, b, s);
        }

        @Override
        public Vec3d getCenterOffset() {
            if (this.centerOfMass == null) {
                return Vec3d.ZERO;
            }
            this.centerOfMass.update();
            Vec3d com = this.centerOfMass.getTranslation();
            Spatial s = (Spatial)this.getSpatialHolder().getObject();
            com = com.subtract(new Vec3d(s.getWorldTranslation()));
            return com;
        }
    }

    protected class ModelLoader
    implements Job {
        private final RigModelImpl target;
        private final ShapeName name;
        private final ShapeInfo shapeInfo;
        private CharacterDecorator decorator;
        private Spatial spatial;
        private CharacterRig viewRig;

        public ModelLoader(RigModelImpl target, ShapeName name, ShapeInfo shapeInfo) {
            this.target = target;
            this.name = name;
            this.shapeInfo = shapeInfo;
            if (RigModelFactory.this.hasAppearanceStuff(name)) {
                this.decorator = CharacterDecorators.standardDecorators(RigModelFactory.this.assets, RigModelFactory.this.cellStorage);
            }
        }

        public void runOnWorker() {
            try {
                RigShape shape = (RigShape)RigModelFactory.this.shapeFactory.createShape(this.name.getFullName(), this.shapeInfo.getScale(), null);
                String assetName = this.name.getFullName() + ".j3o";
                this.spatial = RigModelFactory.this.assets.loadModel(assetName);
                this.spatial.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                this.spatial.setUserData("oid", (Object)this.target.getEntityId().getId());
                ((SpatialRigType)shape.getRigType()).configureSpatial(this.spatial);
                try {
                    this.viewRig = AnimComposerRig.createRig((Spatial)this.spatial);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Spatial has no character rig for:" + this.target, (Throwable)e);
                    this.viewRig = null;
                }
                if (this.decorator != null) {
                    this.decorator.setRig(this.viewRig);
                    this.decorator.setSpatial(this.spatial);
                    this.decorator.setShapeName(this.name);
                    this.decorator.apply();
                }
            }
            catch (Exception e) {
                log.error("Error loading:" + this.name + " for:" + this.target, (Throwable)e);
                this.spatial = SpatialUtils.createDebugSphere("bad:" + this.target.getEntityId(), (float)this.shapeInfo.getScale(), ColorRGBA.Red, null);
            }
        }

        public double runOnUpdate() {
            this.target.updateSpatial(this.spatial, this.viewRig);
            this.target.updateDecorator(this.name, this.decorator);
            return 0.1;
        }
    }

    protected class DecoratorUpdater
    implements Job {
        private RigModelImpl target;
        private CharacterDecorator decorator;
        private Spatial spatial;
        private ShapeName shapeName;

        public DecoratorUpdater(RigModelImpl target, CharacterDecorator decorator, Spatial spatial, ShapeName shapeName) {
            this.target = target;
            this.decorator = decorator;
            this.spatial = spatial;
            this.shapeName = shapeName;
        }

        public void runOnWorker() {
            if (this.decorator == null) {
                this.decorator = CharacterDecorators.standardDecorators(RigModelFactory.this.assets, RigModelFactory.this.cellStorage);
            }
            this.decorator.setRig(this.target.getCharacterRig());
            this.decorator.setSpatial(this.spatial);
            this.decorator.setShapeName(this.shapeName);
            if (this.spatial.getParent() == null) {
                this.decorator.apply();
            }
        }

        public double runOnUpdate() {
            if (this.spatial.getParent() != null && this.decorator.apply()) {
                return 0.1;
            }
            return 0.0;
        }
    }
}

