/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.Filters;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GridComponentIndex<C extends EntityComponent> {
    static Logger log = LoggerFactory.getLogger(GridComponentIndex.class);
    private Class<C> componentClass;
    private final Grid grid;
    private final int gridRadius;
    private final Vec3d center = new Vec3d();
    private final Vec3i centerCell = new Vec3i();
    private int size;
    private ComponentFilter[] filterArray;
    private ComponentFilter<C> positionFilter;

    protected GridComponentIndex(Class<C> componentClass, Grid grid, int gridRadius) {
        this.componentClass = componentClass;
        this.grid = grid;
        this.gridRadius = gridRadius;
        this.size = gridRadius * 2 + 1;
        this.filterArray = new ComponentFilter[this.size * this.size];
    }

    public ComponentFilter<C> getIndexFilter() {
        return this.positionFilter;
    }

    public ComponentFilter<C> createFalseFilter() {
        ComponentFilter<C> f1 = this.createBinFilter(0L);
        ComponentFilter<C> f2 = this.createBinFilter(1L);
        return Filters.and(this.componentClass, (ComponentFilter[])new ComponentFilter[]{f1, f2});
    }

    @SafeVarargs
    public final void validate(Class<? extends EntityComponent> ... componentTypes) {
        boolean found = false;
        for (Class<? extends EntityComponent> type : componentTypes) {
            if (type != this.componentClass) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Component types does not include " + this.componentClass.getName());
        }
    }

    public boolean setCenter(Vec3d center, boolean forceUpdate) {
        if (!forceUpdate && this.center.equals((Object)center)) {
            return false;
        }
        this.center.set(center);
        Vec3i newGridCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newGridCenter.equals((Object)this.centerCell)) {
            return false;
        }
        this.centerCell.set(newGridCenter);
        this.recalculateFilter();
        return true;
    }

    protected abstract ComponentFilter<C> createBinFilter(long var1);

    protected void recalculateFilter() {
        int xBase = this.centerCell.x - this.gridRadius;
        int yBase = this.centerCell.y;
        int zBase = this.centerCell.z - this.gridRadius;
        int index = 0;
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                long id = this.grid.cellToId(xBase + x, yBase, zBase + z);
                ComponentFilter<C> filter = this.createBinFilter(id);
                this.filterArray[index++] = filter;
            }
        }
        this.positionFilter = Filters.or(this.componentClass, (ComponentFilter[])this.filterArray);
    }
}

