/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.base.MoreObjects;
import com.jme3.math.ColorRGBA;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinTone {
    static Logger log = LoggerFactory.getLogger(SkinTone.class);
    private String name;
    private String description;
    private ColorRGBA color;
    private Set<String> races;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    protected static ColorRGBA stringToColor(String color) {
        int colorArgb = (int)Long.parseUnsignedLong(color, 16);
        if ((colorArgb & 0xFF000000) == 0) {
            colorArgb |= 0xFF000000;
        }
        return new ColorRGBA().fromIntARGB(colorArgb);
    }

    protected void setColor(String color) {
        this.color = SkinTone.stringToColor(color);
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    protected void setRaces(String csv) {
        String[] tokens = csv.split(",\\s*");
        this.races = new HashSet<String>(Arrays.asList(tokens));
    }

    public Set<String> getRaces() {
        return this.races;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("color", (Object)this.color).add("races", this.races).toString();
    }
}

