/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(StructureInfo.class);
    private int factoryId;
    private long blockDataId;
    private long tileId;
    private EntityId parent;

    protected StructureInfo() {
    }

    public StructureInfo(int factoryId, BlockDataId blockDataId, TileId tileId, EntityId parent) {
        this.factoryId = factoryId;
        this.blockDataId = blockDataId.getId();
        this.tileId = tileId.getId();
        this.parent = parent;
    }

    public static StructureInfo create(String factory, BlockDataId blockDataId, TileId tileId, EntityId parent, EntityData ed) {
        int id = ed.getStrings().getStringId(factory, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(factory, true);
        }
        return new StructureInfo(id, blockDataId, tileId, parent);
    }

    public static ComponentFilter<StructureInfo> tileFilter(TileId tileId) {
        ComponentFilter filter = Filters.fieldEquals(StructureInfo.class, (String)"tileId", (Object)tileId.getId());
        return filter;
    }

    public static ComponentFilter<StructureInfo> parentFilter(EntityId parent) {
        ComponentFilter filter = Filters.fieldEquals(StructureInfo.class, (String)"parent", (Object)parent);
        return filter;
    }

    public int getFactoryId() {
        return this.factoryId;
    }

    public String getFactory(EntityData ed) {
        if (this.factoryId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.factoryId);
    }

    public BlockDataId getBlockDataId() {
        return new BlockDataId(this.blockDataId);
    }

    public TileId getTileId() {
        return new TileId(this.tileId);
    }

    public EntityId getParent() {
        return this.parent;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)this.getClass().getSimpleName());
        if (ed == null) {
            helper.add("factoryId", this.factoryId);
        } else {
            helper.add("factory", (Object)this.getFactory(ed));
        }
        helper.add("blockDataId", this.blockDataId);
        helper.add("tileId", this.tileId);
        helper.add("parent", (Object)this.parent);
        return helper.toString();
    }
}

