/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.ColliderUtils;
import com.simsilica.mblock.phys.collision.CubeCollider;
import com.simsilica.mblock.phys.collision.CylinderCollider;
import com.simsilica.mblock.phys.collision.ShapeSignature;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarShapeIndex {
    static Logger log = LoggerFactory.getLogger(SimilarShapeIndex.class);
    private ShapeEntry[] shapes;
    private ListMultimap<String, ShapeEntry> shapeIndex = MultimapBuilder.hashKeys().arrayListValues().build();

    public SimilarShapeIndex(BlockType[] types, Collider[] colliders) {
        this.shapes = new ShapeEntry[types.length];
        for (int i = 0; i < this.shapes.length; ++i) {
            ShapeEntry entry;
            if (types[i] == null || colliders[i] == null) continue;
            this.shapes[i] = entry = new ShapeEntry(i, types[i], colliders[i]);
            this.shapeIndex.put((Object)types[i].getName().getBase(), (Object)this.shapes[i]);
        }
        this.buildSignatures();
    }

    public int findSimilar(BlockName name, BlockType skipType, ShapeSignature sig) {
        return this.findSimilar(this.shapeIndex.get((Object)name.getBase()), skipType, sig);
    }

    public int findSimilar(List<ShapeEntry> typeShapes, BlockType skipType, ShapeSignature sig) {
        int bestIndex = 0;
        int bestCount = 0;
        long testBits = sig.getBits();
        long avoidBits = sig.getBits() ^ 0xFFFFFFFFFFFFFFFFL;
        long maxCount = Long.bitCount(testBits);
        for (ShapeEntry entry : typeShapes) {
            long combined;
            int count;
            long bits;
            if (entry.type == skipType || entry.approximate || ((bits = entry.signature.getBits()) & avoidBits) != 0L || (long)Long.bitCount(bits) > maxCount || (count = Long.bitCount(combined = bits & testBits)) <= bestCount) continue;
            bestIndex = entry.index;
            bestCount = count;
        }
        return bestIndex;
    }

    public int findSimilar(BlockType type, ShapeSignature sig) {
        if (type == null || type.getName() == null) {
            return 0;
        }
        return this.findSimilar(type.getName(), type, sig);
    }

    public CellArray createFacsimile(int blockTypeIndex) {
        ShapeEntry entry = this.shapes[blockTypeIndex];
        if (entry == null || entry.type == null || entry.collider == null) {
            return null;
        }
        return this.createFacsimile(entry.type, entry.collider);
    }

    public CellArray createFacsimile(BlockType block, Collider collider) {
        BlockName name = block.getName();
        List typeShapes = this.shapeIndex.get((Object)name.getBase());
        CellArray result = new CellArray(4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int child = this.findChildType(i, j, k, typeShapes, collider);
                    result.setCell(i, j, k, child);
                }
            }
        }
        MaskUtils.calculateSideMasks((CellArray)result);
        return result;
    }

    protected int findChildType(int x, int y, int z, List<ShapeEntry> typeShapes, Collider collider) {
        double xBase = (double)x * 0.25;
        double yBase = (double)y * 0.25;
        double zBase = (double)z * 0.25;
        double cellSpacing = 0.0625;
        double cellOffset = 0.03125;
        double probeRadius = 0.03124;
        Vec3d cellPos = new Vec3d();
        Vec3d pos = new Vec3d();
        ShapeSignature sig = new ShapeSignature(0L);
        for (int i = 0; i < 4; ++i) {
            pos.x = xBase + (double)i * cellSpacing + cellOffset;
            for (int j = 0; j < 4; ++j) {
                pos.y = yBase + (double)j * cellSpacing + cellOffset;
                for (int k = 0; k < 4; ++k) {
                    pos.z = zBase + (double)k * cellSpacing + cellOffset;
                    if (collider.getSphereContact(cellPos, pos, probeRadius, 255) == null) continue;
                    sig.set(i, j, k);
                }
            }
        }
        return this.findSimilar(typeShapes, null, sig);
    }

    private void buildSignatures() {
        double probeRadius = 0.124;
        for (ShapeEntry entry : this.shapes) {
            if (entry == null) continue;
            entry.calculateShapeSignature(probeRadius);
        }
    }

    private class ShapeEntry {
        BlockType type;
        Collider collider;
        ShapeSignature signature;
        int index;
        boolean approximate;

        public ShapeEntry(int index, BlockType type, Collider collider) {
            this.index = index;
            this.type = type;
            this.collider = collider;
            if (collider instanceof CylinderCollider) {
                this.approximate = true;
            } else if (collider instanceof CubeCollider) {
                this.approximate = ((CubeCollider)collider).isApproximate();
            }
        }

        protected void calculateShapeSignature(double probeRadius) {
            if (this.collider != null) {
                this.signature = ColliderUtils.calculateShapeSignature(this.collider, probeRadius);
            }
        }
    }
}

