/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.db.CellArrayId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.character.CharacterDecorator;
import mythruna.fabric.ClothingPainter;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.FabricType;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(ClothingDecorator.class);
    private AssetManager assets;
    private Function<CellArrayId, CellArray> cellStorage;
    private Spatial spatial;
    private List<Material> affectedMaterials = new ArrayList<Material>();
    private ShapeName name;
    private String modelPath;
    private ShapeName colorName;
    private FabricType clearBase;
    private ShapeName fabName;
    private CellArray cells;
    private volatile boolean needsApply;

    public ClothingDecorator(AssetManager assets, Function<CellArrayId, CellArray> cellStorage) {
        this.assets = assets;
        this.cellStorage = cellStorage;
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (this.spatial == spatial) {
            return;
        }
        this.spatial = spatial;
        this.affectedMaterials.clear();
        spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                log.info("geom:" + geom + "  material:" + mat);
                String matDefName = mat.getMaterialDef().getAssetName();
                String matName = mat.getName();
                if (!"SkinGrid".equals(matName)) {
                    return;
                }
                ClothingDecorator.this.affectedMaterials.add(mat);
            }
        });
        this.needsApply = true;
    }

    @Override
    public void setShapeName(ShapeName name) {
        ShapeName fabName;
        if (Objects.equals(this.name, name)) {
            return;
        }
        this.name = name;
        String modelPath = name.getName();
        int split = modelPath.lastIndexOf("/");
        if (split >= 0) {
            modelPath = modelPath.substring(0, split);
        }
        if ((fabName = this.find("fab", name)) != null) {
            this.setColorName(this.find("sc", name), modelPath);
            this.setFabName(fabName);
        }
    }

    protected void setColorName(ShapeName colorName, String modelPath) {
        if (Objects.equals(this.colorName, colorName) && Objects.equals(this.modelPath, modelPath)) {
            return;
        }
        this.colorName = colorName;
        log.info("************ shape path:" + modelPath);
        if (colorName != null) {
            int colorArgb = (int)Long.parseUnsignedLong(colorName.getName(), 16);
            ColorRGBA color = new ColorRGBA().fromIntARGB(colorArgb |= 0xFF000000);
            log.info("Skin color:" + color);
            this.clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture(modelPath + "/BaseSkin.png", color)).specular(new FabricTexture(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f)));
        } else {
            this.clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture(modelPath + "/BaseSkin.png")).specular(new FabricTexture(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f)));
        }
        this.clearBase.initialize(this.assets);
        this.needsApply = true;
    }

    protected void setFabName(ShapeName fabName) {
        if (this.cells != null && Objects.equals(this.fabName, fabName)) {
            return;
        }
        this.fabName = fabName;
        if (fabName != null) {
            CellArrayId id = CellArrayId.fromString((String)fabName.getName());
            log.info("loading clothing cell array:" + id);
            this.cells = this.cellStorage.apply(id);
        } else {
            log.info("creating naked cells");
            this.cells = new CellArray(32);
        }
        this.needsApply = true;
    }

    @Override
    public boolean apply() {
        if (!this.needsApply) {
            return false;
        }
        if (this.cells == null) {
            log.info("cells is null for:" + this.spatial + " with shape name:" + this.name);
            return false;
        }
        log.info("apply() skinColor:" + this.colorName + " fab:" + this.fabName);
        ClothingPainter painter = new ClothingPainter();
        painter.repaint((CellData)this.cells, this.clearBase);
        for (Material mat : this.affectedMaterials) {
            log.info("Applying clothing to:" + mat);
            mat.setTexture("DiffuseMap", painter.getDiffuseTexture());
            mat.setTexture("NormalMap", painter.getNormalTexture());
            mat.setTexture("SpecularMap", painter.getSpecularTexture());
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", ColorRGBA.White);
            mat.setColor("Ambient", ColorRGBA.White);
            mat.setColor("Specular", ColorRGBA.White);
            mat.setFloat("Shininess", 512.0f);
        }
        this.needsApply = false;
        return true;
    }

    protected ShapeName find(String type, ShapeName name) {
        if (type.equals(name.getType())) {
            return name;
        }
        for (ShapeName sub : name.getAddOns()) {
            if (!type.equals(sub.getType())) continue;
            return sub;
        }
        return null;
    }
}

