/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.fsm.StateMachine;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.PasswordField;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import java.util.HashMap;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.LoginState;
import mythruna.net.client.AccountClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAccountState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CreateAccountState.class);
    private static final String[] HELP = new String[]{"Enter new account information.", "", "User ID must be at least 3 characters.", "Passwords must by at least 8 characters.", "", "The plain text password and the answers to any", "security questions are never sent without being", "SHA-512 hashed on the client.  The server only", "sees and stores the one-way hash."};
    private StateMachine<String, String> fsm;
    private Vector2f guiSize;
    private Container createAccount;
    private TextField user;
    private PasswordField password;
    private PasswordField confirm;
    private ConnectionState connection;
    private AccountClientService account;
    private Container helpWindow;
    private Label help;

    public CreateAccountState(StateMachine<String, String> fsm) {
        this.fsm = fsm;
        this.setEnabled(false);
    }

    protected void showError(String title, String message) {
        ((OptionPanelState)this.getState(OptionPanelState.class)).show(title, message, new Action[0]);
    }

    protected void createAccount() {
        log.info("createAccount()");
        String userId = this.user.getText().trim();
        if (userId.length() < 3) {
            this.showError("Invalid User ID", "User ID must be at least 3 characters.");
            return;
        }
        String p1 = this.password.getText().trim();
        String p2 = this.confirm.getText().trim();
        if (p1.length() < 8) {
            this.showError("Invalid Password", "Password must be at least 8 characters.");
            return;
        }
        if (!p1.equals(p2)) {
            this.showError("Invalid Password", "Password and confirmation do not match.");
            return;
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("sha512", ((LoginState)this.getState(LoginState.class)).hash(p1));
        this.fsm.trigger((Object)"create");
        this.account.createAccount(userId, credentials, (success, message) -> {
            log.info("accountStatus(" + success + ", " + message + ")");
            if (success.booleanValue()) {
                this.getApplication().enqueue(() -> ((LoginState)this.getState(LoginState.class)).accountCreated(userId, p1));
            }
        });
    }

    protected void back() {
        log.info("back()");
        this.fsm.trigger((Object)"back");
    }

    protected void initialize(Application app) {
        this.connection = (ConnectionState)this.getState(ConnectionState.class);
        this.account = this.connection.getService(AccountClientService.class);
        this.createAccount = new Container(new ElementId("window"));
        this.createAccount.addChild((Node)new Label("Account Creation", new ElementId("window.title")), new Object[0]);
        Container props = (Container)this.createAccount.addChild((Node)new Container(), new Object[0]);
        props.setInsets(new Insets3f(5.0f, 5.0f, 5.0f, 5.0f));
        props.setBackground(null);
        props.addChild((Node)new Label("New User ID:"), new Object[0]);
        this.user = (TextField)props.addChild((Node)new TextField(""), new Object[]{1});
        this.user.setPreferredWidth(300.0f);
        props.addChild((Node)new Label(""), new Object[0]);
        props.addChild((Node)new Label("New Password:"), new Object[0]);
        this.password = (PasswordField)props.addChild((Node)new PasswordField(""), new Object[]{1});
        this.password.setPreferredWidth(300.0f);
        props.addChild((Node)new Label("Confirm Password:"), new Object[0]);
        this.confirm = (PasswordField)props.addChild((Node)new PasswordField(""), new Object[]{1});
        this.confirm.setPreferredWidth(300.0f);
        props.addChild((Node)new Label(""), new Object[0]);
        Container buttons = (Container)this.createAccount.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "createAccount")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "back")), new Object[0]);
        ElementId helpId = new ElementId("help");
        this.helpWindow = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even), helpId.child("window"));
        this.helpWindow.addChild((Node)new Label("Help", helpId.child("title")), new Object[0]);
        this.help = (Label)this.helpWindow.addChild((Node)new Label("This is where help goes.", helpId.child("label")), new Object[0]);
        this.resetHelp();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        GuiGlobals globals = GuiGlobals.getInstance();
        this.guiSize = globals.getPopupState().getGuiSize();
        globals.getPopupState().centerInGui((Spatial)this.createAccount);
        globals.getPopupState().showModalPopup((Spatial)this.createAccount, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        globals.getPopupState().getGuiNode().attachChild((Spatial)this.helpWindow);
        globals.requestFocus((Spatial)this.createAccount);
    }

    protected void onDisable() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this.createAccount);
        this.helpWindow.removeFromParent();
    }

    public void update(float tpf) {
        Vector3f size = this.createAccount.getSize();
        Vector3f helpSize = this.helpWindow.getSize();
        float width = helpSize.x + size.x;
        Vector3f loc = this.createAccount.getLocalTranslation();
        loc.x = this.guiSize.x * 0.5f - width * 0.5f;
        this.createAccount.setLocalTranslation(loc);
        this.helpWindow.setLocalTranslation(loc.x + size.x + 50.0f, loc.y + (helpSize.y - size.y) * 0.5f, loc.z);
    }

    protected void resetHelp() {
        String s = String.join((CharSequence)"\n", HELP);
        this.help.setText(s);
    }
}

