/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.LightUtils;
import mythruna.client.view.object.AbstractModel;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelFactory;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugAxesFactory
implements ModelFactory {
    static Logger log = LoggerFactory.getLogger(DebugAxesFactory.class);
    private Spatial axesTemplate;

    public DebugAxesFactory(Spatial axesTemplate) {
        this.axesTemplate = axesTemplate;
    }

    @Override
    public Model createModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
        return new DebugAxesModel(entityId, name, shapeInfo);
    }

    protected class DebugAxesModel
    extends AbstractModel {
        private Node viewRoot;
        private ColorRGBA diffuse;
        private ColorRGBA ambient;

        public DebugAxesModel(EntityId entityId, ShapeName name, ShapeInfo shapeInfo) {
            super(entityId, name, shapeInfo);
            this.diffuse = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
            this.ambient = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
            this.viewRoot = new Node("viewRoot:" + entityId);
            Spatial spatial = DebugAxesFactory.this.axesTemplate.clone(true);
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "Diffuse", (Object)this.diffuse));
            spatial.addMatParamOverride(new MatParamOverride(VarType.Vector4, "Ambient", (Object)this.ambient));
            spatial.setLocalScale(5.0f);
            this.viewRoot.attachChild(spatial);
            this.viewRoot.setCullHint(Spatial.CullHint.Always);
            this.updateSpatial((Spatial)this.viewRoot);
        }

        @Override
        public void setLighting(int lighting) {
            float s = (float)LightUtils.sun((int)lighting) / 15.0f;
            float r = (float)LightUtils.red((int)lighting) / 15.0f;
            float g = (float)LightUtils.green((int)lighting) / 15.0f;
            float b = (float)LightUtils.blue((int)lighting) / 15.0f;
            this.diffuse.set(s, s, s, 1.0f);
            this.ambient.set(r, g, b, 1.0f);
        }

        @Override
        public Vec3d getCenterOffset() {
            return Vec3d.ZERO;
        }
    }
}

