/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class ColliderType
implements Serializable {
    static final long serialVersionUID = 42L;
    private String name;
    private int rotation;

    public ColliderType(String name, int rotation) {
        this.name = name;
        this.rotation = rotation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toDisplay() {
        if (this.rotation < 0) {
            return this.name;
        }
        return this.name + ":" + this.rotation * 90;
    }

    public ColliderType rotate(int dirDelta) {
        if (this.rotation < 0) {
            return this;
        }
        if (dirDelta < 0 || dirDelta > 3) {
            throw new IllegalArgumentException("dirDelta is out of bounds:" + dirDelta);
        }
        return new ColliderType(this.name, (this.rotation + dirDelta) % 4);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rotation);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ColliderType other = (ColliderType)o;
        if (other.rotation != this.rotation) {
            return false;
        }
        return Objects.equals(other.name, this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("rotation", this.rotation).toString();
    }
}

