/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.jme3.math.Vector2f;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoundaryShapes {
    public static final BoundaryShape NULL_SHAPE = new NullShape();
    private static final ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
    private static final Map<BoundaryShape, Integer> shapeIndex = new HashMap<BoundaryShape, Integer>();
    private static final List<BoundaryShape> shapes = new ArrayList<BoundaryShape>();
    public static final BoundaryShape UNIT_SQUARE = BoundaryShapes.getRect(0.0, 0.0, 1.0, 1.0);

    private BoundaryShapes() {
    }

    public static BoundaryShape resolve(BoundaryShape shape) {
        indexLock.readLock().lock();
        try {
            Integer id;
            block10: {
                id = shapeIndex.get(shape);
                if (id != null) {
                    BoundaryShape boundaryShape = shapes.get(id);
                    return boundaryShape;
                }
                indexLock.readLock().unlock();
                indexLock.writeLock().lock();
                try {
                    id = shapeIndex.get(shape);
                    if (id == null) break block10;
                    BoundaryShape boundaryShape = shapes.get(id);
                    indexLock.writeLock().unlock();
                    return boundaryShape;
                }
                catch (Throwable throwable) {
                    indexLock.writeLock().unlock();
                    throw throwable;
                }
            }
            id = shapes.size();
            shapes.add(shape);
            shapeIndex.put(shape, id);
            indexLock.readLock().lock();
            BoundaryShape boundaryShape = shape;
            indexLock.writeLock().unlock();
            return boundaryShape;
        }
        finally {
            indexLock.readLock().unlock();
        }
    }

    public static BoundaryShape getRect(double xMin, double yMin, double xMax, double yMax) {
        if (xMin < 0.0 || yMin < 0.0) {
            throw new IllegalArgumentException("range out of bounds, min:" + xMin + ", " + yMin);
        }
        if (xMax > 1.0 || yMax > 1.0) {
            throw new IllegalArgumentException("range out of bounds, max:" + xMax + ", " + yMax);
        }
        return BoundaryShapes.resolve(new Rect(xMin, yMin, xMax, yMax));
    }

    public static BoundaryShape getTriangle(double xMin, double yMin, double xMax, double yMax, double xNormal, double yNormal) {
        return BoundaryShapes.resolve(new Triangle(xMin, yMin, xMax, yMax, xNormal, yNormal));
    }

    public static BoundaryShape getCircle(double xCenter, double yCenter, double radius) {
        return BoundaryShapes.resolve(new Circle(xCenter, yCenter, radius));
    }

    public static final BoundaryShape getBoxSide(Vec3d min, Vec3d max, Direction dir) {
        switch (dir) {
            case North: {
                if (min.z == 0.0) break;
                return null;
            }
            case South: {
                if (max.z == 1.0) break;
                return null;
            }
            case East: {
                if (max.x == 1.0) break;
                return null;
            }
            case West: {
                if (min.x == 0.0) break;
                return null;
            }
            case Up: {
                if (max.y == 1.0) break;
                return null;
            }
            case Down: {
                if (min.y == 0.0) break;
                return null;
            }
        }
        Vector2f low = BoundaryShapes.unprojectDir(min, dir);
        Vector2f high = BoundaryShapes.unprojectDir(max, dir);
        return BoundaryShapes.getRect(low.x, low.y, high.x, high.y);
    }

    protected static float quantize(double d) {
        long i = Math.round(d * 10000.0);
        float result = (float)i / 10000.0f;
        return result;
    }

    public static Vec3d projectPos(Vector2f v, Direction dir) {
        Vec3d result = new Vec3d();
        switch (dir) {
            case North: {
                result.x = v.x - 0.5f;
                result.y = v.y - 0.5f;
                result.z = -0.5;
                break;
            }
            case South: {
                result.x = v.x - 0.5f;
                result.y = v.y - 0.5f;
                result.z = 0.5;
                break;
            }
            case East: {
                result.x = 0.5;
                result.y = v.y - 0.5f;
                result.z = v.x - 0.5f;
                break;
            }
            case West: {
                result.x = -0.5;
                result.y = v.y - 0.5f;
                result.z = v.x - 0.5f;
                break;
            }
            case Up: {
                result.x = v.x - 0.5f;
                result.y = 0.5;
                result.z = v.y - 0.5f;
                break;
            }
            case Down: {
                result.x = v.x - 0.5f;
                result.y = -0.5;
                result.z = v.y - 0.5f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + (Object)((Object)dir));
            }
        }
        return result;
    }

    public static Vector2f unprojectPos(Vec3d v, Direction dir) {
        Vector2f result = new Vector2f();
        switch (dir) {
            case North: {
                result.x = BoundaryShapes.quantize(0.5 + v.x);
                result.y = BoundaryShapes.quantize(0.5 + v.y);
                break;
            }
            case South: {
                result.x = BoundaryShapes.quantize(0.5 + v.x);
                result.y = BoundaryShapes.quantize(0.5 + v.y);
                break;
            }
            case East: {
                result.x = BoundaryShapes.quantize(0.5 + v.z);
                result.y = BoundaryShapes.quantize(0.5 + v.y);
                break;
            }
            case West: {
                result.x = BoundaryShapes.quantize(0.5 + v.z);
                result.y = BoundaryShapes.quantize(0.5 + v.y);
                break;
            }
            case Up: {
                result.x = BoundaryShapes.quantize(0.5 + v.x);
                result.y = BoundaryShapes.quantize(0.5 + v.z);
                break;
            }
            case Down: {
                result.x = BoundaryShapes.quantize(0.5 + v.x);
                result.y = BoundaryShapes.quantize(0.5 + v.z);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + (Object)((Object)dir));
            }
        }
        return result;
    }

    public static Vec3d projectDir(Vector2f v, Direction dir) {
        Vec3d result = new Vec3d();
        switch (dir) {
            case North: {
                result.x = v.x;
                result.y = v.y;
                break;
            }
            case South: {
                result.x = v.x;
                result.y = v.y;
                break;
            }
            case East: {
                result.z = v.x;
                result.y = v.y;
                break;
            }
            case West: {
                result.z = v.x;
                result.y = v.y;
                break;
            }
            case Up: {
                result.x = v.x;
                result.z = v.y;
                break;
            }
            case Down: {
                result.x = v.x;
                result.z = v.y;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + (Object)((Object)dir));
            }
        }
        return result;
    }

    public static Vector2f unprojectDir(Vec3d v, Direction dir) {
        Vector2f result = new Vector2f();
        switch (dir) {
            case North: {
                result.x = BoundaryShapes.quantize(v.x);
                result.y = BoundaryShapes.quantize(v.y);
                break;
            }
            case South: {
                result.x = BoundaryShapes.quantize(v.x);
                result.y = BoundaryShapes.quantize(v.y);
                break;
            }
            case East: {
                result.x = BoundaryShapes.quantize(v.z);
                result.y = BoundaryShapes.quantize(v.y);
                break;
            }
            case West: {
                result.x = BoundaryShapes.quantize(v.z);
                result.y = BoundaryShapes.quantize(v.y);
                break;
            }
            case Up: {
                result.x = BoundaryShapes.quantize(v.x);
                result.y = BoundaryShapes.quantize(v.z);
                break;
            }
            case Down: {
                result.x = BoundaryShapes.quantize(v.x);
                result.y = BoundaryShapes.quantize(v.z);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + (Object)((Object)dir));
            }
        }
        return result;
    }

    public static class Circle
    extends AbstractShape {
        static final long serialVersionUID = 42L;
        private Vector2f center;
        private double radius;
        private double area;

        private Circle() {
        }

        public Circle(double xCenter, double yCenter, double radius) {
            this.center = new Vector2f(BoundaryShapes.quantize(xCenter), BoundaryShapes.quantize(yCenter));
            this.radius = radius;
            this.area = Math.PI * radius * radius;
        }

        @Override
        public List<Vector2f> getBorder() {
            ArrayList<Vector2f> results = new ArrayList<Vector2f>();
            int points = 8;
            double radDelta = Math.PI * 2 / (double)points;
            for (int i = 0; i < points; ++i) {
                double x = Math.cos((double)i * radDelta) * this.radius;
                double y = Math.sin((double)i * radDelta) * this.radius;
                results.add(new Vector2f(this.center).addLocal((float)x, (float)y));
            }
            return results;
        }

        @Override
        public BoundaryShape translate(Direction dir, double x, double y, double z) {
            Vec3d pCenter = BoundaryShapes.projectPos(this.center, dir);
            pCenter.x += x;
            pCenter.y += y;
            pCenter.z += z;
            Vector2f v = BoundaryShapes.unprojectPos(pCenter, dir);
            BoundaryShape result = BoundaryShapes.getCircle(v.x, v.y, this.radius);
            return result;
        }

        @Override
        public BoundaryShape scale(Direction dir, double xOrigin, double yOrigin, double zOrigin, double x, double y, double z) {
            Vec3d pCenter = BoundaryShapes.projectPos(this.center, dir);
            pCenter.x = xOrigin + (pCenter.x + 0.5 - xOrigin) * x - 0.5;
            pCenter.y = yOrigin + (pCenter.y + 0.5 - yOrigin) * y - 0.5;
            pCenter.z = zOrigin + (pCenter.z + 0.5 - zOrigin) * z - 0.5;
            Vector2f pScale = BoundaryShapes.unprojectDir(new Vec3d(x, y, z), dir);
            if (pScale.x != pScale.y) {
                throw new RuntimeException("Non-uniform scaling in circle plane:" + pScale);
            }
            double newRadius = this.radius * (double)pScale.x;
            Vector2f v = BoundaryShapes.unprojectPos(pCenter, dir);
            BoundaryShape result = BoundaryShapes.getCircle(v.x, v.y, newRadius);
            return result;
        }

        @Override
        public BoundaryShape rotate(Direction dir, int dirDelta) {
            Vec3d pCenter = BoundaryShapes.projectPos(this.center, dir);
            Quatd rot = Direction.getRotation(dirDelta);
            pCenter = rot.mult(pCenter);
            Direction newDir = dir.rotate(dirDelta);
            Vector2f v1 = BoundaryShapes.unprojectPos(pCenter, newDir);
            BoundaryShape result = BoundaryShapes.getCircle(v1.x, v1.y, this.radius);
            return result;
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        @Override
        public double getArea() {
            return this.area;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.center, this.radius);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Circle other = (Circle)o;
            if (!Objects.equals(other.center, this.center)) {
                return false;
            }
            return Double.compare(other.radius, this.radius) == 0;
        }

        public String toString() {
            return "Circle[" + this.center + ", " + this.radius + "]";
        }
    }

    public static class Triangle
    extends AbstractShape {
        static final long serialVersionUID = 42L;
        private Vector2f min;
        private Vector2f max;
        private Vector2f normal;
        private double area;

        private Triangle() {
        }

        public Triangle(double xMin, double yMin, double xMax, double yMax, double xNormal, double yNormal) {
            this.min = new Vector2f(BoundaryShapes.quantize(xMin), BoundaryShapes.quantize(yMin));
            this.max = new Vector2f(BoundaryShapes.quantize(xMax), BoundaryShapes.quantize(yMax));
            this.normal = new Vector2f(BoundaryShapes.quantize(xNormal), BoundaryShapes.quantize(yNormal));
            this.area = (xMax - xMin) * (yMax - yMin) * 0.5;
        }

        public Vector2f getMin() {
            return this.min;
        }

        public Vector2f getMax() {
            return this.max;
        }

        public Vector2f getNormal() {
            return this.normal;
        }

        @Override
        public List<Vector2f> getBorder() {
            ArrayList<Vector2f> results = new ArrayList<Vector2f>();
            if (!(this.normal.x < 0.0f) || !(this.normal.y < 0.0f)) {
                results.add(this.min);
            }
            if (!(this.normal.x > 0.0f) || !(this.normal.y < 0.0f)) {
                results.add(new Vector2f(this.max.x, this.min.y));
            }
            if (!(this.normal.x > 0.0f) || !(this.normal.y > 0.0f)) {
                results.add(this.max);
            }
            if (!(this.normal.x < 0.0f) || !(this.normal.y > 0.0f)) {
                results.add(new Vector2f(this.min.x, this.max.y));
            }
            return results;
        }

        @Override
        public BoundaryShape translate(Direction dir, double x, double y, double z) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            Vec3d pNorm = BoundaryShapes.projectDir(this.normal, dir);
            pMin.x += x;
            pMin.y += y;
            pMin.z += z;
            pMax.x += x;
            pMax.y += y;
            pMax.z += z;
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, dir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, dir);
            Vector2f n = BoundaryShapes.unprojectPos(pNorm, dir);
            return BoundaryShapes.getTriangle(v1.x, v1.y, v2.x, v2.y, n.x, n.y);
        }

        @Override
        public BoundaryShape scale(Direction dir, double xOrigin, double yOrigin, double zOrigin, double x, double y, double z) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            pMin.x = xOrigin + (pMin.x + 0.5 - xOrigin) * x - 0.5;
            pMin.y = yOrigin + (pMin.y + 0.5 - yOrigin) * y - 0.5;
            pMin.z = zOrigin + (pMin.z + 0.5 - zOrigin) * z - 0.5;
            pMax.x = xOrigin + (pMax.x + 0.5 - xOrigin) * x - 0.5;
            pMax.y = yOrigin + (pMax.y + 0.5 - yOrigin) * y - 0.5;
            pMax.z = zOrigin + (pMax.z + 0.5 - zOrigin) * z - 0.5;
            Vector2f pScale = BoundaryShapes.unprojectDir(new Vec3d(x, y, z), dir);
            Vector2f n = new Vector2f(this.normal.x * pScale.y, this.normal.y * pScale.x).normalizeLocal();
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, dir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, dir);
            BoundaryShape result = BoundaryShapes.getTriangle(v1.x, v1.y, v2.x, v2.y, n.x, n.y);
            return result;
        }

        @Override
        public BoundaryShape rotate(Direction dir, int dirDelta) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            Vec3d pNorm = BoundaryShapes.projectDir(this.normal, dir);
            Quatd rot = Direction.getRotation(dirDelta);
            pMin = rot.mult(pMin);
            pMax = rot.mult(pMax);
            pNorm = rot.mult(pNorm);
            Direction newDir = dir.rotate(dirDelta);
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, newDir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, newDir);
            Vector2f n = BoundaryShapes.unprojectDir(pNorm, newDir);
            BoundaryShape result = BoundaryShapes.getTriangle(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), n.x, n.y);
            return result;
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        @Override
        public double getArea() {
            return this.area;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.min, this.max, this.normal);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Triangle other = (Triangle)o;
            if (!Objects.equals(other.min, this.min)) {
                return false;
            }
            if (!Objects.equals(other.max, this.max)) {
                return false;
            }
            return Objects.equals(other.normal, this.normal);
        }

        public String toString() {
            return "Triangle[" + this.min + ", " + this.max + ", norm:" + this.normal + "]";
        }
    }

    public static class Rect
    extends AbstractShape {
        static final long serialVersionUID = 42L;
        private Vector2f min;
        private Vector2f max;
        private double area;

        private Rect() {
        }

        public Rect(double xMin, double yMin, double xMax, double yMax) {
            this.min = new Vector2f(BoundaryShapes.quantize(xMin), BoundaryShapes.quantize(yMin));
            this.max = new Vector2f(BoundaryShapes.quantize(xMax), BoundaryShapes.quantize(yMax));
            this.area = (xMax - xMin) * (yMax - yMin);
        }

        @Override
        public List<Vector2f> getBorder() {
            ArrayList<Vector2f> results = new ArrayList<Vector2f>();
            results.add(this.min);
            results.add(new Vector2f(this.max.x, this.min.y));
            results.add(this.max);
            results.add(new Vector2f(this.min.x, this.max.y));
            return results;
        }

        @Override
        public double getArea() {
            return this.area;
        }

        @Override
        public BoundaryShape translate(Direction dir, double x, double y, double z) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            pMin.x += x;
            pMin.y += y;
            pMin.z += z;
            pMax.x += x;
            pMax.y += y;
            pMax.z += z;
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, dir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, dir);
            return BoundaryShapes.getRect(v1.x, v1.y, v2.x, v2.y);
        }

        @Override
        public BoundaryShape scale(Direction dir, double xOrigin, double yOrigin, double zOrigin, double x, double y, double z) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            pMin.x = xOrigin + (pMin.x + 0.5 - xOrigin) * x - 0.5;
            pMin.y = yOrigin + (pMin.y + 0.5 - yOrigin) * y - 0.5;
            pMin.z = zOrigin + (pMin.z + 0.5 - zOrigin) * z - 0.5;
            pMax.x = xOrigin + (pMax.x + 0.5 - xOrigin) * x - 0.5;
            pMax.y = yOrigin + (pMax.y + 0.5 - yOrigin) * y - 0.5;
            pMax.z = zOrigin + (pMax.z + 0.5 - zOrigin) * z - 0.5;
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, dir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, dir);
            return BoundaryShapes.getRect(v1.x, v1.y, v2.x, v2.y);
        }

        @Override
        public BoundaryShape rotate(Direction dir, int dirDelta) {
            Vec3d pMin = BoundaryShapes.projectPos(this.min, dir);
            Vec3d pMax = BoundaryShapes.projectPos(this.max, dir);
            Quatd rot = Direction.getRotation(dirDelta);
            pMin = rot.mult(pMin);
            pMax = rot.mult(pMax);
            Direction newDir = dir.rotate(dirDelta);
            Vector2f v1 = BoundaryShapes.unprojectPos(pMin, newDir);
            Vector2f v2 = BoundaryShapes.unprojectPos(pMax, newDir);
            return BoundaryShapes.getRect(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.max(v1.x, v2.x), Math.max(v1.y, v2.y));
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.min, this.max);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Rect other = (Rect)o;
            if (!Objects.equals(other.min, this.min)) {
                return false;
            }
            return Objects.equals(other.max, this.max);
        }

        public String toString() {
            return "Rect[" + this.min + ", " + this.max + "]";
        }
    }

    public static class NullShape
    extends AbstractShape {
        static final long serialVersionUID = 42L;

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return false;
        }

        @Override
        public BoundaryShape translate(Direction dir, double x, double y, double z) {
            return this;
        }

        @Override
        public BoundaryShape rotate(Direction dir, int dirDelta) {
            return this;
        }

        @Override
        public BoundaryShape scale(Direction dir, double xOrigin, double yOrigin, double zOrigin, double x, double y, double z) {
            return this;
        }

        @Override
        public double getArea() {
            return 0.0;
        }

        @Override
        public List<Vector2f> getBorder() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o.getClass() == this.getClass();
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        public String toString() {
            return "NULL_SHAPE";
        }
    }

    private static abstract class AbstractShape
    implements BoundaryShape {
        static final long serialVersionUID = 42L;

        private AbstractShape() {
        }

        protected Object readResolve() throws ObjectStreamException {
            return BoundaryShapes.resolve(this);
        }
    }
}

