/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyTypeAdapterFactory<T>
implements TypeAdapterFactory {
    static Logger log = LoggerFactory.getLogger(PolyTypeAdapterFactory.class);
    public static final String TYPE_FIELD = "_className";
    private Class<T> baseType;

    public PolyTypeAdapterFactory(Class<T> baseType) {
        this.baseType = baseType;
    }

    public static <T> PolyTypeAdapterFactory create(Class<T> baseType) {
        return new PolyTypeAdapterFactory<T>(baseType);
    }

    protected T resolve(T value) {
        return value;
    }

    public <S> TypeAdapter<S> create(Gson gson, TypeToken<S> type) {
        if (this.baseType != type.getRawType()) {
            return null;
        }
        return new SubtypeAdapter(gson);
    }

    protected Class getSubtype(JsonElement element) {
        if (element == null) {
            throw new JsonParseException("No type element found for:" + this.baseType);
        }
        String name = element.getAsString();
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("No class found for:" + name + ", element type:" + this.baseType);
        }
    }

    protected String getSubtypeName(Class type) {
        return type.getName();
    }

    private class SubtypeAdapter<S>
    extends TypeAdapter<S> {
        private Gson gson;

        public SubtypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public S read(JsonReader in) throws IOException {
            JsonElement jsonElement = Streams.parse((JsonReader)in);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            Class subtype = PolyTypeAdapterFactory.this.getSubtype(jsonElement.getAsJsonObject().remove(PolyTypeAdapterFactory.TYPE_FIELD));
            TypeAdapter delegate = this.gson.getDelegateAdapter((TypeAdapterFactory)PolyTypeAdapterFactory.this, TypeToken.get((Class)subtype));
            if (delegate == null) {
                throw new JsonParseException("No delegate type found for:" + subtype);
            }
            Object result = delegate.fromJsonTree(jsonElement);
            result = PolyTypeAdapterFactory.this.resolve(result);
            return (S)result;
        }

        public void write(JsonWriter out, S value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            Class<?> subtype = value.getClass();
            TypeAdapter delegate = this.gson.getDelegateAdapter((TypeAdapterFactory)PolyTypeAdapterFactory.this, TypeToken.get(subtype));
            if (delegate == null) {
                throw new JsonParseException("No delegate type found for:" + subtype);
            }
            String name = PolyTypeAdapterFactory.this.getSubtypeName(subtype);
            JsonObject jsonObject = delegate.toJsonTree(value).getAsJsonObject();
            jsonObject.addProperty(PolyTypeAdapterFactory.TYPE_FIELD, name);
            Streams.write((JsonElement)jsonObject, (JsonWriter)out);
        }
    }
}

