/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.google.common.base.MoreObjects;
import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.io.Serializable;
import java.util.Objects;
import mythruna.fabric.FabricPaintTarget;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.SwatchShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(FabricType.class);
    private static final long serialVersionUID = 42L;
    public static final ColorRGBA DEFAULT_NORMAL = new ColorRGBA(0.5f, 0.5f, 1.0f, 1.0f);
    public static final ColorRGBA DEFAULT_SPECULAR = ColorRGBA.Blue;
    private String name;
    private String variation;
    private FabricTexture diffuse;
    private FabricTexture normal;
    private FabricTexture specular;
    private FabricTexture emission;

    private FabricType() {
    }

    public FabricType(String name, String variation) {
        this.name = name;
        this.variation = variation;
    }

    public void initialize(AssetManager assetManager) {
        if (this.diffuse != null) {
            this.diffuse.initialize(assetManager);
        }
        if (this.normal != null) {
            this.normal.initialize(assetManager);
        }
        if (this.specular != null) {
            this.specular.initialize(assetManager);
        }
        if (this.emission != null) {
            this.emission.initialize(assetManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVariation() {
        return this.variation;
    }

    public String getFullName() {
        return this.name + ":" + this.variation;
    }

    public FabricType diffuse(FabricTexture diffuse) {
        this.setDiffuse(diffuse);
        return this;
    }

    public FabricType normal(FabricTexture normal) {
        this.setNormal(normal);
        return this;
    }

    public FabricType specular(FabricTexture specular) {
        this.setSpecular(specular);
        return this;
    }

    public FabricType emission(FabricTexture emission) {
        this.setEmission(emission);
        return this;
    }

    public void setDiffuse(FabricTexture diffuse) {
        this.diffuse = diffuse;
    }

    public FabricTexture getDiffuse() {
        return this.diffuse;
    }

    public void setNormal(FabricTexture normal) {
        this.normal = normal;
    }

    public FabricTexture getNormal() {
        return this.normal;
    }

    public void setSpecular(FabricTexture specular) {
        this.specular = specular;
    }

    public FabricTexture getSpecular() {
        return this.specular;
    }

    public void setEmission(FabricTexture emission) {
        this.emission = emission;
    }

    public FabricTexture getEmission() {
        return this.emission;
    }

    protected int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    protected ColorRGBA combineNormals(ColorRGBA base, ColorRGBA detail) {
        Vector3f result = new Vector3f(base.r * 2.0f - 1.0f, base.g * 2.0f - 1.0f, base.b * 2.0f - 1.0f);
        result.x += detail.r * 2.0f - 1.0f;
        result.y += detail.g * 2.0f - 1.0f;
        result.normalizeLocal();
        float h = base.a * detail.a;
        return new ColorRGBA((result.x + 1.0f) * 0.5f, (result.y + 1.0f) * 0.5f, (result.z + 1.0f) * 0.5f, h);
    }

    public void paint(FabricPaintTarget target, int x, int y, SwatchShape shape) {
        ColorRGBA maskColor = new ColorRGBA(DEFAULT_NORMAL);
        ColorRGBA baseColor = new ColorRGBA();
        ColorRGBA normalColor = new ColorRGBA(DEFAULT_NORMAL);
        ColorRGBA specularColor = new ColorRGBA();
        boolean debug = false;
        if (debug) {
            log.info("paint(" + x + ", " + y + ", " + shape + ") this:" + this);
            log.info("specular:" + this.specular);
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int u = x + i;
                int v = y + j;
                if (shape != null) {
                    maskColor = shape.getPixel(i, j, maskColor);
                    if (maskColor.a == 0.0f) continue;
                    if (debug) {
                        log.info("[" + i + "][" + j + "] mask:" + maskColor);
                    }
                } else {
                    maskColor.set(DEFAULT_NORMAL);
                }
                baseColor = this.diffuse.getPixel(u, v, baseColor);
                if (this.normal != null) {
                    normalColor = this.normal.getPixel(u, v, normalColor);
                } else {
                    normalColor.set(DEFAULT_NORMAL);
                }
                float alpha = baseColor.a * maskColor.a * normalColor.a;
                if (this.specular != null) {
                    specularColor = this.specular.getPixel(u, v, specularColor);
                } else {
                    specularColor.set(DEFAULT_SPECULAR);
                }
                normalColor = this.combineNormals(maskColor, normalColor);
                if (debug && shape == null) {
                    log.info("[" + i + "][" + j + "]\tbase:" + baseColor + "\tmask:" + maskColor + "\tnorm:" + normalColor + "\tspec:" + specularColor);
                }
                target.paint(u, v, baseColor, normalColor, specularColor, alpha);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FabricType other = (FabricType)o;
        if (!Objects.equals(other.name, this.name)) {
            return false;
        }
        if (!Objects.equals(other.variation, this.variation)) {
            return false;
        }
        if (!Objects.equals(other.diffuse, this.diffuse)) {
            return false;
        }
        if (!Objects.equals(other.normal, this.normal)) {
            return false;
        }
        if (!Objects.equals(other.specular, this.specular)) {
            return false;
        }
        return Objects.equals(other.emission, this.emission);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.variation, this.diffuse, this.normal, this.specular, this.emission);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("name", (Object)this.name).add("variation", (Object)this.variation).add("diffuse", (Object)this.diffuse).add("normal", (Object)this.normal).add("specular", (Object)this.specular).add("emission", (Object)this.emission).toString();
    }
}

