/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.sim;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.crig.RigListener;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.es.MixConfig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ethereal.zone.ZoneManager;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.ext.mphys.net.ZoneNetworkListener;
import com.simsilica.ext.mphys.net.ZoneNetworkSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterAnimationSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(CharacterAnimationSystem.class);
    private EntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private ZoneManager zones;
    private ZoneNetworkObserver zoneObserver = new ZoneNetworkObserver();
    private PhysicsObserver physicsObserver = new PhysicsObserver();
    private Set<AnimatedCharacter> removeFromZones = new HashSet<AnimatedCharacter>();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private EntityChangeObserver entityChangeObserver = new EntityChangeObserver();
    private Multimap<EntityId, AnimatedCharacter> bodyIndex = MultimapBuilder.hashKeys().hashSetValues().build();
    private Map<EntityId, AnimatedCharacter> charIndex = new HashMap<EntityId, AnimatedCharacter>();
    private DynArray<AnimatedCharacter> characters = new DynArray(AnimatedCharacter.class);

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.space = this.physics.getPhysicsSpace();
        this.zones = ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).getZones();
        ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).addZoneNetworkListener((ZoneNetworkListener)this.zoneObserver);
        this.physics.getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.physicsObserver);
    }

    protected void terminate() {
        ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).removeZoneNetworkListener((ZoneNetworkListener)this.zoneObserver);
        this.physics.getBinEntityManager().removeObjectStatusListener((ObjectStatusListener)this.physicsObserver);
    }

    public void start() {
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityChangeObserver);
    }

    public void update(SimTime time) {
        EntityChange change = null;
        while ((change = this.changes.poll()) != null) {
            this.processChange(change);
        }
    }

    public void stop() {
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityChangeObserver);
    }

    protected void processChange(EntityChange change) {
        if (change.getComponentType() != AnimationConfig.class) {
            return;
        }
        AnimationConfig animConfig = (AnimationConfig)change.getComponent();
        if (animConfig == null) {
            AnimatedCharacter ac = this.charIndex.get(change.getEntityId());
            if (ac == null) {
                return;
            }
            if (this.bodyIndex.remove((Object)ac.targetEntity, (Object)ac)) {
                this.removeCharacter(ac);
            }
        } else {
            AnimatedCharacter ac = this.charIndex.get(change.getEntityId());
            if (ac == null) {
                RigidBody body = this.space.getBinIndex().getRigidBody((Object)animConfig.getTarget());
                if (body != null) {
                    this.addCharacter(animConfig.getTarget(), (RigidBody<EntityId, MBlockShape>)body, change.getEntityId());
                }
            } else {
                ac.update(animConfig);
            }
        }
    }

    protected void addCharacter(EntityId target, RigidBody<EntityId, MBlockShape> body, EntityId animId) {
        log.info("addAnimatedCharacter(" + target + ")");
        AnimationConfig config = (AnimationConfig)this.ed.getComponent(animId, AnimationConfig.class);
        AnimatedCharacter ac = new AnimatedCharacter(animId, config);
        ac.initialize(body);
        ac.updateState();
        this.characters.add((Object)ac);
        this.bodyIndex.put((Object)target, (Object)ac);
        this.charIndex.put(animId, ac);
    }

    protected void removeCharacter(AnimatedCharacter ac) {
        log.info("removeAnimatedCharacter(" + ac + ")");
        this.characters.remove((Object)ac);
        this.charIndex.remove(ac.animEntity);
        ac.release();
        this.removeFromZones.add(ac);
    }

    protected void updateNetworkData(long frameTime) {
        if (!this.removeFromZones.isEmpty()) {
            for (AnimatedCharacter ac : this.removeFromZones) {
                this.zones.remove(Long.valueOf(ac.animEntity.getId()));
            }
            this.removeFromZones.clear();
        }
        for (AnimatedCharacter ac : (AnimatedCharacter[])this.characters.getArray()) {
            ac.updateTimesAndMixes();
            this.zones.updateEntity(Long.valueOf(ac.targetEntity.getId()), Long.valueOf(ac.animEntity.getId()), true, ac.times, ac.mixes, ac.body.getWorldBounds());
            ac.pos.addFrame(frameTime, ac.targetEntity, ac.times, ac.mixes, true);
        }
    }

    private class ZoneNetworkObserver
    implements ZoneNetworkListener {
        private long frameTime;

        private ZoneNetworkObserver() {
        }

        public void beginUpdate(long frameTime) {
            this.frameTime = frameTime;
        }

        public void endUpdate() {
            CharacterAnimationSystem.this.updateNetworkData(this.frameTime);
        }
    }

    private class PhysicsObserver
    extends ObjectStatusAdapter<MBlockShape> {
        public void objectLoaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            if (log.isTraceEnabled()) {
                log.trace("objectLoaded(" + entity + ") body shape:" + body.shape);
            }
            if (!(body.shape instanceof RigShape)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Searching for anim config entities for:" + entity);
            }
            ComponentFilter filter = Filters.fieldEquals(AnimationConfig.class, (String)"target", (Object)entity);
            for (EntityId animId : CharacterAnimationSystem.this.ed.findEntities(filter, new Class[]{AnimationConfig.class})) {
                CharacterAnimationSystem.this.addCharacter(entity, body, animId);
            }
        }

        public void objectUnloaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            if (log.isTraceEnabled()) {
                log.trace("objectUnloaded(" + entity + ")");
            }
            if (!(body.shape instanceof RigShape)) {
                return;
            }
            for (AnimatedCharacter ac : CharacterAnimationSystem.this.bodyIndex.removeAll((Object)entity)) {
                CharacterAnimationSystem.this.removeCharacter(ac);
            }
        }
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != AnimationConfig.class) {
                return;
            }
            CharacterAnimationSystem.this.changes.add(change);
        }
    }

    private class AnimatedCharacter
    implements RigListener {
        private EntityId targetEntity;
        private EntityId animEntity;
        private AnimationConfig config;
        private RigidBody<EntityId, MBlockShape> body;
        private RigShape rig;
        private Vec3d times = new Vec3d();
        private Quatd mixes = new Quatd();
        private BodyPosition pos;

        public AnimatedCharacter(EntityId animEntity, AnimationConfig config) {
            this.animEntity = animEntity;
            this.config = config;
            this.targetEntity = config.getTarget();
            this.pos = (BodyPosition)CharacterAnimationSystem.this.ed.getComponent(animEntity, BodyPosition.class);
            if (this.pos == null) {
                this.pos = new BodyPosition(3);
                CharacterAnimationSystem.this.ed.setComponent(animEntity, (EntityComponent)this.pos);
            }
        }

        public void initialize(RigidBody<EntityId, MBlockShape> body) {
            this.body = body;
            this.rig = (RigShape)body.shape;
            this.rig.addRigListener(this);
        }

        public void release() {
            this.rig.removeRigListener(this);
            log.info("Removing BodyPosition for:" + this.animEntity);
            CharacterAnimationSystem.this.ed.removeComponent(this.animEntity, BodyPosition.class);
            this.rig = null;
            this.pos = null;
        }

        public void updateState() {
            int timeIndex = 0;
            int mixIndex = 0;
            for (LayerConfig lc : this.config.getLayers()) {
                this.times.set(timeIndex++, this.rig.getTime(lc.getLayer()));
                String action = this.rig.getLayerAction(lc.getLayer());
                this.mixes.set(mixIndex++, lc.getPart(action));
            }
            for (MixConfig mc : this.config.getMixes()) {
                this.mixes.set(mixIndex++, this.rig.getMix(mc.getBlendName()));
            }
        }

        public void update(AnimationConfig config) {
            if (!Objects.equals(this.config.getTarget(), config.getTarget())) {
                throw new UnsupportedOperationException("Rehoming an AnimationConfig is not supported, targetEntity:" + this.targetEntity + " old:" + this.config + " new:" + config);
            }
            this.config = config;
            this.updateState();
        }

        @Override
        public void mixChanged(String blendId, double value) {
        }

        public void updateTimesAndMixes() {
            int timeIndex = 0;
            int mixIndex = 0;
            for (LayerConfig lc : this.config.getLayers()) {
                this.times.set(timeIndex++, this.rig.getTime(lc.getLayer()));
                ++mixIndex;
            }
            for (MixConfig mc : this.config.getMixes()) {
                this.mixes.set(mixIndex++, this.rig.getMix(mc.getBlendName()));
            }
        }

        public void timeChanged(String layer, double time) {
            int index = 0;
            for (LayerConfig lc : this.config.getLayers()) {
                if (Objects.equals(layer, lc.getLayer())) {
                    this.times.set(index, time);
                }
                ++index;
            }
        }

        @Override
        public void layerActionChanged(String layer, String action) {
            int index = 0;
            for (LayerConfig lc : this.config.getLayers()) {
                if (Objects.equals(layer, lc.getLayer())) {
                    this.mixes.set(index, lc.getPart(action));
                }
                ++index;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target:" + this.targetEntity + "]";
        }
    }
}

