/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.ColliderType;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.AngleCollider;
import com.simsilica.mblock.phys.collision.ColliderFactory;
import com.simsilica.mblock.phys.collision.CubeCollider;
import com.simsilica.mblock.phys.collision.CylinderCollider;
import com.simsilica.mblock.phys.collision.SphereCollider;
import com.simsilica.mblock.phys.collision.WedgeCollider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderFactories {
    static Logger log = LoggerFactory.getLogger(ColliderFactories.class);
    private Map<String, ColliderFactory> registry = new HashMap<String, ColliderFactory>();

    public ColliderFactories() {
        this(false);
    }

    public ColliderFactories(boolean initDefaults) {
        if (initDefaults) {
            this.initializeDefaults();
        }
    }

    public void initializeDefaults() {
        this.register("cube", new CubeColliderFactory());
        this.register("wedge", new WedgeColliderFactory());
        this.register("wide-wedge", new WedgeColliderFactory());
        this.register("hi-wedge", new WedgeColliderFactory());
        this.register("wedge-corner", new CubeColliderFactory(true));
        this.register("angle", new AngleColliderFactory());
        this.register("vcyl", new CylinderColliderFactory(Vec3d.UNIT_Y, Vec3d.UNIT_X, Vec3d.UNIT_Z));
        this.register("hcyl", new CubeColliderFactory(true));
        this.register("shallow-corner", new CubeColliderFactory(true));
        this.register("hi-wedge-corner", new CubeColliderFactory(true));
        this.register("sphere", new SphereColliderFactory());
    }

    public void register(String name, ColliderFactory factory) {
        this.registry.put(name, factory);
    }

    public Collider[] createColliders(BlockType[] types) {
        Collider[] result = new Collider[types.length];
        for (int i = 0; i < result.length; ++i) {
            BlockName name;
            result[i] = this.createCollider(types[i]);
            BlockName blockName = name = types[i] != null ? types[i].getName() : null;
            if (!log.isTraceEnabled()) continue;
            log.trace("types[" + i + "]=" + name + "   collider:" + result[i]);
        }
        return result;
    }

    public Collider createCollider(BlockType type) {
        if (type == null) {
            return null;
        }
        ColliderType colliderType = type.getColliderType();
        if (colliderType == null) {
            return null;
        }
        ColliderFactory factory = this.registry.get(colliderType.getName());
        if (factory == null) {
            throw new IllegalArgumentException("No factory found for:" + colliderType.getName());
        }
        Collider result = factory.createCollider(type);
        return result;
    }

    public static class CylinderColliderFactory
    implements ColliderFactory {
        private Vec3d axisDir;
        private Vec3d xDir;
        private Vec3d yDir;

        public CylinderColliderFactory(Vec3d axisDir, Vec3d xDir, Vec3d yDir) {
            this.axisDir = axisDir;
            this.xDir = xDir;
            this.yDir = yDir;
        }

        @Override
        public Collider createCollider(BlockType type) {
            Vec3d y;
            Vec3d x;
            Integer rotation = type.getName().getRotation();
            if (rotation == null) {
                Vec3d dir = this.axisDir;
                x = this.xDir;
                y = this.yDir;
            } else {
                Quatd rot = Direction.getRotation((int)rotation);
                Vec3d dir = rot.mult(this.axisDir);
                x = rot.mult(this.xDir);
                y = rot.mult(this.yDir);
            }
            double x1 = x.dot(type.getFactory().getMin());
            double y1 = y.dot(type.getFactory().getMin());
            double z1 = this.axisDir.dot(type.getFactory().getMin());
            double x2 = x.dot(type.getFactory().getMax());
            double y2 = y.dot(type.getFactory().getMax());
            double z2 = this.axisDir.dot(type.getFactory().getMax());
            Vec3d center = new Vec3d(x1, y1, z1).addLocal(x2, y2, z2).multLocal(0.5);
            double extent = Math.abs(z2 - center.z);
            double radius = Math.abs(x1 - center.x);
            return new CylinderCollider(center, this.axisDir, x, y, extent, radius);
        }
    }

    public static class AngleColliderFactory
    implements ColliderFactory {
        @Override
        public Collider createCollider(BlockType type) {
            return new AngleCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().getRotation(), type.getName().toString());
        }
    }

    public static class WedgeColliderFactory
    implements ColliderFactory {
        private static Direction[] dirs = Direction.values();

        @Override
        public Collider createCollider(BlockType type) {
            BoundaryShapes.Triangle tri = null;
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.cardinalDirection((int)i);
                BoundaryShape shape = type.getShape(dir);
                if (!(shape instanceof BoundaryShapes.Triangle)) continue;
                tri = (BoundaryShapes.Triangle)shape;
                break;
            }
            if (tri == null) {
                throw new IllegalArgumentException("Block type does not have triangle shaped sides:" + type);
            }
            Direction up = tri.getNormal().y < 0.0f ? Direction.Down : Direction.Up;
            return new WedgeCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().getRotation(), up, tri, type.getName().toString());
        }
    }

    public static class SphereColliderFactory
    implements ColliderFactory {
        @Override
        public Collider createCollider(BlockType type) {
            return new SphereCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().toString());
        }
    }

    public static class CubeColliderFactory
    implements ColliderFactory {
        private boolean approximate;

        public CubeColliderFactory() {
        }

        public CubeColliderFactory(boolean approximate) {
            this.approximate = approximate;
        }

        @Override
        public Collider createCollider(BlockType type) {
            return new CubeCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().toString(), this.approximate);
        }
    }
}

