/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.props.PropertyPanel;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.sim.BlackboardListener;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.MessageState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.PostProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSettingsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GameSettingsState.class);
    private Container window;
    private TabbedPanel tabs;
    private BlackboardState blackboard;
    private SettingsListener settingsListener = new SettingsListener();
    private MythrunaConfig config;
    private Container rendering;
    private Container debugPanel;
    private boolean centered = true;
    private VersionedReference<TabbedPanel.Tab> currentTabRef;
    private VersionedHolder<Boolean> invertY = new VersionedHolder((Object)Boolean.FALSE);
    private Checkbox mute;
    private Slider music;
    private Slider effects;
    private Slider ambient;
    private UserInterfaceSettings uiSettings = new UserInterfaceSettings();
    private List<SettingsUpdater> updaters = new ArrayList<SettingsUpdater>();
    private boolean saveSettings;
    private RadioGroup postProcGroup = new RadioGroup();

    public GameSettingsState() {
        this.setEnabled(false);
    }

    public void setCentered(boolean centered) {
        if (this.centered == centered) {
            return;
        }
        this.centered = centered;
        this.resetPosition();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public Container getDebugPanel() {
        return this.debugPanel;
    }

    public void setInvertY(boolean f) {
        this.invertY.setObject((Object)f);
    }

    public boolean getInvertY() {
        return (Boolean)this.invertY.getObject();
    }

    public VersionedReference<Boolean> createInvertYRef() {
        return this.invertY.createReference();
    }

    public VersionedReference<Boolean> createMuteReference() {
        return this.mute.getModel().createReference();
    }

    public VersionedReference<Double> createMusicVolumeReference() {
        return this.music.getModel().createReference();
    }

    public VersionedReference<Double> createEffectsVolumeReference() {
        return this.effects.getModel().createReference();
    }

    public VersionedReference<Double> createAmbientVolumeReference() {
        return this.ambient.getModel().createReference();
    }

    public void addSettingsUpdater(String settingName, VersionedReference<? extends Object> ref) {
        this.updaters.add(new SettingsUpdater(settingName, ref));
    }

    public void removeSettingsUpdater(String settingName) {
        Iterator<SettingsUpdater> it = this.updaters.iterator();
        while (it.hasNext()) {
            SettingsUpdater updater = it.next();
            if (!updater.settingName.equals(settingName)) continue;
            it.remove();
        }
    }

    protected void back() {
        if (this.getState(GameSessionState.class) != null) {
            ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
        } else {
            this.setEnabled(false);
        }
    }

    protected void initialize(Application app) {
        this.blackboard = (BlackboardState)this.getState("global", BlackboardState.class, true);
        this.blackboard.addBlackboardListener((BlackboardListener)this.settingsListener);
        this.config = MythrunaConfig.getInstance();
        this.window = new Container(new ElementId("window"));
        this.tabs = (TabbedPanel)this.window.addChild((Node)new TabbedPanel(), new Object[0]);
        this.currentTabRef = this.tabs.getSelectionModel().createReference();
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "back")), new Object[0]);
        PropertyPanel props = (PropertyPanel)this.tabs.addTab("Controls", (Panel)new PropertyPanel(null));
        props.addBooleanProperty("Invert Y", (Object)this, "invertY");
        Container sound = (Container)this.tabs.addTab("Sound", (Panel)new Container());
        this.mute = (Checkbox)sound.addChild((Node)new Checkbox("Mute"), new Object[0]);
        Boolean allMuted = this.config.getStartupSetting("SoundState.muted", Boolean.FALSE);
        this.mute.setChecked(allMuted.booleanValue());
        this.addSettingsUpdater("SoundState.muted", (VersionedReference<? extends Object>)this.mute.getModel().createReference());
        sound.addChild((Node)new Label("Volume:"), new Object[0]);
        Container volumes = (Container)sound.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        volumes.addChild((Node)new Label("Music:"), new Object[0]);
        double musicVolume = this.config.getStartupSetting("SoundState.musicVolume", 50.0);
        this.music = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, musicVolume)), new Object[]{1});
        this.addSettingsUpdater("SoundState.musicVolume", (VersionedReference<? extends Object>)this.music.getModel().createReference());
        volumes.addChild((Node)new Label("Effects:"), new Object[0]);
        double effectsVolume = this.config.getStartupSetting("SoundState.effectsVolume", 75.0);
        this.effects = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, effectsVolume)), new Object[]{1});
        this.addSettingsUpdater("SoundState.effectsVolume", (VersionedReference<? extends Object>)this.effects.getModel().createReference());
        volumes.addChild((Node)new Label("Ambient:"), new Object[0]);
        double ambientVolume = this.config.getStartupSetting("SoundState.ambientVolume", 75.0);
        this.ambient = (Slider)volumes.addChild((Node)new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, ambientVolume)), new Object[]{1});
        this.addSettingsUpdater("SoundState.ambientVolume", (VersionedReference<? extends Object>)this.ambient.getModel().createReference());
        Container uiPanel = (Container)this.tabs.addTab("User Interface", (Panel)new Container());
        uiPanel.addChild((Node)new Label("Object Text:"), new Object[0]);
        props = (PropertyPanel)uiPanel.addChild((Node)new PropertyPanel(null), new Object[0]);
        props.addBooleanProperty("Show Player Names", (Object)this.uiSettings, "playerNamesEnabled");
        props.addBooleanProperty("Show Character Names", (Object)this.uiSettings, "characterNamesEnabled");
        props.addBooleanProperty("Show Status Text", (Object)this.uiSettings, "statusTextEnabled");
        props.addBooleanProperty("Show Debug Text", (Object)this.uiSettings, "debugTextEnabled");
        props.addBooleanProperty("Show Object Names", (Object)this.uiSettings, "objectNamesEnabled");
        props.addDoubleProperty("Console Fade Time (s)", (Object)this.uiSettings, "consoleFadeTime", 1.0, 60.0, 1.0);
        this.rendering = (Container)this.tabs.addTab("Rendering", (Panel)new Container());
        this.rendering.addChild((Node)new Label("Post Processing:"), new Object[0]);
        props = (PropertyPanel)this.rendering.addChild((Node)new PropertyPanel(null), new Object[0]);
        PostProcessingState post = (PostProcessingState)this.getState(PostProcessingState.class, true);
        post.setEnabled(this.config.getStartupSetting("PostProcessingState.enabled", true));
        props.addBooleanProperty("Enabled", (Object)post, "enabled");
        props = new PropertyPanel(null);
        RollupPanel rollup = (RollupPanel)this.rendering.addChild((Node)new RollupPanel("Bloom", (Panel)props, null), new Object[0]);
        rollup.setOpen(false);
        this.postProcGroup.add(rollup.getOpenModel());
        props.addBooleanProperty("Enabled", (Object)post.getBloomFilter(), "enabled");
        props.addFloatProperty("Intensity", (Object)post.getBloomFilter(), "bloomIntensity", 0.0f, 5.0f, 0.1f);
        props.addFloatProperty("Blur Scale", (Object)post.getBloomFilter(), "blurScale", 0.0f, 5.0f, 0.1f);
        props.addFloatProperty("Down Sampling", (Object)post.getBloomFilter(), "downSamplingFactor", 0.1f, 20.0f, 0.1f);
        props.addFloatProperty("Exposure Cut-off", (Object)post.getBloomFilter(), "exposureCutOff", 0.0f, 1.0f, 0.1f);
        props.addFloatProperty("Exposure Power", (Object)post.getBloomFilter(), "exposurePower", 0.0f, 10.0f, 0.1f);
        props = new PropertyPanel(null);
        rollup = (RollupPanel)this.rendering.addChild((Node)new RollupPanel("Underwater", (Panel)props, null), new Object[0]);
        rollup.setOpen(false);
        this.postProcGroup.add(rollup.getOpenModel());
        props.addBooleanProperty("Enabled", (Object)post.getUnderwaterFilter(), "enabled");
        props.addFloatProperty("Blur Distance", (Object)post.getUnderwaterFilter(), "blurDistance", 0.0f, 1024.0f, 1.0f);
        props.addFloatProperty("Blur Scale", (Object)post.getUnderwaterFilter(), "blurScale", 0.0f, 5.0f, 0.1f);
        props.addBooleanProperty("Debug Unfocus", (Object)post.getUnderwaterFilter(), "debugUnfocus");
        props.addFloatProperty("Attenuation Distance", (Object)post.getUnderwaterFilter(), "attenuationDistance", 0.0f, 1024.0f, 1.0f);
        props.addBooleanProperty("Debug Brightness", (Object)post.getUnderwaterFilter(), "debugBrightness");
        props.addBooleanProperty("Debug Attenuation", (Object)post.getUnderwaterFilter(), "debugAttenuation");
        props = new PropertyPanel(null);
        rollup = (RollupPanel)this.rendering.addChild((Node)new RollupPanel("Depth of Field", (Panel)props, null), new Object[0]);
        rollup.setOpen(false);
        this.postProcGroup.add(rollup.getOpenModel());
        props.addBooleanProperty("Enabled", (Object)post.getDepthOfFieldFilter(), "enabled");
        props.addFloatProperty("Focus Distance", (Object)post.getDepthOfFieldFilter(), "focusDistance", 0.0f, 1024.0f, 1.0f);
        props.addFloatProperty("Focus Range", (Object)post.getDepthOfFieldFilter(), "focusRange", 0.0f, 1024.0f, 1.0f);
        props.addFloatProperty("Blur Scale", (Object)post.getDepthOfFieldFilter(), "blurScale", 0.0f, 5.0f, 0.1f);
        props.addFloatProperty("Blur Threshold", (Object)post.getDepthOfFieldFilter(), "blurThreshold", 0.0f, 5.0f, 0.1f);
        props.addBooleanProperty("Debug Unfocus", (Object)post.getDepthOfFieldFilter(), "debugUnfocus");
        props = new PropertyPanel(null);
        rollup = (RollupPanel)this.rendering.addChild((Node)new RollupPanel("Radial Blur", (Panel)props, null), new Object[0]);
        rollup.setOpen(false);
        this.postProcGroup.add(rollup.getOpenModel());
        props.addBooleanProperty("Enabled", (Object)post.getRadialBlurFilter(), "enabled");
        props.addFloatProperty("Sample Strength", (Object)post.getRadialBlurFilter(), "sampleStrength", 0.0f, 5.0f, 0.1f);
        props.addFloatProperty("Sample Distance", (Object)post.getRadialBlurFilter(), "sampleDistance", 0.0f, 5.0f, 0.1f);
        props = new PropertyPanel(null);
        rollup = (RollupPanel)this.rendering.addChild((Node)new RollupPanel("Drop Shadows", (Panel)props, null), new Object[0]);
        rollup.setOpen(false);
        this.postProcGroup.add(rollup.getOpenModel());
        props.addBooleanProperty("Enabled", (Object)post.getDropShadows(), "enabled");
        props.addFloatProperty("shadowIntensity", (Object)post.getDropShadows(), "shadowIntensity", 0.0f, 1.0f, 0.1f);
        props.addBooleanProperty("Show Debug", (Object)post.getDropShadows(), "showBox");
        this.debugPanel = (Container)this.tabs.addTab("Debug", (Panel)new Container());
        this.uiSettings.initialize();
    }

    protected void cleanup(Application app) {
        this.blackboard.removeBlackboardListener((BlackboardListener)this.settingsListener);
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            this.resetPosition();
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.01f));
        });
    }

    public void update(float tpf) {
        boolean changed = false;
        if (this.currentTabRef.update()) {
            changed = true;
        }
        if (this.postProcGroup.update()) {
            changed = true;
        }
        if (changed) {
            this.resetPosition();
        }
        boolean settingsChanged = false;
        for (SettingsUpdater updater : this.updaters) {
            if (!updater.update()) continue;
            settingsChanged = true;
        }
        if (settingsChanged || this.saveSettings) {
            MythrunaConfig.save();
            this.saveSettings = false;
        }
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    protected void resetPosition() {
        log.info("resetPosition() centered:" + this.centered);
        if (this.centered) {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        } else {
            float height = ((GuiState)this.getState(GuiState.class)).getGuiSize().y;
            this.window.setLocalTranslation(20.0f, height - 20.0f, 0.0f);
        }
    }

    public <T> T getSetting(String key, T defaultValue) {
        return (T)this.blackboard.get(key, () -> this.config.getStartupSetting(key, defaultValue));
    }

    private class SettingsListener
    implements BlackboardListener {
        private SettingsListener() {
        }

        public void valueSet(String id, Class type, Object value) {
            if (id.startsWith("settings.")) {
                GameSettingsState.this.config.getStartupSettings().put(id, value);
                GameSettingsState.this.saveSettings = true;
            }
        }
    }

    protected class UserInterfaceSettings {
        protected UserInterfaceSettings() {
        }

        public void initialize() {
            MessageState messages = (MessageState)GameSettingsState.this.getState(MessageState.class);
            Consumer<Double> setFade = f -> messages.setFadeTime((float)f.doubleValue());
            GameSettingsState.this.blackboard.watch("settings.console.fadeTime", setFade);
        }

        public void setObjectNamesEnabled(boolean f) {
            GameSettingsState.this.blackboard.update("settings.objectNames.enabled", (Object)f);
        }

        public boolean getObjectNamesEnabled() {
            return GameSettingsState.this.getSetting("settings.objectNames.enabled", false);
        }

        public void setCharacterNamesEnabled(boolean f) {
            GameSettingsState.this.blackboard.update("settings.characterNames.enabled", (Object)f);
        }

        public boolean getCharacterNamesEnabled() {
            return GameSettingsState.this.getSetting("settings.characterNames.enabled", true);
        }

        public void setPlayerNamesEnabled(boolean f) {
            GameSettingsState.this.blackboard.update("settings.playerNames.enabled", (Object)f);
        }

        public boolean getPlayerNamesEnabled() {
            return GameSettingsState.this.getSetting("settings.playerNames.enabled", true);
        }

        public void setStatusTextEnabled(boolean f) {
            GameSettingsState.this.blackboard.update("settings.statusText.enabled", (Object)f);
        }

        public boolean getStatusTextEnabled() {
            return GameSettingsState.this.getSetting("settings.statusText.enabled", true);
        }

        public void setDebugTextEnabled(boolean f) {
            GameSettingsState.this.blackboard.update("settings.debugText.enabled", (Object)f);
        }

        public boolean getDebugTextEnabled() {
            return GameSettingsState.this.getSetting("settings.debugText.enabled", false);
        }

        public void setConsoleFadeTime(double f) {
            GameSettingsState.this.blackboard.update("settings.console.fadeTime", (Object)f);
        }

        public double getConsoleFadeTime() {
            return GameSettingsState.this.getSetting("settings.console.fadeTime", 15.0);
        }
    }

    private class RadioGroup {
        private Map<VersionedReference<Boolean>, CheckboxModel> models = new HashMap<VersionedReference<Boolean>, CheckboxModel>();
        private List<VersionedReference<Boolean>> refs = new ArrayList<VersionedReference<Boolean>>();

        private RadioGroup() {
        }

        public void add(CheckboxModel model) {
            VersionedReference ref = model.createReference();
            this.models.put((VersionedReference<Boolean>)ref, model);
            this.refs.add((VersionedReference<Boolean>)ref);
        }

        protected void makeExclusive(CheckboxModel model) {
            for (CheckboxModel m : this.models.values()) {
                if (m == model) continue;
                m.setChecked(false);
            }
        }

        public boolean update() {
            VersionedReference<Boolean> firstChanged = null;
            boolean changed = false;
            for (VersionedReference<Boolean> ref : this.refs) {
                if (!ref.update()) continue;
                changed = true;
                if (!((Boolean)ref.get()).booleanValue() || firstChanged != null) continue;
                firstChanged = ref;
            }
            if (firstChanged != null) {
                this.makeExclusive(this.models.get(firstChanged));
            }
            return changed;
        }
    }

    public static class SettingsUpdater {
        private VersionedReference<? extends Object> ref;
        private String settingName;

        public SettingsUpdater(String settingName, VersionedReference<? extends Object> ref) {
            this.settingName = settingName;
            this.ref = ref;
        }

        public boolean update() {
            if (this.ref.update()) {
                log.info("Setting:" + this.settingName + " changed to:" + this.ref.get());
                MythrunaConfig.getInstance().getStartupSettings().put(this.settingName, this.ref.get());
                return true;
            }
            return false;
        }
    }
}

