/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.InsetsComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3d;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.GameConstants;
import mythruna.client.CreateWorldState;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.ProgressState;
import mythruna.world.WorldFractal;
import mythruna.world.WorldFractalFactory;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldManager;
import mythruna.world.WorldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldListState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(WorldListState.class);
    private Container window;
    private Label title;
    private ListBox<WorldInfo> worldList;
    private Consumer<WorldManager> select;
    private Label worldName;
    private Label createdDate;
    private Label fractalType;
    private Label seed;
    private Label preview;
    private Label message;
    private WorldLibrary library;
    private VersionedList<WorldInfo> worlds = new VersionedList();
    private VersionedReference<Integer> selectionRef;
    private WorldInfo selectedWorld;

    public WorldListState() {
        this.setEnabled(false);
    }

    public WorldLibrary getWorldLibrary() {
        return this.library;
    }

    public void selectWorld(String title, Consumer<WorldManager> select) {
        this.title.setText(title);
        this.select = select;
        this.setEnabled(true);
    }

    protected void select() {
        if (this.selectedWorld == null) {
            return;
        }
        ((ProgressState)this.getState(ProgressState.class)).openView((Object)this, "Loading world...");
        Thread thread = new Thread(() -> {
            try {
                WorldManager world = WorldManager.loadWorld((WorldInfo)this.selectedWorld);
                this.getApplication().enqueue(() -> this.startWorld(world));
            }
            catch (Exception e) {
                log.error("Error loading world", (Throwable)e);
                this.getApplication().enqueue(() -> this.showError("Error Loading World", e));
            }
            finally {
                ((ProgressState)this.getState(ProgressState.class)).releaseView((Object)this);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void loadWorld(String worldDir, Consumer<WorldManager> callback) {
        ((ProgressState)this.getState(ProgressState.class)).openView((Object)this, "Loading world...");
        Thread thread = new Thread(() -> {
            try {
                WorldInfo info = this.library.loadWorldInfo(worldDir);
                WorldManager world = WorldManager.loadWorld((WorldInfo)info);
                this.getApplication().enqueue(() -> callback.accept(world));
            }
            catch (Exception e) {
                log.error("Error loading world", (Throwable)e);
                this.getApplication().enqueue(() -> this.showError("Error Loading World", e));
            }
            finally {
                ((ProgressState)this.getState(ProgressState.class)).releaseView((Object)this);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    protected void startWorld(WorldManager world) {
        this.select.accept(world);
        this.setEnabled(false);
    }

    public void cancel() {
        this.setEnabled(false);
    }

    protected void showError(String title, Throwable t) {
        ((GuiState)this.getState(GuiState.class)).showError(title, t.getMessage());
    }

    protected void createNewWorld() {
        log.info("Create new world...");
        ((CreateWorldState)this.getState(CreateWorldState.class)).setEnabled(true);
    }

    protected void initialize(Application app) {
        this.library = new WorldLibrary(MythrunaConfig.getInstance().getWorldLibrary());
        this.window = new Container(new ElementId("window"));
        this.title = (Label)this.window.addChild((Node)new Label("Select World", new ElementId("window.title")), new Object[0]);
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "createNewWorld")), new Object[0]);
        this.window.addChild((Node)new Label("Previous Worlds:"), new Object[0]);
        Container worldSelection = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        this.worldList = (ListBox)worldSelection.addChild((Node)new ListBox(this.worlds), new Object[0]);
        this.worldList.setVisibleItems(10);
        this.worldList.setCellRenderer((ValueRenderer)new WorldValueRenderer());
        this.selectionRef = this.worldList.getSelectionModel().createSelectionReference();
        Vector3f pref = this.worldList.getPreferredSize().clone();
        pref.x = Math.max(300.0f, pref.x);
        this.worldList.setPreferredSize(pref);
        Container selectedWorld = (Container)worldSelection.addChild((Node)new Container(), new Object[]{1});
        Container properties = (Container)selectedWorld.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        properties.setBackground(null);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.worldName = (Label)properties.addChild((Node)new Label("", new ElementId("spinner.value")), new Object[]{1});
        properties.addChild((Node)new Label("Fractal:"), new Object[0]);
        this.fractalType = (Label)properties.addChild((Node)new Label("", new ElementId("spinner.value")), new Object[]{1});
        properties.addChild((Node)new Label("Seed:"), new Object[0]);
        this.seed = (Label)properties.addChild((Node)new Label("", new ElementId("spinner.value")), new Object[]{1});
        properties.addChild((Node)new Label("Created:"), new Object[0]);
        this.createdDate = (Label)properties.addChild((Node)new Label("", new ElementId("spinner.value")), new Object[]{1});
        Texture paper = app.getAssetManager().loadTexture("Interface/paper.jpg");
        this.preview = (Label)selectedWorld.addChild((Node)new Label("Preview", new ElementId("spinner.value")), new Object[0]);
        this.preview.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.preview.setPreferredSize(new Vector3f(384.0f, 384.0f, 1.0f));
        this.preview.setTextHAlignment(HAlignment.Center);
        this.preview.setTextVAlignment(VAlignment.Center);
        this.preview.setInsetsComponent((InsetsComponent)new DynamicInsetsComponent(0.5f, 0.5f, 0.5f, 0.5f));
        this.message = (Label)selectedWorld.addChild((Node)new Label(""), new Object[0]);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "select")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.refreshList();
        this.resetPosition();
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        GuiGlobals.getInstance().requestFocus((Spatial)this.window);
    }

    public void update(float tpf) {
        if (this.selectionRef.update()) {
            Integer i = (Integer)this.selectionRef.get();
            this.setSelectedWorld(i == null ? null : (WorldInfo)this.worlds.get(i.intValue()));
        }
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    protected void setSelectedWorld(WorldInfo info) {
        if (Objects.equals(info, this.selectedWorld)) {
            return;
        }
        this.selectedWorld = info;
        if (this.selectedWorld != null) {
            this.worldName.setText(info.getName());
            this.seed.setText(String.valueOf(info.getSeed()));
            this.fractalType.setText(info.getFractalName());
            this.createdDate.setText(String.format("%tF", info.getCreatedDate()));
            this.preview.setIcon(this.getPreview(info));
            this.preview.setText("");
            if (!Objects.equals(GameConstants.WORLD_DB_VERSIONS, info.getWorldDbVersions())) {
                this.message.setText("This world DB is incompatible with this software version.");
            } else {
                this.message.setText("");
            }
        } else {
            this.worldName.setText("");
            this.seed.setText("");
            this.fractalType.setText("");
            this.createdDate.setText("");
            this.preview.setText("Preview");
            this.preview.setIcon(null);
            this.message.setText("");
        }
    }

    protected void refreshList() {
        this.library.refreshList();
        this.worlds.clear();
        this.worlds.addAll((Collection)this.library.getWorlds());
    }

    protected void resetPosition() {
        Vector2f screen = ((GuiState)this.getState(GuiState.class, true)).getGuiSize();
        Vector3f pref = this.window.getPreferredSize().clone();
        float x = screen.x * 0.5f - pref.x * 0.5f;
        float y = screen.y * 0.6f + pref.y * 0.5f;
        this.window.setLocalTranslation(x, y, 0.0f);
    }

    public static QuadBackgroundComponent createPreview(String fractalType, long seed, int imageSize, double previewSize) {
        WorldFractal fractal = WorldFractalFactory.create((WorldInfo)new WorldInfo("", fractalType, seed));
        Vec3d spawn = WorldUtils.findSpawn((WorldFractal)fractal);
        byte[] data = WorldUtils.createPreview((WorldFractal)fractal, (int)imageSize, (double)(spawn.x - previewSize * 0.5), (double)(spawn.z - previewSize * 0.5), (double)previewSize);
        ByteBuffer imageData = BufferUtils.createByteBuffer((byte[])data);
        Image image = new Image(Image.Format.ARGB8, imageSize, imageSize, imageData, ColorSpace.Linear);
        Texture2D texture = new Texture2D(image);
        return new QuadBackgroundComponent((Texture)texture);
    }

    public BufferedImage getPreviewImage(WorldInfo info) {
        BufferedImage image = info.getPreview();
        if (image != null) {
            return image;
        }
        WorldFractal fractal = WorldFractalFactory.createSample((long)info.getSeed());
        Vec3d spawn = info.getSpawnPoint();
        if (spawn == null) {
            spawn = WorldUtils.findSpawn((WorldFractal)fractal);
        }
        log.info("Spawn:" + spawn);
        int imageSize = 512;
        double previewSize = 65536.0;
        log.info("rendering map size:" + imageSize);
        image = WorldUtils.createMapImage((WorldFractal)fractal, (int)imageSize, (double)(spawn.x - previewSize * 0.5), (double)(spawn.z - previewSize * 0.5), (double)previewSize);
        return image;
    }

    public GuiComponent getPreview(WorldInfo info) {
        BufferedImage image = this.getPreviewImage(info);
        Image img = new AWTLoader().load(image, false);
        Texture2D texture = new Texture2D(img);
        return new QuadBackgroundComponent((Texture)texture);
    }

    private class WorldValueRenderer
    extends DefaultValueRenderer<WorldInfo> {
        private final ColorRGBA VALID_COLOR = new ColorRGBA(0.4f, 0.25f, 0.25f, 0.85f);
        private final ColorRGBA INVALID_COLOR = new ColorRGBA(0.5f, 0.1f, 0.1f, 0.85f);

        private WorldValueRenderer() {
        }

        protected String valueToString(WorldInfo value) {
            if (!Objects.equals(GameConstants.WORLD_DB_VERSIONS, value.getWorldDbVersions())) {
                return "[Invalid] " + value.getName();
            }
            return value.getName();
        }

        public Panel getView(WorldInfo value, boolean selected, Panel existing) {
            Panel result = super.getView((Object)value, selected, existing);
            if (!Objects.equals(GameConstants.WORLD_DB_VERSIONS, value.getWorldDbVersions())) {
                ((Label)result).setColor(this.INVALID_COLOR);
            } else {
                ((Label)result).setColor(this.VALID_COLOR);
            }
            return result;
        }
    }
}

