/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import mythruna.client.MainMenuState;
import mythruna.client.net.NetworkState;
import mythruna.net.info.HostInfo;
import mythruna.net.info.HostList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectToHostState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ConnectToHostState.class);
    private static final String[] HELP = new String[]{"Select a host from the list of public", "hosts or enter a host and port for a", "custom/private server.", "", "Host: is an internet host name or", "         IP address.", "Port: is the base port for the Mythruna", "         server to which you are trying to", "         connect.", "         4234 is the default port."};
    private Vector2f guiSize;
    private Container window;
    private Label title;
    private Container helpWindow;
    private Label help;
    private TextField host;
    private Spinner<Double> port;
    private VersionedList<HostInfo> hosts = new VersionedList();
    private ListBox<HostInfo> hostList;
    private VersionedReference<Integer> selectionRef;

    public ConnectToHostState() {
        this.setEnabled(false);
    }

    public void fetchServerList() {
        if (!this.hosts.isEmpty()) {
            return;
        }
        String publicList = "https://www.mythruna.com/registry/public-hosts.json";
        try {
            URL u = new URL(publicList);
            HostList list = HostList.load((URL)u);
            log.info("loaded:" + list);
            this.getApplication().enqueue(() -> this.hosts.addAll((Collection)list.getPublicHosts()));
            return;
        }
        catch (IOException e) {
            log.error("Error loading:" + publicList, (Throwable)e);
            try {
                HostList list = HostList.load((URL)((Object)((Object)this)).getClass().getResource("/default-hosts.json"));
                log.info("loaded:" + list);
                this.getApplication().enqueue(() -> this.hosts.addAll((Collection)list.getPublicHosts()));
            }
            catch (IOException e2) {
                log.error("Error loading default host list.", (Throwable)e2);
            }
            return;
        }
    }

    protected void connect() {
        Double p = (Double)this.port.getValue();
        ((NetworkState)this.getState(NetworkState.class)).connect(this.host.getText(), p.intValue(), loginStatus -> this.connected((Boolean)loginStatus));
    }

    protected void connected(Boolean b) {
        if (b != null && b.booleanValue()) {
            this.setEnabled(false);
        }
    }

    protected void cancel() {
        this.setEnabled(false);
        ((MainMenuState)this.getState(MainMenuState.class)).setEnabled(true);
    }

    protected void setFields(HostInfo info) {
        if (info == null) {
            this.host.setText("localhost");
            this.port.setValue((Object)4234.0);
        } else {
            this.host.setText(info.getHost());
            this.port.setValue((Object)info.getPort());
        }
    }

    protected void initialize(Application app) {
        this.window = new Container(new ElementId("window"));
        this.title = (Label)this.window.addChild((Node)new Label("Connect to Host", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Host:"), new Object[0]);
        this.host = (TextField)properties.addChild((Node)new TextField("localhost"), new Object[]{1});
        this.host.setPreferredWidth(400.0f);
        properties.addChild((Node)new Label("Port:"), new Object[0]);
        DefaultRangedValueModel range = new DefaultRangedValueModel(1.0, 65535.0, 4234.0);
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.0f", (String)"error");
        this.port = (Spinner)properties.addChild((Node)new Spinner(SequenceModels.rangedSequence((RangedValueModel)range, (double)1.0, (double)1.0), (ValueRenderer)renderer), new Object[]{1});
        this.port.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.0f"));
        this.window.addChild((Node)new Label("Public Hosts:"), new Object[0]);
        this.hostList = (ListBox)this.window.addChild((Node)new ListBox(this.hosts), new Object[0]);
        this.hostList.setCellRenderer((ValueRenderer)new DefaultValueRenderer<HostInfo>(){

            public String valueToString(HostInfo info) {
                return info == null ? "null" : info.toDisplayString();
            }
        });
        this.selectionRef = this.hostList.getSelectionModel().createSelectionReference();
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "connect")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
        ElementId helpId = new ElementId("help");
        this.helpWindow = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even), helpId.child("window"));
        this.helpWindow.addChild((Node)new Label("Help", helpId.child("title")), new Object[0]);
        this.help = (Label)this.helpWindow.addChild((Node)new Label("This is where help goes.", helpId.child("label")), new Object[0]);
        this.resetHelp();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        if (this.hosts.isEmpty()) {
            new Thread(() -> this.fetchServerList()).start();
        }
        GuiGlobals globals = GuiGlobals.getInstance();
        this.guiSize = globals.getPopupState().getGuiSize();
        globals.getPopupState().centerInGui((Spatial)this.window);
        globals.getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        globals.getPopupState().getGuiNode().attachChild((Spatial)this.helpWindow);
        globals.requestFocus((Spatial)this.window);
    }

    protected void onDisable() {
        this.window.removeFromParent();
        this.helpWindow.removeFromParent();
    }

    public void update(float tpf) {
        if (this.selectionRef.update()) {
            this.setFields((HostInfo)this.hostList.getSelectedItem());
        }
        Vector3f size = this.window.getSize();
        Vector3f helpSize = this.helpWindow.getSize();
        float width = helpSize.x + size.x;
        Vector3f loc = this.window.getLocalTranslation();
        loc.x = this.guiSize.x * 0.5f - width * 0.5f;
        this.window.setLocalTranslation(loc);
        this.helpWindow.setLocalTranslation(loc.x + size.x + 50.0f, loc.y + (helpSize.y - size.y) * 0.5f, loc.z);
    }

    protected void resetHelp() {
        String s = String.join((CharSequence)"\n", HELP);
        this.help.setText(s);
    }
}

