/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.component.TextEntryComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.event.KeyActionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.net.ChatSessionListener;
import com.simsilica.net.server.ChatHostedService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.NetworkState;
import mythruna.shell.CommandShell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostManagementState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HostManagementState.class);
    private static Object LF = new Object();
    private Pattern TOKENS = Pattern.compile("([\r\n])|(\\\\#[0-9a-fA-F]{3,8}#)");
    private static final String C_GREY = "\\#777#";
    private static final String C_GREEN = "\\#0f0#";
    private static final String C_RED = "\\#f00#";
    private static final String C_PINK = "\\#f8f#";
    private static final String C_CYAN = "\\#0ff#";
    private static final String C_YELLOW = "\\#ff0#";
    private static final String C_WHITE = "\\#fff#";
    private Thread renderThread;
    private HostedGameState host;
    private Server server;
    private CommandShell adminShell;
    private ChatListener chatListener = new ChatListener();
    private Container window;
    private Container connectionsPanel;
    private ListBox<ConnectionInfo> playerList;
    private VersionedList<ConnectionInfo> connections = new VersionedList();
    private Map<HostedConnection, ConnectionInfo> connectionIndex = new HashMap<HostedConnection, ConnectionInfo>();
    private ConnectionObserver connectionObserver = new ConnectionObserver();
    private Container chatLog;
    private List<String> messages = new ArrayList<String>();
    private int maxMessageCount = 20;
    private boolean messagesInvalid;
    private Label messagesLabel;
    private TextField console;
    private Container adminPanel;
    private Container actionPanel;
    private List<Action> adminActions = new ArrayList<Action>();
    private Action connectAction = new CallMethodAction("Connect as Player", (Object)this, "connect");
    private Action backAction = new CallMethodAction("Back to Game", (Object)this, "back");

    public HostManagementState() {
        this.adminActions.add(this.connectAction);
        this.adminActions.add(this.backAction);
        this.adminActions.add((Action)new CallMethodAction("Shutdown Server", (Object)this, "shutdown"));
    }

    protected void connect() {
        log.info("connect()");
        ((NetworkState)this.getState(NetworkState.class)).connect("127.0.0.1", this.host.getPort(), connected -> this.setConnected((boolean)connected));
    }

    protected void setConnected(boolean connected) {
        log.info("setConnected(" + connected + ")");
        this.connectAction.setEnabled(!connected);
        this.backAction.setEnabled(connected);
        this.setEnabled(!connected);
    }

    protected void back() {
        log.info("back()");
    }

    protected void shutdown() {
        log.info("shutdown()");
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.host = (HostedGameState)this.getState(HostedGameState.class, true);
        this.server = this.host.getGameServer().getServer();
        ((ChatHostedService)this.server.getServices().getService(ChatHostedService.class)).addChatSessionListener((ChatSessionListener)this.chatListener);
        this.server.addConnectionListener((ConnectionListener)this.connectionObserver);
        this.adminShell = this.host.getGameServer().getAdminShell();
        this.adminShell.setOutput(line -> this.newConsoleMessage((String)line));
        this.connectAction.setEnabled(true);
        this.backAction.setEnabled(false);
        this.window = new Container((GuiLayout)new BorderLayout(), new ElementId("window"));
        this.chatLog = (Container)this.window.addChild((Node)new Container((GuiLayout)new BorderLayout()), new Object[]{BorderLayout.Position.Center});
        this.chatLog.addChild((Node)new Label("Server Console", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        this.connectionsPanel = (Container)this.window.addChild((Node)new Container((GuiLayout)new BorderLayout()), new Object[]{BorderLayout.Position.East});
        this.connectionsPanel.addChild((Node)new Label("Connections", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        this.playerList = (ListBox)this.connectionsPanel.addChild((Node)new ListBox(this.connections), new Object[0]);
        this.adminPanel = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[]{BorderLayout.Position.West});
        this.adminPanel.addChild((Node)new Label("Admin Actions", new ElementId("window.title")), new Object[0]);
        this.actionPanel = (Container)this.adminPanel.addChild((Node)new Container(), new Object[0]);
        this.adminPanel.addChild((Node)new Label(""), new Object[0]);
        this.messagesLabel = (Label)this.chatLog.addChild((Node)new Label("No messages yet"), new Object[]{BorderLayout.Position.Center});
        this.messagesLabel.setTextVAlignment(VAlignment.Top);
        this.messagesLabel.setBackground((GuiComponent)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)));
        this.messagesLabel.setBorder(null);
        this.messagesLabel.setInsets(new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
        this.console = (TextField)this.chatLog.addChild((Node)new TextField(""), new Object[]{BorderLayout.Position.South});
        this.console.getActionMap().put(new KeyAction(28, new int[0]), new NewLine());
        this.console.getActionMap().put(new KeyAction(1, new int[0]), new Escape());
    }

    protected void cleanup(Application app) {
        if (this.server != null) {
            this.server.removeConnectionListener((ConnectionListener)this.connectionObserver);
            ((ChatHostedService)this.server.getServices().getService(ChatHostedService.class)).removeChatSessionListener((ChatSessionListener)this.chatListener);
        }
    }

    protected void onEnable() {
        this.resetActionList();
        GuiGlobals globals = GuiGlobals.getInstance();
        Vector2f guiSize = globals.getPopupState().getGuiSize();
        this.window.setPreferredSize(null);
        Vector3f pref1 = this.messagesLabel.getPreferredSize();
        Vector3f pref2 = this.window.getPreferredSize();
        log.info("window pref:" + pref2 + "  \nx1 messages pref:" + pref1);
        float height = guiSize.y * 0.9f;
        this.window.setPreferredSize(new Vector3f(guiSize.x * 0.9f, guiSize.y * 0.9f, 10.0f));
        float fontSize = this.messagesLabel.getFontSize();
        float lineSize = pref1.y;
        log.info("GUI height:" + guiSize.y + "  messages height:" + height + "  font size:" + fontSize + "  lineSize:" + lineSize);
        this.maxMessageCount = (int)(height / lineSize);
        this.maxMessageCount -= 2;
        --this.maxMessageCount;
        log.info("max message count:" + this.maxMessageCount);
        this.playerList.setVisibleItems(this.maxMessageCount - 5);
        globals.getPopupState().centerInGui((Spatial)this.window);
        globals.getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        globals.requestFocus((Spatial)this.window);
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    public void update(float tpf) {
        this.updateMessages();
    }

    protected void resetActionList() {
        this.actionPanel.clearChildren();
        for (Action a : this.adminActions) {
            if (!a.isEnabled()) continue;
            this.actionPanel.addChild((Node)new ActionButton(a), new Object[0]);
        }
    }

    protected void updateMessages() {
        if (!this.messagesInvalid) {
            return;
        }
        this.messagesLabel.setText(String.join((CharSequence)"\n", this.messages));
        this.messagesInvalid = false;
    }

    protected List<Object> toTokens(String s) {
        ArrayList<Object> list = new ArrayList<Object>();
        Matcher m = this.TOKENS.matcher(s);
        int lastStart = 0;
        while (m.find()) {
            list.add(s.substring(lastStart, m.start()));
            if (m.group(1) != null) {
                list.add(LF);
            }
            if (m.group(2) != null) {
                list.add(new TextColor(m.group(2)));
            }
            lastStart = m.end();
        }
        list.add(s.substring(lastStart, s.length()));
        return list;
    }

    protected void newConsoleMessage(String color, String consoleMessage) {
        if (Thread.currentThread() != this.renderThread) {
            this.getApplication().enqueue(() -> this.newConsoleMessage(color, consoleMessage));
            return;
        }
        log.info("newConsoleMessage(" + consoleMessage + ")");
        List<Object> tokens = this.toTokens(consoleMessage);
        tokens.add(LF);
        String lastColor = color;
        StringBuilder line = new StringBuilder(lastColor);
        for (Object t : tokens) {
            if (t instanceof TextColor) {
                lastColor = ((TextColor)t).color;
                line.append(lastColor);
                continue;
            }
            if (t == LF) {
                this.messages.add(line.toString());
                line = new StringBuilder(lastColor);
                continue;
            }
            line.append(t);
        }
        while (this.messages.size() < this.maxMessageCount) {
            this.messages.add(0, "");
        }
        while (this.messages.size() > this.maxMessageCount) {
            this.messages.remove(0);
        }
        this.messagesInvalid = true;
    }

    protected void newConsoleMessage(String consoleMessage) {
        this.newConsoleMessage(C_WHITE, consoleMessage);
    }

    protected void addConnection(HostedConnection conn) {
        ConnectionInfo info = new ConnectionInfo(conn);
        this.connectionIndex.put(conn, info);
        this.connections.add((Object)info);
    }

    protected void removeConnection(HostedConnection conn) {
        ConnectionInfo info = this.connectionIndex.remove(conn);
        if (info != null) {
            this.connections.remove((Object)info);
        }
    }

    protected void setPlayerName(int clientId, String name) {
        HostedConnection conn = this.server.getConnection(clientId);
        ConnectionInfo info = this.connectionIndex.get(conn);
        if (info != null) {
            info.setName(name);
            int index = this.connections.indexOf((Object)info);
            if (index >= 0) {
                this.connections.set(index, (Object)info);
            }
        }
    }

    private class ChatListener
    implements ChatSessionListener {
        private ChatListener() {
        }

        public void playerJoined(int clientId, String playerName) {
            log.info("playerJoined(" + clientId + ", " + playerName + ")");
            HostManagementState.this.getApplication().enqueue(() -> {
                HostManagementState.this.newConsoleMessage(HostManagementState.C_GREEN, playerName + " has joined.");
                HostManagementState.this.setPlayerName(clientId, playerName);
            });
        }

        public void newMessage(int clientId, String playerName, String message) {
            log.info("newMessage(" + clientId + ", " + playerName + ", " + message + ")");
            HostManagementState.this.newConsoleMessage(HostManagementState.C_CYAN, playerName + ":" + HostManagementState.C_WHITE + message);
        }

        public void playerLeft(int clientId, String playerName) {
            log.info("playerLeft(" + clientId + ", " + playerName + ")");
            HostManagementState.this.newConsoleMessage(HostManagementState.C_GREEN, playerName + " has left.");
        }
    }

    private class ConnectionObserver
    implements ConnectionListener {
        private ConnectionObserver() {
        }

        public void connectionAdded(Server server, HostedConnection conn) {
            log.info("connectionAdded(" + conn + ")");
            HostManagementState.this.getApplication().enqueue(() -> HostManagementState.this.addConnection(conn));
        }

        public void connectionRemoved(Server server, HostedConnection conn) {
            log.info("connectionRemoved(" + conn + ")");
            HostManagementState.this.getApplication().enqueue(() -> HostManagementState.this.removeConnection(conn));
        }
    }

    private class NewLine
    implements KeyActionListener {
        private NewLine() {
        }

        public void keyAction(TextEntryComponent source, KeyAction key) {
            String text = HostManagementState.this.console.getText();
            HostManagementState.this.console.setText("");
            if (text.length() == 0) {
                HostManagementState.this.newConsoleMessage(HostManagementState.C_GREY, "");
                return;
            }
            try {
                HostManagementState.this.newConsoleMessage(HostManagementState.C_YELLOW, ">" + text);
                HostManagementState.this.adminShell.execute(text);
            }
            catch (IllegalArgumentException e) {
                HostManagementState.this.newConsoleMessage(HostManagementState.C_PINK, "ERROR:\\#fff#" + e.getMessage());
            }
            catch (Exception e) {
                HostManagementState.this.newConsoleMessage(HostManagementState.C_PINK, "ERROR:\\#fff#" + e);
            }
        }
    }

    private class Escape
    implements KeyActionListener {
        private Escape() {
        }

        public void keyAction(TextEntryComponent source, KeyAction key) {
            HostManagementState.this.console.setText("");
        }
    }

    private class TextColor {
        public String color;

        public TextColor(String color) {
            this.color = color;
        }
    }

    private class ConnectionInfo {
        HostedConnection conn;
        String playerName;

        public ConnectionInfo(HostedConnection conn) {
            this.conn = conn;
        }

        public void setName(String playerName) {
            this.playerName = playerName;
        }

        public String toString() {
            if (this.playerName == null) {
                return this.conn.getId() + ":" + this.conn.getAddress() + ":Connecting";
            }
            return this.conn.getId() + ":" + this.conn.getAddress() + ":" + this.playerName;
        }
    }
}

