/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.ContainerView;
import mythruna.client.ui.FlyOverState;
import mythruna.client.ui.ItemView;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.UserPromptState;
import mythruna.client.view.AvatarState;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.Holding;
import mythruna.es.ObjectName;
import mythruna.es.ObjectVolume;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ContainerViewState.class);
    private GameSession gameSession;
    private EntityData ed;
    private Node containerRoot;
    private GeometryFactory geomFactory;
    private EntityId avatarId;
    private PlayerContainers playerContainers;
    private Map<EntityId, ItemView> itemViews = new HashMap<EntityId, ItemView>();
    private List<ContainerView> rootContainers = new ArrayList<ContainerView>();
    private FlyOverFunction flyOverFunction = new FlyOverFunction();
    private LocationFunction locationFunction = new LocationFunction();
    private Function<Vector3f, Vector3f> worldToUi;
    private Holder mainHand;

    public ContainerViewState() {
        this.setEnabled(false);
    }

    public Vector3f getGuiLocation(Vector3f world) {
        return this.worldToUi == null ? null : this.worldToUi.apply(world);
    }

    protected EntityData getEntityData() {
        return this.ed;
    }

    protected GeometryFactory getGeomFactory() {
        return this.geomFactory;
    }

    protected GameSession getGameSession() {
        return this.gameSession;
    }

    public ItemView getItemView(EntityId entityId) {
        return this.itemViews.get(entityId);
    }

    public ItemView getItemView(Entity entity) {
        ItemView result = this.itemViews.get(entity.getId());
        if (result != null) {
            return result;
        }
        result = new ItemView(this, entity);
        EntityId id = entity.getId();
        this.containerRoot.attachChild((Spatial)result);
        this.itemViews.put(id, result);
        if (this.mainHand.isHolding(id)) {
            this.mainHand.setItemView(result);
        }
        return result;
    }

    public Node getContainerRoot() {
        return this.containerRoot;
    }

    public void clearPopups() {
        ((FlyOverState)this.getState(FlyOverState.class)).clear();
        ((UserPromptState)this.getState(UserPromptState.class)).clear();
    }

    protected int[] sortAxes(Vec3d size) {
        int[] result = new int[3];
        if (size.x > size.y) {
            if (size.x > size.z) {
                result[0] = 0;
                if (size.y > size.z) {
                    result[1] = 1;
                    result[2] = 2;
                } else {
                    result[1] = 2;
                    result[2] = 1;
                }
            } else {
                result[0] = 2;
                result[1] = 0;
                result[2] = 1;
            }
        } else if (size.y > size.z) {
            result[0] = 1;
            if (size.x > size.z) {
                result[1] = 0;
                result[2] = 2;
            } else {
                result[1] = 2;
                result[2] = 0;
            }
        } else {
            result[0] = 2;
            result[1] = 1;
            result[2] = 0;
        }
        return result;
    }

    protected void initialize(Application app) {
        ((PlayerMenuState)this.getState(PlayerMenuState.class)).addSubmenu("Inventory", (AppState)this);
        this.worldToUi = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class))::getGuiLocation;
        this.gameSession = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        this.ed = ((GameSessionState)this.getState(GameSessionState.class, true)).getEntityData();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.avatarId = ((AvatarState)this.getState(AvatarState.class, true)).getAvatarId();
        this.containerRoot = new Node("containerRoot");
        this.containerRoot.setLocalScale(5.0f);
        this.playerContainers = new PlayerContainers(this.ed, this.avatarId);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.playerContainers.start();
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getRoot().attachChild((Spatial)this.containerRoot);
        ((FlyOverState)this.getState(FlyOverState.class)).addHitFunction(this.flyOverFunction);
        ((UserPromptState)this.getState(UserPromptState.class)).setLocationFunction(this.locationFunction);
        this.mainHand = new Holder(this.ed.watchEntity(this.avatarId, new Class[]{Holding.class}));
        this.mainHand.update();
    }

    protected void onDisable() {
        this.mainHand.release();
        this.mainHand = null;
        ((FlyOverState)this.getState(FlyOverState.class)).removeHitFunction(this.flyOverFunction);
        ((UserPromptState)this.getState(UserPromptState.class)).clearLocationFunction(this.locationFunction);
        this.playerContainers.stop();
        this.containerRoot.removeFromParent();
    }

    public void update(float tpf) {
        this.playerContainers.update();
        this.mainHand.update();
    }

    protected void addRootView(ContainerView view) {
        if (this.rootContainers.isEmpty()) {
            view.setPosition(10.0f, view.getItemSize().y + 10.0f);
        } else {
            float x = 0.0f;
            for (ContainerView other : this.rootContainers) {
                Vector2f pos = other.getPosition();
                Vector2f size = other.getItemSize();
                x = Math.max(pos.x + size.x, x);
            }
            view.setPosition(x + 5.0f, view.getItemSize().y + 10.0f);
        }
        this.rootContainers.add(view);
    }

    protected void removeRootView(ContainerView view) {
        this.rootContainers.remove((Object)view);
    }

    protected EntityId getEntityId(Spatial spatial) {
        for (Spatial s = spatial; s != null; s = s.getParent()) {
            Long val = (Long)s.getUserData("oid");
            if (val == null) continue;
            return new EntityId(val.longValue());
        }
        return null;
    }

    protected Spatial getEntitySpatial(Spatial spatial) {
        for (Spatial s = spatial; s != null; s = s.getParent()) {
            Long val = (Long)s.getUserData("oid");
            if (val == null) continue;
            return s;
        }
        return null;
    }

    private class PlayerContainers
    extends EntityContainer<ContainerView> {
        public PlayerContainers(EntityData ed, EntityId player) {
            super(ed, new Class[]{ContainedIn.class, ObjectVolume.class, ContainerVolume.class});
            this.setFilter(Filters.fieldEquals(ContainedIn.class, (String)"container", (Object)player));
        }

        protected ContainerView addObject(Entity e) {
            log.info("add container:" + e);
            ContainerView view = new ContainerView(ContainerViewState.this, ContainerViewState.this.ed, e);
            this.updateObject(view, e);
            ContainerViewState.this.addRootView(view);
            return view;
        }

        protected void updateObject(ContainerView object, Entity e) {
            log.info("update container:" + (Object)((Object)object));
        }

        protected void removeObject(ContainerView object, Entity e) {
            log.info("remove container:" + (Object)((Object)object));
            object.release();
            ContainerViewState.this.removeRootView(object);
        }
    }

    private class FlyOverFunction
    implements Function<Vector2f, String> {
        private FlyOverFunction() {
        }

        @Override
        public String apply(Vector2f pos) {
            String objectName;
            CollisionResults results = new CollisionResults();
            int count = ((GuiState)ContainerViewState.this.getState(GuiState.class)).pickScreen(pos, results);
            if (count > 0) {
                return null;
            }
            PerspectiveGuiState gui = (PerspectiveGuiState)ContainerViewState.this.getState(PerspectiveGuiState.class);
            Ray ray = gui.getPerspectiveRay(pos);
            if (ray == null) {
                return null;
            }
            results = new CollisionResults();
            count = gui.getRoot().collideWith((Collidable)ray, results);
            if (count == 0) {
                return null;
            }
            CollisionResult closest = results.getClosestCollision();
            Spatial hitSpatial = ContainerViewState.this.getEntitySpatial((Spatial)closest.getGeometry());
            EntityId hit = ContainerViewState.this.getEntityId(hitSpatial);
            log.info("Closest:" + hit);
            if (hit == null) {
                return null;
            }
            ContainerView container = (ContainerView)((Object)ContainerViewState.this.playerContainers.getObject(hit));
            if (container != null) {
                hit = container.getEntityId(closest.getContactPoint());
            }
            if (hit == null) {
                return null;
            }
            if (container != null) {
                hitSpatial = container.getEntityView(closest.getContactPoint()).getModel();
            }
            if (hitSpatial != null && (objectName = (String)hitSpatial.getUserData("objectName")) != null) {
                return objectName;
            }
            log.warn("No cached object name for:" + hit + "  hitSpatial:" + hitSpatial);
            ObjectName on = (ObjectName)ContainerViewState.this.ed.getComponent(hit, ObjectName.class);
            if (on != null) {
                return on.getName(ContainerViewState.this.ed);
            }
            Name n = (Name)ContainerViewState.this.ed.getComponent(hit, Name.class);
            if (n != null) {
                return n.getName();
            }
            return String.valueOf(hit);
        }
    }

    private class LocationFunction
    implements Function<EntityId, Vector3f> {
        private LocationFunction() {
        }

        @Override
        public Vector3f apply(EntityId id) {
            ItemView result = (ItemView)((Object)ContainerViewState.this.itemViews.get(id));
            if (result == null) {
                Vector2f pos = ContainerViewState.this.getApplication().getInputManager().getCursorPosition();
                return new Vector3f(pos.x, pos.y, 100.0f);
            }
            return ((PerspectiveGuiState)ContainerViewState.this.getState(PerspectiveGuiState.class)).getGuiLocation(result.getWorldTranslation());
        }
    }

    private class Holder {
        private WatchedEntity entity;
        private EntityId itemId;
        private ItemView item;
        private Label icon = new Label("");

        public Holder(WatchedEntity entity) {
            this.entity = entity;
            IconComponent ic = new IconComponent("Interface/right-hand.png");
            ic.setAlphaDiscard(0.1f);
            this.icon.setIcon((GuiComponent)ic);
            this.updateHolding();
        }

        public void release() {
            this.entity.release();
            this.setItemView(null);
        }

        public boolean update() {
            if (this.entity.applyChanges()) {
                this.updateHolding();
                return true;
            }
            return false;
        }

        public boolean isHolding(EntityId id) {
            return Objects.equals(this.itemId, id);
        }

        protected void setItemId(EntityId itemId) {
            if (Objects.equals(itemId, this.itemId)) {
                return;
            }
            this.itemId = itemId;
            this.setItemView(ContainerViewState.this.getItemView(itemId));
        }

        protected void setItemView(ItemView item) {
            if (this.item == item) {
                return;
            }
            if (this.item != null) {
                log.info("Remove overlay from:" + (Object)((Object)this.item));
                this.item.removeOverlay((Spatial)this.icon);
            }
            this.item = item;
            if (item != null) {
                log.info("Add overlay to:" + (Object)((Object)item));
                item.addOverlay((Spatial)this.icon);
            }
        }

        protected void updateHolding() {
            Holding holding = (Holding)this.entity.get(Holding.class);
            if (holding == null) {
                this.setItemId(null);
            } else {
                this.setItemId(holding.getTarget());
            }
        }
    }
}

