/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import mythruna.client.ui.MapLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapComponent
extends AbstractGuiComponent
implements ColoredComponent,
MapLayer {
    static Logger log = LoggerFactory.getLogger(MapComponent.class);
    private AssetManager assets;
    private Texture mapTexture;
    private Texture fluidTexture;
    private Vector2f textureOffset = new Vector2f();
    private Geometry geometry;
    private Quad mapQuad;
    private Material material;
    private ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private float alpha = 1.0f;
    private double tileSize;
    private Vec3d worldCenter = new Vec3d();
    private double worldRadius = 7680.0;

    public MapComponent(AssetManager assets, Texture mapTexture, Texture fluidTexture, double tileSize) {
        this.assets = assets;
        this.mapTexture = mapTexture;
        this.fluidTexture = fluidTexture;
        this.tileSize = tileSize;
    }

    public void attach(GuiControl parent) {
        super.attach(parent);
    }

    public void detach(GuiControl parent) {
        if (this.geometry != null) {
            this.getNode().detachChild((Spatial)this.geometry);
        }
        super.detach(parent);
    }

    public void setColor(ColorRGBA c) {
        this.color = c;
        this.resetColor();
    }

    protected void resetColor() {
        if (this.material == null) {
            return;
        }
        if (this.alpha >= 1.0f) {
            this.material.setColor("Color", this.color);
        } else {
            ColorRGBA adjusted = this.color != null ? this.color.clone() : ColorRGBA.White.clone();
            adjusted.a *= this.alpha;
            this.material.setColor("Color", adjusted);
        }
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
        this.resetColor();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setMapTexture(Texture t) {
        if (this.mapTexture == t) {
            return;
        }
        this.mapTexture = t;
        if (this.material != null) {
            this.material.setTexture("TerrainMap", this.mapTexture);
        }
    }

    public Texture getMapTexture() {
        return this.mapTexture;
    }

    public void setFluidTexture(Texture t) {
        if (this.mapTexture == t) {
            return;
        }
        this.mapTexture = t;
        if (this.material != null) {
            this.material.setTexture("FluidMap", this.mapTexture);
        }
    }

    public Texture getFluidTexture() {
        return this.mapTexture;
    }

    @Override
    public void setWorldCenter(Vec3d worldCenter) {
        this.worldCenter.set(worldCenter);
        this.resetTextureOffset();
    }

    public Vec3d getWorldCenter() {
        return this.worldCenter;
    }

    @Override
    public void setWorldRadius(double worldRadius) {
        this.worldRadius = worldRadius;
        this.resetTextureCoordinates();
    }

    public double getWorldRadius() {
        return this.worldRadius;
    }

    protected void resetTextureCoordinates() {
        double tileRadius = this.worldRadius / 1024.0;
        double textureRadius = tileRadius * this.tileSize;
        double xCenter = 0.5;
        double yCenter = 0.5;
        float x1 = (float)(xCenter - textureRadius);
        float y1 = (float)(yCenter - textureRadius);
        float x2 = (float)(xCenter + textureRadius);
        float y2 = (float)(yCenter + textureRadius);
        if (this.mapQuad != null) {
            this.mapQuad.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{x1, y1, x2, y1, x2, y2, x1, y2});
        }
    }

    protected void resetTextureOffset() {
        TileId tile = TileId.fromWorld((Vec3d)this.worldCenter);
        Vec3d offset = this.worldCenter.subtract(tile.getWorld(null).toVec3d());
        float xOffset = (float)(offset.x / 1024.0 * this.tileSize);
        float zOffset = (float)(offset.z / 1024.0 * this.tileSize);
        this.textureOffset.set(xOffset, zOffset);
    }

    public void calculatePreferredSize(Vector3f size) {
    }

    public void reshape(Vector3f pos, Vector3f size) {
        this.refreshBackground(size.y);
        this.geometry.setLocalTranslation(pos.x, pos.y - size.y, pos.z);
    }

    protected void createMaterial() {
        this.material = new Material(this.assets, "MatDefs/Map.j3md");
        if (this.mapTexture != null) {
            this.material.setTexture("TerrainMap", this.mapTexture);
        }
        if (this.fluidTexture != null) {
            this.material.setTexture("FluidMap", this.fluidTexture);
        }
        this.material.setVector2("TextureOffset", this.textureOffset);
        this.material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.material.setFloat("AlphaDiscardThreshold", 0.1f);
        this.material.setFloat("GridSpacing", (float)(1024.0 * this.tileSize));
        this.resetColor();
    }

    protected void refreshBackground(float size) {
        if (log.isTraceEnabled()) {
            log.trace("refreshBackground(" + size + ")");
        }
        if (this.geometry == null) {
            Quad q = this.mapQuad = new Quad(size, size);
            this.resetTextureCoordinates();
            this.geometry = new Geometry("map", (Mesh)q);
            if (this.material == null) {
                this.createMaterial();
            }
            this.geometry.setMaterial(this.material);
            this.getNode().attachChild((Spatial)this.geometry);
        } else {
            Quad q = (Quad)this.geometry.getMesh();
            if (size != q.getWidth() || size != q.getHeight()) {
                q.updateGeometry(size, size);
                q.clearCollisionData();
            }
        }
    }
}

