/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.simsilica.ext.mblock.PartDebugShapeFactory;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.debug.BinStatusState;
import com.simsilica.ext.mphys.debug.BodyDebugState;
import com.simsilica.ext.mphys.debug.ContactDebugState;
import com.simsilica.ext.mphys.debug.DebugShapeFactory;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.PhysicsStats;
import com.simsilica.mworld.ColumnId;
import com.simsilica.state.CompositeAppState;
import com.simsilica.state.DebugHudState;
import mythruna.client.MythrunaConfig;
import mythruna.client.net.HostedGameState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.DebugFunctions;
import mythruna.client.view.ProbeDebugState;
import mythruna.client.view.ViewFrustumDebugShapeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicsDebugState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(PhysicsDebugState.class);
    private HostedGameState host;
    private PhysicsStats stats;
    private VersionedHolder<String> contacts;
    private VersionedHolder<String> frameTime;
    private VersionedHolder<String> binCount;
    private VersionedHolder<String> activeBinCount;
    private VersionedHolder<String> bodyCount;
    private VersionedHolder<String> activeBodyCount;

    public PhysicsDebugState(HostedGameState host) {
        super(new AppState[0]);
        this.host = host;
    }

    protected void initialize(Application app) {
        PhysicsSpace phys = (PhysicsSpace)this.host.getSystems().get(PhysicsSpace.class);
        this.stats = phys.getStats();
        this.addChild((AppState)new BinStatusState(phys, 64.0f));
        this.addChild((AppState)new BodyDebugState((MPhysSystem)this.host.getSystems().get(MPhysSystem.class)));
        this.addChild((AppState)new ContactDebugState(phys));
        this.addChild((AppState)new ProbeDebugState(this.host));
        MythrunaConfig config = MythrunaConfig.getInstance();
        ((BodyDebugState)this.getChild(BodyDebugState.class)).setEnabled(config.getStartupSetting("BodyDebugState.enabled", false).booleanValue());
        ((ContactDebugState)this.getChild(ContactDebugState.class)).setEnabled(config.getStartupSetting("ContactDebugState.enabled", false).booleanValue());
        ((ProbeDebugState)this.getChild(ProbeDebugState.class)).setEnabled(config.getStartupSetting("ProbeDebugState.enabled", false));
        ((BodyDebugState)this.getChild(BodyDebugState.class)).addDebugShapeFactory((DebugShapeFactory)new PartDebugShapeFactory());
        ((BodyDebugState)this.getChild(BodyDebugState.class)).addDebugShapeFactory((DebugShapeFactory)new ViewFrustumDebugShapeFactory());
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            this.frameTime = debug.createDebugValue("Phys Time", DebugHudState.Location.Right);
            this.contacts = debug.createDebugValue("Contacts", DebugHudState.Location.Right);
            this.binCount = debug.createDebugValue("Bins", DebugHudState.Location.Right);
            this.activeBinCount = debug.createDebugValue("Active Bins", DebugHudState.Location.Right);
            this.bodyCount = debug.createDebugValue("Bodies", DebugHudState.Location.Right);
            this.activeBodyCount = debug.createDebugValue("Active Bodies", DebugHudState.Location.Right);
        }
    }

    protected void cleanup(Application app) {
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            debug.removeDebugValue("Contacts");
            debug.removeDebugValue("Phys Time");
            debug.removeDebugValue("Bins");
            debug.removeDebugValue("Active Bins");
            debug.removeDebugValue("Bodies");
            debug.removeDebugValue("Active Bodies");
        }
    }

    public void update(float tpf) {
        BinStatusState binState = (BinStatusState)this.getState(BinStatusState.class);
        if (binState != null) {
            Vec3d pos = ((AvatarState)this.getState(AvatarState.class)).getPosition();
            ColumnId col = ColumnId.fromWorld((Vec3d)pos);
            Vec3i newCenter = col.getWorld(null);
            binState.setViewOrigin((double)newCenter.x, 0.0, (double)newCenter.z);
            BodyDebugState bodyState = (BodyDebugState)this.getState(BodyDebugState.class);
            bodyState.setViewOrigin((double)newCenter.x, 0.0, (double)newCenter.z);
            ContactDebugState contactState = (ContactDebugState)this.getState(ContactDebugState.class);
            contactState.setViewOrigin((double)newCenter.x, 0.0, (double)newCenter.z);
            ProbeDebugState probeState = (ProbeDebugState)this.getState(ProbeDebugState.class);
            probeState.setViewOrigin(newCenter.x, 0.0, newCenter.z);
        }
        if (this.contacts != null) {
            this.frameTime.setObject((Object)String.format("%.2f ms", this.stats.getDouble("frameTime") / 1000000.0));
            this.contacts.setObject((Object)String.valueOf(this.stats.getLong("contacts")));
            this.binCount.setObject((Object)String.valueOf(this.stats.getLong("binCount")));
            this.activeBinCount.setObject((Object)String.valueOf(this.stats.getLong("activeBinCount")));
            this.bodyCount.setObject((Object)String.valueOf(this.stats.getLong("bodyCount")));
            this.activeBodyCount.setObject((Object)String.valueOf(this.stats.getLong("activeBodyCount")));
        }
    }

    protected void onEnable() {
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        if (!input.hasMappings(DebugFunctions.F_BIN_DEBUG)) {
            DebugFunctions.initializeDefaultMappings(input);
        }
        input.addDelegate(DebugFunctions.F_BIN_DEBUG, (Object)this.getState(BinStatusState.class), "toggleEnabled");
        input.addDelegate(DebugFunctions.F_BODY_DEBUG, (Object)this.getState(BodyDebugState.class), "toggleEnabled");
        input.addDelegate(DebugFunctions.F_CONTACT_DEBUG, (Object)this.getState(ContactDebugState.class), "toggleEnabled");
        input.addDelegate(DebugFunctions.F_PROBE_DEBUG, (Object)this.getState(ProbeDebugState.class), "toggleEnabled");
    }

    protected void onDisable() {
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        input.removeDelegate(DebugFunctions.F_BIN_DEBUG, (Object)this.getState(BinStatusState.class), "toggleEnabled");
        input.removeDelegate(DebugFunctions.F_BODY_DEBUG, (Object)this.getState(BodyDebugState.class), "toggleEnabled");
        input.removeDelegate(DebugFunctions.F_CONTACT_DEBUG, (Object)this.getState(ContactDebugState.class), "toggleEnabled");
        input.removeDelegate(DebugFunctions.F_PROBE_DEBUG, (Object)this.getState(ProbeDebugState.class), "toggleEnabled");
    }
}

