/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Quad;
import com.jme3.shader.VarType;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.World;
import com.simsilica.mworld.WorldGrids;
import com.simsilica.mworld.base.LightNeighborhood;
import com.simsilica.mworld.net.client.WorldClientService;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.ViewMask;
import com.simsilica.sim.Blackboard;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.GameSystemsState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.client.GameSessionState;
import mythruna.client.MythrunaConfig;
import mythruna.client.view.AvatarState;
import mythruna.world.es.WorldSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(WorldViewState.class);
    private Node viewRoot;
    private JobState workers;
    private JobState hiWorkers;
    private WorldClientService world;
    private long worldSeed;
    private VersionedReference<Vec3d> posRef;
    private Grid leafGrid = WorldGrids.LEAF_GRID;
    private Vec3i viewRadius = new Vec3i(3, 4, 3);
    private Vec3i centerCell = new Vec3i(0, -1000, 0);
    private Vec3i centerWorld = new Vec3i();
    private Vec3i maxViewRadius = new Vec3i(7, 9, 7);
    private ViewMask viewMask;
    private int maxBuildHeight = 672;
    private float yMin;
    private float yMax;
    private Slot[] slots;
    private Geometry debugCellTemplate;
    private ColorRGBA loadingColor;
    private ColorRGBA emptyColor;
    private ColorRGBA filledColor;
    private Map<LeafId, LeafView> viewCache;
    private LeafObserver leafObserver;
    private GeometryFactory geomFactory;
    private FogSettings fogSettings;
    private VersionedReference<FogSettings> fogSettingsRef;
    private ConcurrentLinkedQueue<LeafId> updatedLeafIds;
    private boolean wireframe;
    private boolean smoothLighting;
    private boolean wireDebug;
    private boolean showFlora;
    private boolean maskDebugEnabled;
    private Spatial maskDebug;
    private boolean debugTest;
    private Set<LeafId> working;
    private static Set<String> floraTypes = new HashSet<String>(Arrays.asList("mesh:MaterialType{name=flowers, layer=9, geomReqs=[Sizes]}:Points", "mesh:MaterialType{name=dry-flowers, layer=9, geomReqs=[Sizes]}:Points", "mesh:MaterialType{name=grass-atlas, geomReqs=[IndexedNormals]}:Triangles", "mesh:MaterialType{name=dry-grass-atlas, geomReqs=[IndexedNormals]}:Triangles"));

    public WorldViewState() {
        this.yMin = this.viewRadius.y * 32;
        this.yMax = this.maxBuildHeight - this.viewRadius.y * 32 - 32;
        this.loadingColor = new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f);
        this.emptyColor = new ColorRGBA(0.2f, 0.4f, 0.6f, 0.1f);
        this.filledColor = new ColorRGBA(1.0f, 1.0f, 0.0f, 0.5f);
        this.viewCache = new HashMap<LeafId, LeafView>();
        this.leafObserver = new LeafObserver();
        this.updatedLeafIds = new ConcurrentLinkedQueue();
        this.wireframe = false;
        this.smoothLighting = true;
        this.wireDebug = false;
        this.showFlora = true;
        this.maskDebugEnabled = false;
        this.debugTest = false;
        this.working = new HashSet<LeafId>();
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void setShowGrid(boolean showGrid) {
        this.wireDebug = showGrid;
        this.resetWireDebug();
    }

    public boolean getShowGrid() {
        return this.wireDebug;
    }

    public void setShowFlora(boolean showFlora) {
        log.info("setShowFlora(" + showFlora + ")");
        this.showFlora = showFlora;
        this.resetFlora();
    }

    public boolean getShowFlora() {
        return this.showFlora;
    }

    public void setDebugTestEnabled(boolean debugTest) {
        if (this.debugTest == debugTest) {
            return;
        }
        this.debugTest = debugTest;
        for (Material m : ((GameSessionState)this.getState(GameSessionState.class)).getBlockMaterials().values()) {
            if (m.getMaterialDef().getMaterialParam("TestMode") == null) continue;
            m.setBoolean("TestMode", debugTest);
        }
    }

    public boolean getDebugTestEnabled() {
        return this.debugTest;
    }

    public void addCellChangeListener(CellChangeListener l) {
        this.world.addCellChangeListener(l);
    }

    public void removeCellChangeListener(CellChangeListener l) {
        this.world.removeCellChangeListener(l);
    }

    public void setViewRadius(int radius) {
        this.setViewRadius(radius, true);
    }

    public void setViewRadius(int radius, boolean updateConfig) {
        log.info("setViewRadius(" + radius + ")");
        radius = Math.min(radius, this.maxViewRadius.x);
        radius = Math.max(0, radius);
        if (this.viewRadius.x == radius) {
            return;
        }
        this.viewRadius.set(radius, radius + 1, radius);
        log.info("new viewRadius:" + this.viewRadius);
        this.yMin = this.viewRadius.y * 32;
        this.yMax = this.maxBuildHeight - this.viewRadius.y * 32 - 32;
        this.clearViewMask();
        this.resetSlotArray();
        if (this.posRef != null) {
            this.updateViewPosition((Vec3d)this.posRef.get(), true);
        }
        if (updateConfig) {
            MythrunaConfig config = MythrunaConfig.getInstance();
            log.info("updating: WorldViewState.viewRadius  to: " + radius);
            config.getStartupSettings().put("WorldViewState.viewRadius", radius);
            MythrunaConfig.save();
        }
    }

    public int getViewRadius() {
        return this.viewRadius.x;
    }

    public void setSmoothLighting(boolean b) {
        if (this.smoothLighting == b) {
            return;
        }
        this.smoothLighting = b;
        if (this.posRef != null) {
            this.updateViewPosition((Vec3d)this.posRef.get(), true);
        }
    }

    public boolean getSmoothLighting() {
        return this.smoothLighting;
    }

    public int getWorldLight(int x, int y, int z) {
        if (y < 0) {
            return -1;
        }
        LeafId id = LeafId.fromWorld((int)x, (int)y, (int)z);
        LightData light = this.world.getLight(id);
        if (light == null) {
            return -1;
        }
        Vec3i leafOrigin = id.getWorld(null);
        return light.getCell(x -= leafOrigin.x, y -= leafOrigin.y, z -= leafOrigin.z);
    }

    public Integer getWorldLightIfPresent(int x, int y, int z) {
        if (y < 0) {
            return -1;
        }
        LeafId id = LeafId.fromWorld((int)x, (int)y, (int)z);
        LightData light = this.world.getLightIfPresent(id);
        if (light == null) {
            return null;
        }
        Vec3i leafOrigin = id.getWorld(null);
        return light.getCell(x -= leafOrigin.x, y -= leafOrigin.y, z -= leafOrigin.z);
    }

    protected long lookupWorldSeed() {
        WorldSeed seed = (WorldSeed)((GameSystemsState)this.getState(GameSystemsState.class, true)).get(WorldSeed.class);
        return seed.getSeed();
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        MythrunaConfig config = MythrunaConfig.getInstance();
        this.setEnabled(config.getStartupSetting("WorldViewState.enabled", true));
        int viewRadius = config.getStartupSettingInt("WorldViewState.viewRadius", 3);
        log.info("viewRadius:" + viewRadius);
        this.setViewRadius(viewRadius, false);
        this.viewRoot = new Node("WorldViewRoot");
        this.viewMask = new ViewMask(this.leafGrid, this.maxViewRadius);
        Blackboard blackboard = ((BlackboardState)this.getState("session", BlackboardState.class, true)).getBlackboard();
        blackboard.set(ViewMask.class, (Object)this.viewMask);
        blackboard.onInitialize(FogSettings.class, fogSettings -> {
            this.fogSettings = fogSettings;
            this.fogSettingsRef = fogSettings.createReference();
        });
        this.workers = (JobState)this.getState(JobState.class);
        this.hiWorkers = (JobState)this.getState("priorityWorkers", JobState.class, true);
        this.world = (WorldClientService)((GameSessionState)this.getState(GameSessionState.class, true)).getWorld();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
        this.worldSeed = this.lookupWorldSeed();
        WireBox box = new WireBox(15.9f, 15.9f, 15.9f);
        Geometry geom = new Geometry("debugBox", (Mesh)box);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(this.loadingColor, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.debugCellTemplate = geom;
        this.world.addLeafChangeListener((LeafChangeListener)this.leafObserver);
        this.resetSlotArray();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
    }

    public void setMaskDebug(boolean maskDebugEnabled) {
        if (this.maskDebugEnabled == maskDebugEnabled) {
            return;
        }
        this.maskDebugEnabled = maskDebugEnabled;
        this.resetMaskDebug();
    }

    public boolean getMaskDebug() {
        return this.maskDebugEnabled;
    }

    protected void resetMaskDebug() {
        boolean visible;
        boolean bl = visible = this.maskDebugEnabled && this.isEnabled();
        if (visible) {
            if (this.maskDebug == null) {
                this.createViewMaskDebugView();
            }
            ((SimpleApplication)this.getApplication()).getGuiNode().attachChild(this.maskDebug);
            this.maskDebug.setLocalTranslation(0.0f, 0.0f, 0.0f);
        } else if (this.maskDebug != null) {
            this.maskDebug.removeFromParent();
        }
    }

    protected void createViewMaskDebugView() {
        Vec3i maskSize = this.viewMask.getSize();
        Material mat = new Material(this.getApplication().getAssetManager(), "MatDefs/UnshadedArray.j3md");
        mat.setTexture("ColorMap", this.viewMask.getMaskTextures());
        Node debug = new Node("maskDebug");
        for (int i = 0; i < maskSize.y; ++i) {
            Quad quad = new Quad((float)maskSize.x, (float)maskSize.z);
            quad.clearBuffer(VertexBuffer.Type.TexCoord);
            quad.setBuffer(VertexBuffer.Type.TexCoord, 3, new float[]{0.0f, 0.0f, i, 1.0f, 0.0f, i, 1.0f, 1.0f, i, 0.0f, 1.0f, i});
            Geometry geom = new Geometry("maskTest", (Mesh)quad);
            geom.setMaterial(mat);
            geom.setLocalTranslation((float)((maskSize.x + 2) * i), 5.0f, 0.0f);
            debug.attachChild((Spatial)geom);
        }
        debug.setLocalScale(1.0f);
        debug.move(1.0f, 1.0f, 0.0f);
        this.maskDebug = debug;
    }

    protected void cleanup(Application app) {
        this.world.removeLeafChangeListener((LeafChangeListener)this.leafObserver);
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.viewRoot);
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
        this.resetMaskDebug();
    }

    protected void onDisable() {
        this.viewRoot.removeFromParent();
        this.clearViewMask();
        if (this.maskDebug != null) {
            this.maskDebug.removeFromParent();
        }
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        if (this.fogSettingsRef != null && this.fogSettingsRef.update()) {
            this.resetFog();
        }
        LeafId leafId = null;
        while ((leafId = this.updatedLeafIds.poll()) != null) {
            this.leafChanged(leafId);
        }
    }

    protected void resetSlotArray() {
        int xSize = this.viewRadius.x * 2 + 1;
        int ySize = this.viewRadius.y * 2 + 1;
        int zSize = this.viewRadius.z * 2 + 1;
        this.slots = new Slot[xSize * ySize * zSize];
        int index = 0;
        for (int x = -this.viewRadius.x; x <= this.viewRadius.x; ++x) {
            for (int y = -this.viewRadius.y; y <= this.viewRadius.y; ++y) {
                for (int z = -this.viewRadius.z; z <= this.viewRadius.z; ++z) {
                    this.slots[index] = new Slot(x, y, z);
                    ++index;
                }
            }
        }
        Arrays.sort(this.slots);
    }

    public void updateViewPosition(Vec3d pos, boolean forceUpdate) {
        Vec3d adjusted = pos.clone();
        if (adjusted.y < (double)this.yMin) {
            adjusted.y = this.yMin;
        } else if (adjusted.y > (double)this.yMax) {
            adjusted.y = this.yMax;
        }
        Vec3i newCenter = this.leafGrid.worldToCell(adjusted);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        Vec3d realCenterWorld = this.leafGrid.getContainingCell(pos).getWorldOrigin().toVec3d();
        log.debug("updateViewPosition(" + pos + ") newCenter:" + newCenter);
        this.centerCell.set(newCenter);
        this.centerWorld = this.leafGrid.cellToWorld(this.centerCell);
        this.viewMask.setCenterWorld(this.centerWorld);
        log.debug("Refreshing local view, centerWorld:" + this.centerWorld + "   pos:" + pos);
        HashSet<LeafId> toRemove = new HashSet<LeafId>(this.viewCache.keySet());
        Vec3d world = new Vec3d();
        for (Slot e : this.slots) {
            world.set(this.centerWorld).addLocal(e.worldOffset);
            if (world.y < 0.0) {
                log.warn("Skipping entry below the world:" + world);
                continue;
            }
            LeafId leafId = LeafId.fromWorld((Vec3d)world);
            toRemove.remove(leafId);
            LeafView view = this.viewCache.get(leafId);
            if (view == null) {
                this.viewMask.setRendered(e.cellOffset, false);
                view = new LeafView(leafId);
                view.setSmoothLighting(this.smoothLighting);
                this.viewCache.put(leafId, view);
                if (!this.working.add(leafId)) {
                    log.warn("queuing but already working:" + leafId);
                }
                view.queued = true;
                this.workers.execute((Job)view, e.basePriority);
            } else {
                this.viewMask.setRendered(e.cellOffset, view.rendered);
                if (view.setSmoothLighting(this.smoothLighting)) {
                    if (!this.working.add(leafId)) {
                        log.warn("re-queuing but already working:" + leafId);
                    }
                    view.queued = true;
                    this.workers.execute((Job)view, e.basePriority);
                }
            }
            view.updateOffset(e.worldOffset);
            view.setCenter(e.basePriority == 0);
            e.leafView = view;
        }
        if (this.slots[0].leafView != null) {
            this.slots[0].leafView.setCenter(true);
        }
        for (LeafId remove : toRemove) {
            LeafView view = this.viewCache.remove(remove);
            if (view == null) continue;
            if (view.queued && this.workers.cancel((Job)view)) {
                this.working.remove(view.leafId);
                view.queued = false;
            }
            view.release();
        }
        if (this.viewCache.size() != this.slots.length) {
            log.error("*** Major data integrity error in view cache, cache size:" + this.viewCache.size() + "  should be:" + this.slots.length);
        }
    }

    protected void updateViewMask(LeafId leafId) {
        for (Slot e : this.slots) {
            if (e.leafView == null || !Objects.equals(e.leafView.leafId, leafId)) continue;
            this.viewMask.setRendered(e.cellOffset, true);
        }
    }

    protected void clearViewMask() {
        if (this.slots == null) {
            return;
        }
        for (Slot e : this.slots) {
            this.viewMask.setRendered(e.cellOffset, false);
        }
    }

    protected void resetFog() {
        this.fixFog((Spatial)this.viewRoot);
    }

    protected void resetWireDebug() {
        for (Slot e : this.slots) {
            if (e.leafView == null) continue;
            e.leafView.resetWireDebug();
        }
    }

    protected void resetFlora() {
        log.info("resetFlora()");
        for (Slot e : this.slots) {
            if (e.leafView == null) continue;
            e.leafView.resetFlora();
        }
    }

    protected void leafChanged(LeafId leafId) {
        if (log.isTraceEnabled()) {
            log.trace("leafChanged(" + leafId + ")");
        }
        LeafView view = this.viewCache.get(leafId);
        if (log.isTraceEnabled()) {
            log.trace("view:" + view);
        }
        if (view != null) {
            view.queued = true;
            this.hiWorkers.execute((Job)view, -1);
        }
    }

    protected void fixFog(Spatial s) {
        float fadeDistance = this.viewRadius.x * 32;
        this.updateFogDistance(s, this.fogSettings.getFogDistance(), fadeDistance, this.fogSettings.getFogColor());
    }

    protected void updateFogDistance(Spatial s, final float distance, final float fadeDistance, final ColorRGBA fogColor) {
        s.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                if (mat.getParam("UseFog") == null) {
                    return;
                }
                if (distance > 0.0f) {
                    mat.setBoolean("UseFog", true);
                    mat.setFloat("ExpFog", 1.0f / distance);
                    mat.setColor("FogColor", fogColor);
                } else {
                    mat.setBoolean("UseFog", false);
                }
                if (fadeDistance > 0.0f && mat.getParam("FadeDistance") != null) {
                    mat.setFloat("FadeDistance", fadeDistance);
                }
            }
        });
    }

    static /* synthetic */ ColorRGBA access$400(WorldViewState x0) {
        return x0.loadingColor;
    }

    private class LeafObserver
    implements LeafChangeListener {
        private LeafObserver() {
        }

        public void leafChanged(LeafChangeEvent event) {
            if (log.isTraceEnabled()) {
                log.trace("leafChanged(" + event + ")");
            }
            WorldViewState.this.updatedLeafIds.add(event.getLeafId());
        }
    }

    private class Slot
    implements Comparable<Slot> {
        Vec3i cellOffset;
        int basePriority;
        Vec3d worldOffset;
        LeafView leafView;

        public Slot(int x, int y, int z) {
            this.cellOffset = new Vec3i(x, y, z);
            this.basePriority = x * x + y * y + z * z;
            this.worldOffset = new Vec3d((double)(x * 32), (double)(y * 32), (double)(z * 32));
        }

        @Override
        public int compareTo(Slot other) {
            if (this.basePriority < other.basePriority) {
                return -1;
            }
            if (this.basePriority > other.basePriority) {
                return 1;
            }
            return 0;
        }
    }

    private class LeafView
    implements Job {
        private LeafId leafId;
        private Node leafNode;
        private Geometry debugGeom;
        private LeafData leafData;
        private FluidData fluidData;
        private CellData lightData;
        private Node parts;
        private Node generatedParts;
        private boolean rendered = false;
        private boolean smoothLighting = false;
        private boolean released = false;
        private boolean center = false;
        private ColorRGBA boxColor = WorldViewState.access$400(WorldViewState.this);
        private volatile boolean queued;

        public LeafView(LeafId leafId) {
            this.leafId = leafId;
            this.leafNode = new Node("leafNode:" + leafId);
            WorldViewState.this.viewRoot.attachChild((Spatial)this.leafNode);
            Vec3i world = leafId.getWorld(null);
            if (world.y >= 672) {
                throw new IllegalArgumentException("LeafID exceeds world height:672  y:" + world.y);
            }
            this.resetWireDebug();
        }

        public void resetWireDebug() {
            if (WorldViewState.this.wireDebug) {
                this.debugGeom = WorldViewState.this.debugCellTemplate.clone(false);
                this.debugGeom.move(16.0f, 16.0f, 16.0f);
                this.leafNode.attachChild((Spatial)this.debugGeom);
                this.setBoxColor(this.boxColor);
            } else if (this.debugGeom != null) {
                this.debugGeom.removeFromParent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetFlora() {
            LeafView leafView = this;
            synchronized (leafView) {
                this.leafNode.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                    public void visit(Geometry geom) {
                        if (floraTypes.contains(geom.getName())) {
                            if (WorldViewState.this.showFlora) {
                                geom.setCullHint(Spatial.CullHint.Inherit);
                            } else {
                                geom.setCullHint(Spatial.CullHint.Always);
                            }
                        }
                    }
                });
            }
        }

        public void setCenter(boolean center) {
            this.center = center;
            this.setBoxColor(this.boxColor);
        }

        public boolean setSmoothLighting(boolean b) {
            if (this.smoothLighting == b) {
                return false;
            }
            this.smoothLighting = b;
            this.rendered = false;
            return true;
        }

        public void updateOffset(Vec3d worldOffset) {
            this.leafNode.setLocalTranslation((float)worldOffset.x, (float)((double)((WorldViewState)WorldViewState.this).centerWorld.y + worldOffset.y), (float)worldOffset.z);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnWorker() {
            Node temp;
            this.queued = false;
            long start = System.nanoTime();
            this.leafData = WorldViewState.this.world.getLeaf(this.leafId);
            long end = System.nanoTime();
            log.debug("Retrieved leaf data in:" + (double)(end - start) / 1000000.0 + " ms");
            if (log.isTraceEnabled()) {
                log.trace("loaded(" + this.leafId + "):" + this.leafData);
            }
            if (this.leafData == null) {
                log.error("null leaf data for:" + this.leafId + " loc:" + this.leafId.getWorld(null));
                return;
            }
            Object object = this.leafData;
            synchronized (object) {
                start = System.nanoTime();
                this.fluidData = WorldViewState.this.world.getFluid(this.leafId);
                end = System.nanoTime();
                log.debug("Retrieved fluid data in:" + (double)(end - start) / 1000000.0 + " ms");
                if (this.fluidData == null) {
                    log.error("null fluid data for:" + this.leafId + " loc:" + this.leafId.getWorld(null));
                    return;
                }
                if (this.leafData.isEmpty() && this.fluidData.isEmpty()) {
                    this.generatedParts = null;
                    return;
                }
                Vec3i worldPos = this.leafId.getWorld(null);
                start = System.nanoTime();
                LightData leafLight = WorldViewState.this.world.getLight(this.leafId);
                this.lightData = new LightNeighborhood((World)WorldViewState.this.world, leafLight);
                end = System.nanoTime();
                log.debug("loaded light data in:" + (double)(end - start) / 1000000.0 + " ms");
                log.trace("loaded light data");
                temp = new Node("Parts:" + this.leafId);
                if (!this.leafData.isEmpty()) {
                    WorldViewState.this.geomFactory.generateBlocks(temp, this.leafData.getRawCells(), this.lightData, this.smoothLighting);
                }
                if (!this.fluidData.isEmpty()) {
                    Node fluid = new Node("Fluid:" + this.leafId);
                    temp.attachChild((Spatial)fluid);
                    WorldViewState.this.geomFactory.generateFluid(fluid, this.fluidData.getRawCells(), this.leafData.getRawCells(), this.lightData, this.smoothLighting);
                }
            }
            WorldViewState.this.fixFog((Spatial)temp);
            if (WorldViewState.this.wireframe) {
                temp.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                    public void visit(Geometry geom) {
                        geom.getMaterial().getAdditionalRenderState().setWireframe(true);
                    }
                });
            }
            object = this;
            synchronized (object) {
                this.generatedParts = temp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double runOnUpdate() {
            WorldViewState.this.working.remove(this.leafId);
            if (this.released) {
                return 0.0;
            }
            if (this.parts != null) {
                this.parts.removeFromParent();
            }
            LeafView leafView = this;
            synchronized (leafView) {
                this.parts = this.generatedParts;
            }
            this.rendered = true;
            WorldViewState.this.updateViewMask(this.leafId);
            if (this.parts == null || this.leafNode.getParent() == null) {
                this.setBoxColor(WorldViewState.this.emptyColor);
                return 0.0;
            }
            this.setBoxColor(WorldViewState.this.filledColor);
            if (!this.parts.getChildren().isEmpty()) {
                this.leafNode.attachChild((Spatial)this.parts);
                if (!WorldViewState.this.showFlora) {
                    this.resetFlora();
                }
                return 1.0;
            }
            return 0.0;
        }

        protected void setBoxColor(ColorRGBA color) {
            this.boxColor = color;
            if (this.center) {
                color = ColorRGBA.Red;
            }
            if (WorldViewState.this.wireDebug) {
                MatParamOverride override = new MatParamOverride(VarType.Vector4, "Color", (Object)color);
                this.debugGeom.addMatParamOverride(override);
            }
        }

        public void release() {
            this.released = true;
            this.leafNode.removeFromParent();
        }
    }
}

