/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.shadow.ShadowUtil;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class DropShadowFilter
extends Filter {
    private static final int VERTS_PER_SHADOW = 8;
    private static final int TRIS_PER_SHADOW = 12;
    private static final int INDEXES_PER_SHADOW = 36;
    private static final Vector3f[] BASE_CORNERS = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f)};
    private static final short[] BASE_INDEXES = new short[]{4, 5, 6, 4, 6, 7, 3, 2, 1, 3, 1, 0, 0, 1, 5, 0, 5, 4, 2, 3, 7, 2, 7, 6, 3, 0, 4, 3, 4, 7, 1, 2, 6, 1, 6, 5};
    private Geometry shadowGeom;
    private Material shadowMaterial;
    private Mesh mesh;
    private int maxShadows;
    private ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f);
    private VertexBuffer vbPos;
    private VertexBuffer vbNormal;
    private VertexBuffer vbTexCoord;
    private VertexBuffer vbTexCoord2;
    private VertexBuffer vbIndex;
    private GeometryList casters;
    private boolean showBox = false;

    public DropShadowFilter() {
        this(500);
    }

    public DropShadowFilter(int maxShadows) {
        this.maxShadows = maxShadows;
    }

    public void setShadowIntensity(float f) {
        this.shadowColor.a = f;
    }

    public float getShadowIntensity() {
        return this.shadowColor.a;
    }

    public void setShowBox(boolean f) {
        this.showBox = f;
        if (this.shadowMaterial != null) {
            this.shadowMaterial.setBoolean("ShowBox", this.showBox);
        }
    }

    public boolean getShowBox() {
        return this.showBox;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void initFilter(AssetManager assets, RenderManager rm, ViewPort vp, int w, int h) {
        this.material = new Material(assets, "MatDefs/shadow/Null.j3md");
        this.mesh = new Mesh();
        this.mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createVector3Buffer((int)(this.maxShadows * 8)));
        this.mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createVector3Buffer((int)(this.maxShadows * 8)));
        this.mesh.setBuffer(VertexBuffer.Type.TexCoord, 3, BufferUtils.createVector3Buffer((int)(this.maxShadows * 8)));
        this.mesh.setBuffer(VertexBuffer.Type.TexCoord2, 3, BufferUtils.createVector3Buffer((int)(this.maxShadows * 8)));
        this.mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createShortBuffer((int)(this.maxShadows * 36)));
        this.vbPos = this.mesh.getBuffer(VertexBuffer.Type.Position);
        this.vbNormal = this.mesh.getBuffer(VertexBuffer.Type.Normal);
        this.vbTexCoord = this.mesh.getBuffer(VertexBuffer.Type.TexCoord);
        this.vbTexCoord2 = this.mesh.getBuffer(VertexBuffer.Type.TexCoord2);
        this.vbIndex = this.mesh.getBuffer(VertexBuffer.Type.Index);
        this.shadowGeom = new Geometry("shadowVolumes", this.mesh);
        Material m = this.shadowMaterial = new Material(assets, "MatDefs/shadow/Shadows.j3md");
        m.setColor("ShadowColor", this.shadowColor);
        m.setBoolean("ShowBox", this.showBox);
        m.getAdditionalRenderState().setDepthWrite(false);
        m.getAdditionalRenderState().setDepthTest(false);
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.shadowGeom.setMaterial(m);
        this.shadowGeom.setLocalTranslation(0.0f, 100.0f, 0.0f);
        this.shadowGeom.updateLogicalState(0.1f);
        this.shadowGeom.updateGeometricState();
        this.casters = new GeometryList((GeometryComparator)new CasterComparator());
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        int i;
        RenderQueue rq = viewPort.getQueue();
        for (Spatial scene : viewPort.getScenes()) {
            ShadowUtil.getGeometriesInCamFrustum((Spatial)scene, (Camera)viewPort.getCamera(), (RenderQueue.ShadowMode)RenderQueue.ShadowMode.Cast, (GeometryList)this.casters);
        }
        if (this.casters.size() == 0) {
            return;
        }
        Camera cam = viewPort.getCamera();
        BoundingSphere cullCheck = new BoundingSphere();
        Vector3f pos = new Vector3f();
        Texture frameTex = prevFilterBuffer.getColorBuffer().getTexture();
        Texture depthTex = prevFilterBuffer.getDepthBuffer().getTexture();
        this.shadowMaterial.setTexture("FrameTexture", frameTex);
        if (frameTex.getImage().getMultiSamples() > 1) {
            this.shadowMaterial.setInt("NumSamples", frameTex.getImage().getMultiSamples());
        } else {
            this.shadowMaterial.clearParam("NumSamples");
        }
        this.shadowMaterial.setTexture("DepthTexture", depthTex);
        if (depthTex.getImage().getMultiSamples() > 1) {
            this.shadowMaterial.setInt("NumSamplesDepth", depthTex.getImage().getMultiSamples());
        } else {
            this.shadowMaterial.clearParam("NumSamplesDepth");
        }
        int size = this.casters.size();
        if (size > this.maxShadows) {
            this.casters.setCamera(cam);
            this.casters.sort();
        }
        FloatBuffer bPos = (FloatBuffer)this.vbPos.getData().rewind();
        FloatBuffer bNormal = (FloatBuffer)this.vbNormal.getData().rewind();
        FloatBuffer bTexCoord = (FloatBuffer)this.vbTexCoord.getData().rewind();
        FloatBuffer bTexCoord2 = (FloatBuffer)this.vbTexCoord2.getData().rewind();
        ShortBuffer bIndex = (ShortBuffer)this.vbIndex.getData().rewind();
        Matrix4f viewMatrix = cam.getViewMatrix();
        Matrix4f worldMatrix = new Matrix4f();
        Matrix4f worldViewMatrix = new Matrix4f();
        float[] angles = new float[3];
        Vector3f vTemp = new Vector3f();
        Vector3f vert = new Vector3f();
        Vector3f viewDir = new Vector3f();
        Vector3f boxScale = new Vector3f();
        int rendered = 0;
        for (i = 0; i < size; ++i) {
            int j;
            float radius;
            float volumeHeight;
            Geometry g = this.casters.get(i);
            BoundingBox bounds = (BoundingBox)g.getModelBound();
            float scale = g.getWorldScale().x;
            float xEx = bounds.getXExtent() * scale;
            float yEx = bounds.getYExtent() * scale;
            float zEx = bounds.getZExtent() * scale;
            Quaternion quat = g.getWorldRotation();
            angles = quat.toAngles(angles);
            float cubeEpsilon = 0.01f;
            if (Math.abs(xEx - yEx) < cubeEpsilon && Math.abs(xEx - zEx) < cubeEpsilon && Math.abs(yEx - zEx) < cubeEpsilon) {
                volumeHeight = xEx;
                radius = xEx;
            } else {
                Quaternion yawSpace = new Quaternion().fromAngles(angles[0], 0.0f, angles[2]);
                Vector3f xAxis = yawSpace.mult(new Vector3f(xEx, 0.0f, 0.0f));
                Vector3f yAxis = yawSpace.mult(new Vector3f(0.0f, yEx, 0.0f));
                Vector3f zAxis = yawSpace.mult(new Vector3f(0.0f, 0.0f, zEx));
                xEx = Math.max(Math.max(Math.abs(xAxis.x), Math.abs(yAxis.x)), Math.abs(zAxis.x));
                yEx = Math.max(Math.max(Math.abs(xAxis.y), Math.abs(yAxis.y)), Math.abs(zAxis.y));
                zEx = Math.max(Math.max(Math.abs(xAxis.z), Math.abs(yAxis.z)), Math.abs(zAxis.z));
                volumeHeight = yEx;
                radius = Math.max(xEx, Math.max(yEx, zEx));
            }
            BoundingBox worldBounds = (BoundingBox)g.getWorldBound();
            pos.set(worldBounds.getCenter());
            pos.y -= yEx;
            pos.y -= volumeHeight * 0.5f;
            cullCheck.setCenter(pos);
            cullCheck.setRadius(radius);
            int save = cam.getPlaneState();
            cam.setPlaneState(0);
            Camera.FrustumIntersect intersect = cam.contains((BoundingVolume)cullCheck);
            cam.setPlaneState(save);
            if (intersect == Camera.FrustumIntersect.Outside) continue;
            boxScale.set(0.5f / xEx, 0.5f / volumeHeight, 0.5f / zEx);
            Quaternion rotation = new Quaternion().fromAngles(0.0f, angles[1], 0.0f);
            Quaternion invRotation = rotation.inverse();
            worldMatrix.setTranslation(pos);
            worldMatrix.setRotationQuaternion(rotation);
            worldViewMatrix.set(viewMatrix);
            worldViewMatrix.multLocal(worldMatrix);
            for (j = 0; j < 8; ++j) {
                vTemp.set(DropShadowFilter.BASE_CORNERS[j].x * xEx, DropShadowFilter.BASE_CORNERS[j].y * volumeHeight, DropShadowFilter.BASE_CORNERS[j].z * zEx);
                vert = worldMatrix.mult(vTemp, vert);
                bPos.put(vert.x).put(vert.y).put(vert.z);
                vert = vert.subtractLocal(cam.getLocation());
                vert.normalizeLocal();
                viewDir = invRotation.mult(vert, viewDir);
                bNormal.put(viewDir.x).put(viewDir.y).put(viewDir.z);
                bTexCoord.put(DropShadowFilter.BASE_CORNERS[j].x * xEx + xEx);
                bTexCoord.put(DropShadowFilter.BASE_CORNERS[j].y * volumeHeight + volumeHeight);
                bTexCoord.put(DropShadowFilter.BASE_CORNERS[j].z * zEx + zEx);
                bTexCoord2.put(boxScale.x).put(boxScale.y).put(boxScale.z);
            }
            for (j = 0; j < 36; ++j) {
                bIndex.put((short)(BASE_INDEXES[j] + rendered * 8));
            }
            if (++rendered >= this.maxShadows) break;
        }
        if (rendered > 0) {
            for (i = rendered; i < this.maxShadows; ++i) {
                for (int j = 0; j < 36; ++j) {
                    bIndex.put((short)0);
                }
            }
            bPos.rewind();
            bNormal.rewind();
            bTexCoord.rewind();
            bTexCoord2.rewind();
            bIndex.rewind();
            this.vbPos.updateData((Buffer)bPos);
            this.vbNormal.updateData((Buffer)bNormal);
            this.vbTexCoord.updateData((Buffer)bTexCoord);
            this.vbTexCoord2.updateData((Buffer)bTexCoord2);
            this.vbIndex.updateData((Buffer)bIndex);
            this.shadowGeom.updateGeometricState();
            renderManager.renderGeometry(this.shadowGeom);
        }
        this.casters.clear();
    }

    private class CasterComparator
    implements GeometryComparator {
        private Camera cam;
        private final Vector3f tempVec = new Vector3f();
        private final Vector3f tempVec2 = new Vector3f();

        private CasterComparator() {
        }

        public void setCamera(Camera cam) {
            this.cam = cam;
        }

        public float distanceToCam(Geometry spat) {
            if (spat == null) {
                return Float.NEGATIVE_INFINITY;
            }
            if (spat.queueDistance != Float.NEGATIVE_INFINITY) {
                return spat.queueDistance;
            }
            Vector3f camPosition = this.cam.getLocation();
            Vector3f viewVector = this.cam.getDirection(this.tempVec2);
            Vector3f spatPosition = spat.getWorldBound() != null ? spat.getWorldBound().getCenter() : spat.getWorldTranslation();
            spatPosition.subtract(camPosition, this.tempVec);
            spat.queueDistance = this.tempVec.dot(viewVector);
            return spat.queueDistance;
        }

        public int compare(Geometry o1, Geometry o2) {
            float d2;
            float d1 = this.distanceToCam(o1);
            if (d1 == (d2 = this.distanceToCam(o2))) {
                return 0;
            }
            if (d1 < d2) {
                return -1;
            }
            return 1;
        }
    }
}

