/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys.simple;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.BodyMass;

public class SimpleShape
extends AbstractShape {
    private Type type;

    public SimpleShape(Type type, double boundsRadius, BodyMass mass) {
        super(new Vec3d(), boundsRadius, mass);
        this.type = type;
    }

    public static SimpleShape createCube(double radius) {
        return new SimpleShape(Type.Cube, radius, BodyMass.createSimple(0.0, null, radius));
    }

    public static SimpleShape createSphere(double radius, double mass) {
        return new SimpleShape(Type.Sphere, radius, BodyMass.createSolidSphere(mass, radius, null));
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("type", (Object)this.type).add("boundsCenter", (Object)this.getBoundsCenter()).add("boundsRadius", this.getBoundsRadius()).add("bodyMass", (Object)this.getMass()).toString();
    }

    public static enum Type {
        Cube,
        Sphere;

    }
}

