/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.time;

import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.Tweens;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mythruna.sim.time.TimeInterval;
import mythruna.sim.time.TweenFactory;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TweenSchedule<T>
implements Consumer<WorldTime> {
    static Logger log = LoggerFactory.getLogger(TweenSchedule.class);
    private TimeInterval interval;
    private TweenFactory<T> tweenFactory;
    private List<Event> eventList = new ArrayList<Event>();
    private Tween masterTween;

    public TweenSchedule() {
    }

    public TweenSchedule(TimeInterval interval, TweenFactory<T> tweenFactory) {
        this.interval = interval;
        this.tweenFactory = tweenFactory;
    }

    public void setInterval(TimeInterval interval) {
        this.interval = interval;
        this.masterTween = null;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    public void setTweenFactory(TweenFactory<T> tweenFactory) {
        this.tweenFactory = tweenFactory;
        this.masterTween = null;
    }

    public TweenFactory<T> getTweenFactory() {
        return this.tweenFactory;
    }

    @Override
    public void accept(WorldTime time) {
        double gameSecs = time.getGameTime();
        double intervalSecs = gameSecs % (double)this.interval.getTotalSeconds();
        this.getMasterTween().interpolate(intervalSecs);
    }

    public TweenSchedule<T> at(String time, T value) {
        return this.at(TimeInterval.parseInterval(time), value);
    }

    public TweenSchedule<T> at(TimeInterval time, T value) {
        this.eventList.add(new Event(time, value));
        this.masterTween = null;
        return this;
    }

    protected Tween getMasterTween() {
        if (this.masterTween != null) {
            return this.masterTween;
        }
        int count = this.eventList.size();
        if (count == 0) {
            throw new RuntimeException("No events scheduled.");
        }
        Event start = this.eventList.get(0);
        if (start.time.getTotalSeconds() > 0L) {
            throw new RuntimeException("No 0 starting event.");
        }
        ArrayList<Event> loop = new ArrayList<Event>(this.eventList);
        loop.add(new Event(this.interval, start.value));
        Tween[] tweens = new Tween[count];
        if (log.isTraceEnabled()) {
            log.trace("count:" + count);
        }
        for (int i = 0; i < count; ++i) {
            Event last = (Event)loop.get(i);
            Event current = (Event)loop.get(i + 1);
            long length = current.time.getTotalSeconds() - last.time.getTotalSeconds();
            if (log.isTraceEnabled()) {
                log.trace("[" + i + "] length:" + length + "  last:" + last.value + "  current:" + current.value);
            }
            tweens[i] = this.tweenFactory.createTween(length, last.value, current.value);
            if (!log.isTraceEnabled()) continue;
            log.trace("    tween:" + tweens[i]);
        }
        this.masterTween = Tweens.sequence((Tween[])tweens);
        return this.masterTween;
    }

    private class Event {
        private TimeInterval time;
        private T value;

        public Event(TimeInterval time, T value) {
            this.time = time;
            this.value = value;
        }
    }
}

