/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.trigger;

import com.simsilica.action.ActionEnvironment;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.es.TriggerActive;
import mythruna.sim.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerActionSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(TriggerActionSystem.class);
    private ObservableEntityData ed;
    private EntityObserver entityObserver = new EntityObserver();
    private Map<EntityId, ActionEnvironment<Activator, EntityId>> playerEnvs;
    private ConcurrentLinkedQueue<EntityChange> pending = new ConcurrentLinkedQueue();
    private Map<EntityId, TriggerActive> lastComponents = new HashMap<EntityId, TriggerActive>();

    public TriggerActionSystem(Map<EntityId, ActionEnvironment<Activator, EntityId>> playerEnvs) {
        this.playerEnvs = playerEnvs;
    }

    protected void initialize() {
        this.ed = (ObservableEntityData)this.getSystem(EntityData.class, true);
        this.ed.addEntityComponentListener((EntityComponentListener)this.entityObserver);
    }

    protected void terminate() {
        this.ed.removeEntityComponentListener((EntityComponentListener)this.entityObserver);
    }

    public void start() {
    }

    public void update(SimTime time) {
        while (!this.pending.isEmpty()) {
            EntityChange change = this.pending.poll();
            this.processChange(change);
        }
    }

    public void stop() {
    }

    protected void runAction(EntityId activator, String action, EntityId trigger) {
        ActionEnvironment<Activator, EntityId> env = this.playerEnvs.get(activator);
        if (env == null) {
            log.error("No action environment for:" + activator);
            return;
        }
        log.info("TRIGGER: " + activator + " " + action + " " + trigger);
        env.runAction((Object)activator, action, new Object[]{trigger});
    }

    protected void processChange(EntityChange change) {
        log.info("change:" + change);
        if (change.getComponent() == null) {
            TriggerActive last = this.lastComponents.get(change.getEntityId());
            switch (last.getType()) {
                case Entered: {
                    log.warn("TriggerActive entity:" + change.getEntityId() + " was removed with no exit events, last event:" + last);
                    this.runAction(last.getActivator(), "onExitedTrigger", last.getTrigger());
                    this.runAction(last.getActivator(), "onLeavingTrigger", last.getTrigger());
                    break;
                }
                case Exited: {
                    break;
                }
                default: {
                    this.runAction(last.getActivator(), "onLeavingTrigger", last.getTrigger());
                    break;
                }
            }
        } else {
            TriggerActive active = (TriggerActive)change.getComponent();
            this.lastComponents.put(change.getEntityId(), active);
            switch (active.getType()) {
                case Approaching: {
                    this.runAction(active.getActivator(), "onApproachingTrigger", active.getTrigger());
                    break;
                }
                case Entered: {
                    this.runAction(active.getActivator(), "onEnteredTrigger", active.getTrigger());
                    break;
                }
                case Exited: {
                    this.runAction(active.getActivator(), "onExitedTrigger", active.getTrigger());
                    break;
                }
                default: {
                    log.warn("Unknown trigger active type:" + (Object)((Object)active.getType()));
                }
            }
        }
    }

    private class EntityObserver
    implements EntityComponentListener {
        private EntityObserver() {
        }

        public void componentChange(EntityChange change) {
            if (TriggerActive.class == change.getComponentType()) {
                TriggerActionSystem.this.pending.add(change);
            }
        }
    }
}

