/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.google.common.base.Function;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileColumnGenerator
implements Function<ColumnId, ColumnData> {
    static Logger log = LoggerFactory.getLogger(TileColumnGenerator.class);
    private WorldFractal fractal;
    private TileManager tileManager;
    private int sandType;
    private int dirtType;
    private int grassType;
    private int stoneType;
    private int snowType;
    private int badType;
    private int waterType;
    private int seaLevel = 128;
    private int treeLine = 500;

    public TileColumnGenerator(WorldFractal fractal, TileManager tileManager) {
        this.fractal = fractal;
        this.tileManager = tileManager;
        this.badType = BlockTypeIndex.getBadTypeIndex();
        this.sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1);
        this.dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1);
        this.grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1);
        this.stoneType = BlockTypeIndex.findType((BlockName)new BlockName("stone", "cube"), (int)1);
        this.snowType = BlockTypeIndex.findType((BlockName)new BlockName("snow", "cube"), (int)1);
        this.waterType = FluidTypeIndex.findType((FluidName)new FluidName("water"), (int)1);
    }

    public ColumnData apply(ColumnId columnId) {
        TileId tileId = columnId.getTileId();
        long start = System.nanoTime();
        Tile tile = this.tileManager.getTile(tileId, Resolution.High);
        long end = System.nanoTime();
        long tileGen = end - start;
        start = System.nanoTime();
        ColumnData result = this.generateColumn(tile, columnId);
        end = System.nanoTime();
        long colGen = end - start;
        boolean changed = false;
        start = System.nanoTime();
        MorphologyLayer morphs = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morphs != null && morphs.apply(result, tile)) {
            changed = true;
        }
        end = System.nanoTime();
        long morphTime = end - start;
        start = System.nanoTime();
        TreeLayer trees = (TreeLayer)tile.get(TreeLayer.class);
        if (trees != null && trees.apply(result, tile)) {
            changed = true;
        }
        end = System.nanoTime();
        long treeTime = end - start;
        log.info(String.format("Times tilegen: %.02f ms  colgen: %.02f ms  morph: %.02f  trees: %.02f", (double)tileGen / 1000000.0, (double)colGen / 1000000.0, (double)morphTime / 1000000.0, (double)treeTime / 1000000.0));
        return result;
    }

    protected ColumnData generateColumn(Tile tile, ColumnId columnId) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluidLevels = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = 32;
        int leafCount = 672 / size;
        ColumnData col = new ColumnData(columnId, leafCount);
        Vec3i local = columnId.getTileLocal(null);
        for (int i = 0; i < size; ++i) {
            block5: for (int k = 0; k < size; ++k) {
                int topBlock;
                int xp = local.x + i;
                int zp = local.z + k;
                int elevation = terrain.getElevation(xp, zp);
                byte type = terrain.getType(xp, zp);
                int baseType = TerrainTypes.getBaseType(type);
                int foliage = TerrainTypes.getFoliageLevel(type);
                boolean frozen = TerrainTypes.isFrozen(type);
                short fluidLevel = fluidLevels.getElevation(xp, zp);
                byte fluidType = fluidLevels.getType(xp, zp);
                int fillBlock = this.stoneType;
                boolean grassy = foliage > 0 && elevation >= fluidLevel;
                switch (baseType) {
                    case 0: {
                        topBlock = this.sandType;
                        break;
                    }
                    case 1: {
                        topBlock = this.dirtType;
                        break;
                    }
                    default: {
                        topBlock = this.stoneType;
                    }
                }
                int y = 0;
                for (int layer = 0; layer < leafCount; ++layer) {
                    LeafData leaf = col.getLeafData(y);
                    FluidData fluid = col.getFluidData(y);
                    int j = 0;
                    while (j < 32) {
                        if (y == 0) {
                            leaf.setCell(i, j, k, this.dirtType);
                        } else if (y >= elevation) {
                            if (y < fluidLevel - 1) {
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)8));
                            } else {
                                if (y != fluidLevel - 1) break;
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)6));
                            }
                        } else if (y == elevation - 1) {
                            if (frozen) {
                                leaf.setCell(i, j, k, this.snowType);
                            } else if (grassy) {
                                leaf.setCell(i, j, k, this.grassType);
                            } else {
                                leaf.setCell(i, j, k, topBlock);
                            }
                        } else if (y == elevation - 2) {
                            if (frozen) {
                                if (grassy) {
                                    leaf.setCell(i, j, k, this.grassType);
                                } else {
                                    leaf.setCell(i, j, k, topBlock);
                                }
                            } else {
                                leaf.setCell(i, j, k, fillBlock);
                            }
                        } else if (y == elevation - 3) {
                            if (frozen && grassy) {
                                leaf.setCell(i, j, k, this.dirtType);
                            } else {
                                leaf.setCell(i, j, k, fillBlock);
                            }
                        } else {
                            leaf.setCell(i, j, k, fillBlock);
                        }
                        ++j;
                        ++y;
                    }
                    if (y > elevation && y > fluidLevel) continue block5;
                }
            }
        }
        return col;
    }
}

