/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTime
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(WorldTime.class);
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final double REAL_SECS_PER_GAME_SECOND = 0.016666666666666666;
    public static final long GAME_SECONDS_PER_REAL_SEC = 60L;
    private static final double TO_GAME_SECONDS = 6.000000000000001E-8;
    private static final double FROM_GAME_SECONDS = 1.6666666666666666E7;
    private static final double TO_MINUTES = 0.016666666666666666;
    private static final double TO_HOURS = 2.777777777777778E-4;
    private static final double TO_DAYS = 1.1574074074074073E-5;
    private static long DAYS_TO_SECONDS = 86400L;
    public static final int MONTHS_IN_A_YEAR = 4;
    public static final int DAYS_IN_A_WEEK = 7;
    public static final int DAYS_IN_A_MONTH = 28;
    public static final int DAYS_IN_A_YEAR = 112;
    private static final Pattern TIME_PATTERN = Pattern.compile("((\\d{1,})/)?((\\d{1})/)?((\\d{1,2})\\s+)?(\\d{1,2}):(\\d{2})");
    private long baseOffset;
    private long realTimeNanos;

    public WorldTime() {
    }

    public WorldTime(int year, int month, int day) {
        this(year, month, day, 0, 0);
    }

    public WorldTime(int year, int month, int day, int hours, int minutes) {
        long nanos;
        long days = year * 112;
        days += (long)(month * 28);
        long gameSeconds = (days += (long)day) * DAYS_TO_SECONDS;
        gameSeconds += (long)(hours * 60 * 60);
        this.realTimeNanos = nanos = (gameSeconds += (long)(minutes * 60)) * 16666666L;
    }

    public WorldTime(double gameTime) {
        this.realTimeNanos = (long)(gameTime * 1.6666666666666666E7);
        this.baseOffset = 0L;
    }

    public WorldTime clone() {
        try {
            return (WorldTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("What are you going to do about it?", e);
        }
    }

    public static WorldTime parseWorldTime(String s) {
        Matcher m = TIME_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid world time format:" + s);
        }
        int year = m.group(2) != null ? Integer.parseInt(m.group(2)) : 0;
        int month = m.group(4) != null ? Integer.parseInt(m.group(4)) - 1 : 0;
        int days = m.group(6) != null ? Integer.parseInt(m.group(6)) - 1 : 0;
        int hours = m.group(7) != null ? Integer.parseInt(m.group(7)) : 0;
        int minutes = m.group(8) != null ? Integer.parseInt(m.group(8)) : 0;
        return new WorldTime(year, month, days, hours, minutes);
    }

    public void setRealTimeNanos(long realTimeNanos) {
        this.realTimeNanos = realTimeNanos;
    }

    public long getRealTimeNanos() {
        return this.realTimeNanos;
    }

    public void setBaseOffset(long baseOffset) {
        this.baseOffset = baseOffset;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getYear() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days / 112;
    }

    public void setYear(int year) {
        int current = this.getYear();
        long delta = (year - current) * 112 * 24 * 60 * 60;
        double offset = (double)delta * 0.016666666666666666 * 1.0E9;
        this.baseOffset += (long)offset;
    }

    public int getMonth() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days % 112 / 28;
    }

    public void setMonth(int month) {
        int current = this.getMonth();
        long delta = (month - current) * 28 * 24 * 60 * 60;
        double offset = (double)delta * 0.016666666666666666 * 1.0E9;
        this.baseOffset += (long)offset;
    }

    public int getDay() {
        double seconds = this.getGameTime();
        int days = (int)(seconds * 1.1574074074074073E-5);
        return days % 28;
    }

    public void setDay(int day) {
        int current = this.getDay();
        long delta = (day - current) * 24 * 60 * 60;
        double offset = (double)delta * 0.016666666666666666 * 1.0E9;
        this.baseOffset += (long)offset;
    }

    public int getHour() {
        double seconds = this.getGameTime();
        return (int)(seconds * 2.777777777777778E-4) % 24;
    }

    public void setHour(int hour) {
        int current = this.getHour();
        long delta = (hour - current) * 60 * 60;
        double offset = (double)delta * 0.016666666666666666 * 1.0E9;
        this.baseOffset += (long)offset;
    }

    public int getMinute() {
        double seconds = this.getGameTime();
        return (int)(seconds * 0.016666666666666666) % 60;
    }

    public void setMinute(int minute) {
        int current = this.getMinute();
        long delta = (minute - current) * 60;
        double offset = (double)delta * 0.016666666666666666 * 1.0E9;
        this.baseOffset += (long)offset;
    }

    public double getGameTime() {
        return (double)(this.baseOffset + this.realTimeNanos) * 6.000000000000001E-8;
    }

    public String asFullString() {
        double seconds = this.getGameTime();
        seconds = (this.baseOffset + this.realTimeNanos) / 16666666L;
        long gameMinutes = (long)(seconds * 0.016666666666666666);
        long gameMinutes2 = (this.baseOffset + this.realTimeNanos) / 1000000000L / 3600L;
        int minute = (int)(seconds * 0.016666666666666666) % 60;
        int hour = (int)(seconds * 2.777777777777778E-4) % 24;
        int days = (int)(seconds * 1.1574074074074073E-5);
        int day = 1 + days % 28;
        int month = 1 + days % 112 / 28;
        int year = days / 112;
        return String.format("%03d/%01d/%02d %02d:%02d", year, month, day, hour, minute);
    }
}

