/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import mythruna.GameConstants;
import mythruna.es.MapMarker;
import mythruna.world.WorldFractal;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.SedectileData;
import mythruna.world.tile.Workspace;
import mythruna.world.tile.WorkspaceFunction;
import mythruna.world.town.InsertInfo;
import mythruna.world.town.PointOfInterest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPoiGenerator
implements WorkspaceFunction {
    static Logger log = LoggerFactory.getLogger(TestPoiGenerator.class);
    private long worldSeed;
    private WorldFractal worldFractal;
    private EntityId worldEntity;
    private EntityData ed;
    private final PointOfInterest spawnTower;

    public TestPoiGenerator(long worldSeed, EntityId spawnEntity, WorldFractal worldFractal, EntityId worldEntity, EntityData ed) {
        this.worldSeed = worldSeed;
        this.worldFractal = worldFractal;
        this.worldEntity = worldEntity;
        this.ed = ed;
        SpawnPosition pos = (SpawnPosition)ed.getComponent(spawnEntity, SpawnPosition.class);
        if (pos == null) {
            throw new IllegalArgumentException("No spawn position for spawn entity:" + spawnEntity);
        }
        this.spawnTower = this.createSpawnTower(spawnEntity.getId(), pos);
    }

    public static final double findAverageElevation(Vec3i min, Vec3i max, WorldFractal fractal) {
        double total = 0.0;
        int samples = 0;
        for (int x = min.x; x < max.x; ++x) {
            for (int z = min.z; z < max.z; ++z) {
                int y = (int)fractal.getElevation(x, z);
                total += (double)y;
                ++samples;
                min.y = Math.min(min.y, y);
                max.y = Math.max(max.y, y);
            }
        }
        return total / (double)samples;
    }

    protected PointOfInterest createSpawnTower(long id, SpawnPosition pos) {
        Vec3i min = pos.getLocation().floor().subtractLocal(4, 0, 4);
        Vec3i max = min.add(9, 0, 9);
        double y = TestPoiGenerator.findAverageElevation(min, max, this.worldFractal);
        min.y = (int)Math.round(y);
        InsertInfo child = new InsertInfo("spawn", min, max.subtract(min), 0);
        return new PointOfInterest(id, "spawn", child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Workspace workspace) {
        Vec3i workspaceOrigin = workspace.getOrigin(null);
        log.info("TestPoiGenerator resolving POIs for workspace:" + workspace + " origin:" + workspaceOrigin);
        String name = String.format("POI generation: %d, %d", workspaceOrigin.x, workspaceOrigin.z);
        ProgressTracker progress = ProgressTrackers.openTracker((String)name);
        try {
            int radius = 1;
            int progressMax = (radius * 2 + 1) * (radius * 2 + 1);
            progress.setMax((double)progressMax);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    try {
                        Sedectile sedectile = workspace.getSedectile(x, z);
                        int state = sedectile.getGenerationState(TestPoiGenerator.class, 0);
                        if (state > 0) {
                            log.info("Already calculated POIs for center of:" + workspace);
                            continue;
                        }
                        this.generatePois(workspaceOrigin, workspace, x, z, progress);
                        sedectile.setGenerationState(TestPoiGenerator.class, 1);
                        continue;
                    }
                    finally {
                        progress.increment();
                    }
                }
            }
        }
        finally {
            progress.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity findEntity(String type, Vec3i pos) {
        TileId tileId = TileId.fromWorld((Vec3i)pos);
        ComponentFilter tileFilter = Filters.fieldEquals(MapMarker.class, (String)"tileId", (Object)tileId.getId());
        int typeId = this.ed.getStrings().getStringId(type, true);
        ComponentFilter typeFilter = Filters.fieldEquals(MapMarker.class, (String)"typeId", (Object)typeId);
        ComponentFilter filter = Filters.and(MapMarker.class, (ComponentFilter[])new ComponentFilter[]{tileFilter, typeFilter});
        EntitySet entities = this.ed.getEntities(filter, new Class[]{MapMarker.class, SpawnPosition.class, Name.class});
        entities.applyChanges();
        try {
            for (Entity e : entities) {
                SpawnPosition spawn = (SpawnPosition)e.get(SpawnPosition.class);
                if (!spawn.getLocation().floor().equals((Object)pos)) continue;
                Entity entity = e;
                return entity;
            }
        }
        finally {
            entities.release();
        }
        return null;
    }

    protected void generatePois(Vec3i workspaceOrigin, Workspace workspace, int xSedectile, int zSedectile, ProgressTracker tracker) {
        int size = 128;
        int spread = 128;
        int radius = 1;
        int workspaceSize = (radius * 2 + 1) * size;
        int[][] elevation = new int[workspaceSize][workspaceSize];
        int[][] metaData = new int[workspaceSize][workspaceSize];
        for (int xs = -radius; xs <= radius; ++xs) {
            for (int zs = -radius; zs <= radius; ++zs) {
                Sedectile sedectile = workspace.getSedectile(xSedectile + xs, zSedectile + zs);
                SedectileId id = sedectile.getSedectileId();
                SedectileData data = sedectile.getSedectileData();
                int xBase = (radius + xs) * 128;
                int zBase = (radius + zs) * 128;
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        elevation[xBase + x][zBase + z] = data.getElevation(x, z);
                        metaData[xBase + x][zBase + z] = data.getMetaData(x, z);
                    }
                }
            }
        }
        int shallowSea = 124;
        int flatThreshold = 2;
        int stoneThreshold = 40;
        int cliffThreshold = 80;
        int seaThreshold = 256;
        int farmThreshold = 3;
        int kernelRadius = 2;
        int kernelSize = kernelRadius * 2 + 1;
        kernelSize *= kernelSize;
        double[][] roughness = new double[size][size];
        double[][] averageElevation = new double[size][size];
        int[][] minElevation = new int[size][size];
        int[][] maxElevation = new int[size][size];
        double[][] temperature = new double[size][size];
        double[][] precipitation = new double[size][size];
        double[][] climate = new double[size][size];
        Sedectile center = workspace.getSedectile(xSedectile, zSedectile);
        SedectileData centerData = center.getSedectileData();
        Vec3i origin = center.getSedectileId().getWorld(null);
        int base = radius * size;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                double r = 0.0;
                double e = 0.0;
                double t = 0.0;
                double p = 0.0;
                double c = 0.0;
                int min = Integer.MAX_VALUE;
                int max = -1;
                int centerElevation = elevation[base + x][base + z];
                int samples = 0;
                for (int i = -kernelRadius; i <= kernelRadius; ++i) {
                    for (int j = -kernelRadius; j <= kernelRadius; ++j) {
                        int ke = elevation[base + x + i][base + z + j];
                        min = Math.min(min, ke);
                        max = Math.max(max, ke);
                        e += (double)ke;
                        r += (double)Math.abs(centerElevation - ke);
                        int km = metaData[base + x + i][base + z + j];
                        double tLocal = centerData.getTemperature(km);
                        t += tLocal;
                        double precip = centerData.getPrecipitation(km);
                        p += precip;
                        double cLocal = this.worldFractal.getClimate(origin.x + x + i, ke, origin.z + z + j, tLocal, precip);
                        c += cLocal;
                        ++samples;
                    }
                }
                roughness[x][z] = r / (double)kernelSize;
                averageElevation[x][z] = e / (double)kernelSize;
                temperature[x][z] = t / (double)kernelSize;
                precipitation[x][z] = p / (double)kernelSize;
                climate[x][z] = c / (double)kernelSize;
                minElevation[x][z] = min;
                maxElevation[x][z] = max;
            }
        }
        FeatureId<TerrainInfo> featureId = FeatureId.create(TerrainInfo.class, center.getSedectileId().getId());
        TerrainInfo info = new TerrainInfo(featureId, roughness, averageElevation, minElevation, maxElevation, temperature, precipitation, climate);
        workspace.addFeature(info);
        if (this.spawnTower.intersects(center.getSedectileId())) {
            log.info("Adding spawn tower at:" + this.spawnTower.getLocation());
            workspace.addFeature(this.spawnTower);
        }
        Candidate[][] candidates = this.createCandidates(origin, centerData, info);
        info.candidates = candidates;
        Random rand = new Random(this.worldSeed + center.getSedectileId().getId());
        ArrayList<Vec3i> pending = new ArrayList<Vec3i>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Candidate candidate = candidates[i][j];
                if (candidate == null) continue;
                pending.add(new Vec3i(i, 0, j));
            }
        }
        ArrayList<PoiType> pois = new ArrayList<PoiType>();
        log.info("Pending:" + pending.size());
        SedectileData data = centerData;
        int counter = 50;
        double settlementWeight = 1.0;
        double farmWeight = 0.5;
        double cliffWeight = 0.5;
        double ruinsWeight = 0.5;
        block10: while (!pending.isEmpty()) {
            Vec3i cell = (Vec3i)pending.remove(rand.nextInt(pending.size()));
            Candidate candidate = candidates[cell.x][cell.z];
            if (candidate == null) continue;
            while (candidate != null) {
                int poiSize;
                double roll;
                double townFactor = candidate.town * settlementWeight;
                double farmFactor = candidate.farm * farmWeight;
                double cliffFactor = candidate.cliff * cliffWeight;
                double max = Math.max(townFactor, farmFactor);
                if ((max = Math.max(max, cliffFactor)) == 0.0) continue block10;
                PoiType poi = null;
                if (max == townFactor) {
                    roll = rand.nextDouble();
                    if (roll < townFactor) {
                        poiSize = rand.nextInt(3) + 1;
                        poi = new SettlementType(cell, poiSize);
                    }
                    candidate.town = 0.0;
                } else if (max == farmFactor) {
                    roll = rand.nextDouble();
                    if (roll < farmFactor) {
                        poiSize = rand.nextInt(3) + 1;
                        poi = new FarmType(cell, poiSize);
                    }
                    candidate.farm = 0.0;
                } else if (max == cliffFactor) {
                    roll = rand.nextDouble();
                    if (roll < cliffFactor) {
                        poiSize = rand.nextInt(3) + 1;
                        poi = new CliffRuinsType(cell, poiSize);
                    }
                    candidate.cliff = 0.0;
                } else {
                    throw new IllegalStateException("Factor mismatch for candidate:" + candidate);
                }
                if (poi == null) continue;
                poi.apply(candidates);
                pois.add(poi);
                candidates[cell.x][cell.z] = null;
                continue block10;
            }
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Candidate candidate = candidates[i][j];
                if (candidate == null || candidate.elevation < 128.0) continue;
                double dampen = 1.0 - (candidate.elevation - 128.0) / 512.0;
                candidate.isolated *= dampen;
                if (candidate == null || !(candidate.isolated * ruinsWeight > 1.0E-4)) continue;
                pending.add(new Vec3i(i, 0, j));
            }
        }
        log.info("Isolated candidates:" + pending.size());
        while (!pending.isEmpty()) {
            double roll;
            Vec3i cell = (Vec3i)pending.remove(rand.nextInt(pending.size()));
            Candidate candidate = candidates[cell.x][cell.z];
            if (candidate == null || !((roll = rand.nextDouble()) < candidate.isolated * ruinsWeight)) continue;
            int poiSize = rand.nextInt(3) + 1;
            IsolatedRuinsType poi = new IsolatedRuinsType(cell, poiSize);
            ((PoiType)poi).apply(candidates);
            pois.add(poi);
            candidates[cell.x][cell.z] = null;
        }
        for (PoiType poiType : pois) {
            Vec3i cell = poiType.loc;
            short y = data.getElevation(cell.x, cell.z);
            Vec3i v = origin.add(cell.x * spread, (int)y, cell.z * spread);
            ColumnId colId = ColumnId.fromWorld((Vec3i)v);
            int worldRadius = poiType.worldRadius;
            String type = poiType.name;
            Entity entity = this.findEntity(type, v);
            EntityId markerId = null;
            if (entity == null) {
                markerId = this.ed.createEntity();
                this.ed.setComponents(markerId, new EntityComponent[]{new Name(type + ":" + markerId.getId()), new SpawnPosition(GameConstants.PHYSICS_GRID, v.toVec3d()), MapMarker.create(this.worldEntity, type, worldRadius, v.toVec3d(), this.ed)});
            } else {
                markerId = entity.getId();
            }
            InsertInfo[] children = poiType.createChildren(v, this.worldFractal, rand);
            log.info("Adding test POI:" + type + " at:" + v + "  num children:" + children.length);
            PointOfInterest poi = new PointOfInterest(markerId.getId(), type, children);
            workspace.addFeature(poi);
        }
    }

    protected Candidate[][] createCandidates(Vec3i origin, SedectileData data, TerrainInfo info) {
        int size = data.getSize();
        int spread = data.getSpread();
        Candidate[][] candidates = new Candidate[size][size];
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                short y = data.getElevation(x, z);
                if (y < 128) continue;
                Vec3d v = origin.add(x * spread, y - 128, z * spread).toVec3d();
                double rough = info.roughness[x][z];
                double ae = info.averageElevation[x][z];
                int min = info.minElevation[x][z];
                int max = info.maxElevation[x][z];
                double temperature = info.temperature[x][z];
                double precipitation = info.precipitation[x][z];
                double climate = info.climate[x][z];
                int wetness = (int)Math.round(precipitation * 3.0);
                int foliage = (int)Math.round(climate * 3.0);
                Candidate candidate = new Candidate();
                candidate.elevation = y;
                candidates[x][z] = candidate;
                double settlementFactor = Math.abs(climate - 0.5) * 2.0;
                settlementFactor = 1.0 - settlementFactor * settlementFactor * (3.0 - 2.0 * settlementFactor);
                if (min < 128 && rough < 20.0) {
                    candidate.town += settlementFactor * 0.5;
                }
                double flatThreshold = 5.0;
                double flatThreshold2 = 15.0;
                if (rough < flatThreshold) {
                    candidate.farm = settlementFactor;
                }
                if (rough < flatThreshold2) {
                    candidate.town += settlementFactor * 0.5;
                }
                double yThreshold = (double)min + (double)(max - min) * 0.5;
                double roughThreshold = 40.0;
                if (rough > roughThreshold && (double)y > yThreshold) {
                    double cliffness = rough - roughThreshold + (double)y - yThreshold;
                    candidate.cliff = Math.min(1.0, cliffness / 200.0);
                }
                candidate.isolated = 1.0;
            }
        }
        return candidates;
    }

    public static class TerrainInfo
    implements Feature<TerrainInfo>,
    Serializable {
        FeatureId<TerrainInfo> featureId;
        double[][] roughness;
        double[][] averageElevation;
        int[][] minElevation;
        int[][] maxElevation;
        double[][] temperature;
        double[][] precipitation;
        double[][] climate;
        Candidate[][] candidates;

        public TerrainInfo(FeatureId<TerrainInfo> featureId, double[][] roughness, double[][] averageElevation, int[][] minElevation, int[][] maxElevation, double[][] temperature, double[][] precipitation, double[][] climate) {
            this.featureId = featureId;
            this.roughness = roughness;
            this.averageElevation = averageElevation;
            this.minElevation = minElevation;
            this.maxElevation = maxElevation;
            this.temperature = temperature;
            this.precipitation = precipitation;
            this.climate = climate;
        }

        @Override
        public FeatureId<TerrainInfo> getFeatureId() {
            return this.featureId;
        }

        @Override
        public Collection<TileId> getAffectedTiles() {
            return Collections.emptySet();
        }
    }

    public static class Candidate
    implements Serializable {
        double town;
        double farm;
        double cliff;
        double isolated;
        double elevation;
    }

    private static class SettlementType
    extends PoiType {
        private static final String[][] always = new String[][]{new String[0], {"well"}, {"well"}};
        private static final String[][] types = new String[][]{{"building1", "building2", "building3", "garden", "garden", "garden", "garden", "well"}, {"building1", "building2", "building3", "gallows", "graves", "tower1", "temple2", "garden"}, {"building1", "building2", "building3", "gallows", "graves", "tower1", "airport1", "temple1", "garden"}};
        private static final String[][] maxTypes = new String[][]{{"building1", "building2", "building3", "garden", "garden", "well"}, {"building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "gallows", "graves", "graves", "tower1", "temple2", "garden", "garden", "garden", "garden", "garden", "garden", "garden", "garden"}, {"building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "building1", "building2", "building3", "gallows", "graves", "graves", "graves", "graves", "tower1", "tower1", "tower1", "tower1", "garden", "garden", "well", "well", "garden", "garden", "garden", "garden", "airport1", "temple1", "temple1"}};

        public SettlementType(Vec3i loc, int size) {
            this.loc = loc;
            this.size = size;
            if (size > 2) {
                this.name = "Town";
                this.worldRadius = 128;
            } else if (size > 1) {
                this.name = "Village";
                this.worldRadius = 64;
            } else {
                this.name = "Settlement";
                this.worldRadius = 32;
            }
        }

        @Override
        public InsertInfo[] createChildren(Vec3i center, WorldFractal fractal, Random rand) {
            int candidateCount;
            int townDiameter;
            int townSpread = 16;
            int townSpreadOffset = -8;
            switch (this.size) {
                case 3: {
                    townDiameter = 11;
                    break;
                }
                case 2: {
                    townSpread = 20;
                    townSpreadOffset = -10;
                    townDiameter = 9;
                    break;
                }
                default: {
                    townDiameter = 2;
                }
            }
            int townRadiusMin = -(townDiameter / 2);
            int townRadiusMax = townRadiusMin + townDiameter;
            Vec3i townCenter = townDiameter % 2 == 0 ? center.add(townSpread / 2, 0, townSpread / 2) : center;
            ArrayList<Vec3i> candidates = new ArrayList<Vec3i>();
            for (int i = townRadiusMin; i < townRadiusMax; ++i) {
                for (int j = townRadiusMin; j < townRadiusMax; ++j) {
                    Vec3i pos = townCenter.add(i * townSpread, 0, j * townSpread);
                    candidates.add(pos);
                }
            }
            int maxCount = candidateCount = candidates.size();
            int minCount = 1;
            if (this.size > 2) {
                minCount = maxCount / 4;
                maxCount = maxCount * 3 / 4;
            } else if (this.size > 1) {
                minCount = maxCount / 4;
                maxCount = maxCount * 3 / 4;
            }
            int count = minCount + rand.nextInt(1 + maxCount - minCount);
            if (count > candidateCount) {
                throw new IllegalStateException("Desired count:" + count + " exceeds candidate count:" + candidateCount);
            }
            int typeIndex = Math.min(this.size - 1, types.length - 1);
            ArrayList<String> required = new ArrayList<String>(Arrays.asList(always[typeIndex]));
            String[] choose = types[typeIndex];
            ArrayList<String> maxUse = new ArrayList<String>(Arrays.asList(maxTypes[typeIndex]));
            ArrayList<InsertInfo> children = new ArrayList<InsertInfo>();
            while (!candidates.isEmpty()) {
                String type;
                int index = candidates.size() == 1 ? 0 : rand.nextInt(candidates.size());
                Vec3i pos = (Vec3i)candidates.remove(index);
                Vec3i min = pos.subtract(4, 0, 4);
                Vec3i max = min.add(9, 0, 9);
                double yAverage = TestPoiGenerator.findAverageElevation(min, max, fractal);
                if (min.y < 128 || max.y - min.y > 4) continue;
                pos.y = (int)Math.round(yAverage);
                if (maxUse.isEmpty()) {
                    maxUse = new ArrayList<String>(Arrays.asList(maxTypes[Math.min(maxTypes.length - 1, this.size)]));
                }
                if (!required.isEmpty()) {
                    type = (String)required.remove(0);
                } else {
                    type = choose[rand.nextInt(choose.length)];
                    if (!maxUse.remove(type)) {
                        type = (String)maxUse.remove(rand.nextInt(maxUse.size()));
                    }
                }
                min.set(pos).addLocal(townSpreadOffset, 0, townSpreadOffset);
                max.set(townSpread, 0, townSpread);
                children.add(new InsertInfo(type, min, max));
                if (children.size() < count) continue;
                break;
            }
            if (children.size() < count) {
                log.info("POI:" + center + " fell short of goal:" + count + " actual:" + children.size());
            }
            return children.toArray(new InsertInfo[0]);
        }

        @Override
        public void apply(Candidate[][] candidates) {
            double minRadius = 64 * this.size;
            double minRadiusSq = minRadius * minRadius;
            double settlementRadius = 2048 * this.size;
            double settlementRadiusSq = settlementRadius * settlementRadius;
            double isolatedRadius = settlementRadius * 0.25;
            double isolatedRadiusSq = isolatedRadius * isolatedRadius;
            double maxRadius = Math.max(settlementRadius, isolatedRadius);
            int max = 128;
            int radius = (int)Math.round(maxRadius / 128.0);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    double scale;
                    int i = this.loc.x + x;
                    int j = this.loc.z + z;
                    if (i < 0 || j < 0 || i >= max || j >= max) continue;
                    double dx = x * 128;
                    double dz = z * 128;
                    double dSq = dx * dx + dz * dz;
                    Candidate candidate = candidates[i][j];
                    if (candidate == null) continue;
                    if (dSq <= minRadiusSq) {
                        scale = dSq / minRadiusSq;
                        candidate.town = 0.0;
                        candidate.farm = 0.0;
                        candidate.cliff = 0.0;
                    } else if (dSq < settlementRadiusSq) {
                        scale = dSq / settlementRadiusSq;
                        candidate.town *= scale;
                        double add = (1.0 - scale) * candidate.farm;
                        candidate.farm = Math.min(1.0, candidate.farm + add);
                    }
                    if (!(dSq < isolatedRadiusSq)) continue;
                    scale = dSq / isolatedRadiusSq;
                    candidate.isolated *= scale;
                }
            }
        }
    }

    private static class FarmType
    extends PoiType {
        public FarmType(Vec3i loc, int size) {
            this.loc = loc;
            this.size = size;
            if (size > 2) {
                this.name = "Large Farm";
                this.worldRadius = 128;
            } else if (size > 1) {
                this.name = "Farm";
                this.worldRadius = 64;
            } else {
                this.name = "Small Farm";
                this.worldRadius = 32;
            }
        }

        @Override
        public InsertInfo[] createChildren(Vec3i center, WorldFractal fractal, Random rand) {
            int candidateRadius = this.size;
            int candidateSpread = 16;
            int candidateSpreadOffset = -8;
            int diameter = candidateRadius * 2 + 1;
            ArrayList<Vec3i> candidates = new ArrayList<Vec3i>();
            for (int i = -candidateRadius; i < candidateRadius; ++i) {
                for (int j = -candidateRadius; j < candidateRadius; ++j) {
                    Vec3i pos = center.add(i * candidateSpread, 0, j * candidateSpread);
                    candidates.add(pos);
                }
            }
            int candidateCount = candidates.size();
            InsertInfo farm = null;
            ArrayList<InsertInfo> children = new ArrayList<InsertInfo>();
            while (!candidates.isEmpty()) {
                int index = candidates.size() == 1 ? 0 : rand.nextInt(candidates.size());
                Vec3i pos = (Vec3i)candidates.remove(index);
                Vec3i min = pos.subtract(4, 0, 4);
                Vec3i max = min.add(9, 0, 9);
                double yAverage = TestPoiGenerator.findAverageElevation(min, max, fractal);
                if (min.y < 128 || max.y - min.y > 4) continue;
                pos.y = (int)Math.round(yAverage);
                if (farm == null) {
                    min.set(pos).addLocal(candidateSpreadOffset, 0, candidateSpreadOffset);
                    max.set(candidateSpread, 0, candidateSpread);
                    farm = new InsertInfo("farm" + this.size, min, max);
                    children.add(farm);
                    continue;
                }
                Vec3i plotSize = new Vec3i(8, 0, 8);
                for (int x = 0; x < 2; ++x) {
                    for (int z = 0; z < 2; ++z) {
                        min = new Vec3i(pos.x - 8 + x * 8, 0, pos.z - 8 + z * 8);
                        max.set(min).addLocal(plotSize);
                        yAverage = TestPoiGenerator.findAverageElevation(min, max, fractal);
                        min.y = (int)Math.round(yAverage);
                        InsertInfo plot = new InsertInfo("corn", min, plotSize, 0);
                        children.add(plot);
                    }
                }
            }
            return children.toArray(new InsertInfo[0]);
        }

        @Override
        public void apply(Candidate[][] candidates) {
            double minRadius = 128 * this.size;
            double minRadiusSq = minRadius * minRadius;
            double farmRadius = 512 * this.size;
            double farmRadiusSq = farmRadius * farmRadius;
            double isolatedRadius = farmRadius * 0.5;
            double isolatedRadiusSq = isolatedRadius * isolatedRadius;
            double maxRadius = Math.max(farmRadius, isolatedRadius);
            int max = 128;
            int radius = (int)Math.round(maxRadius / 128.0);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    double scale;
                    int i = this.loc.x + x;
                    int j = this.loc.z + z;
                    if (i < 0 || j < 0 || i >= max || j >= max) continue;
                    double dx = x * 128;
                    double dz = z * 128;
                    double dSq = dx * dx + dz * dz;
                    Candidate candidate = candidates[i][j];
                    if (candidate == null) continue;
                    if (dSq <= minRadiusSq) {
                        scale = dSq / minRadiusSq;
                        candidate.town = 0.0;
                        candidate.farm = 0.0;
                        candidate.cliff = 0.0;
                    } else if (dSq < farmRadiusSq) {
                        scale = dSq / farmRadiusSq;
                        candidate.farm *= scale;
                        double add = (1.0 - scale) * candidate.town;
                        candidate.town = Math.min(1.0, candidate.town + add);
                    }
                    if (!(dSq < isolatedRadiusSq)) continue;
                    scale = dSq / isolatedRadiusSq;
                    candidate.isolated *= scale;
                }
            }
        }
    }

    private static class CliffRuinsType
    extends PoiType {
        public CliffRuinsType(Vec3i loc, int size) {
            this.loc = loc;
            this.size = size;
            if (size > 2) {
                this.name = "Cliff POI 3";
                this.worldRadius = 128;
            } else if (size > 1) {
                this.name = "Cliff POI 2";
                this.worldRadius = 64;
            } else {
                this.name = "Cliff POI 1";
                this.worldRadius = 32;
            }
            this.worldRadius = 16;
        }

        @Override
        public InsertInfo[] createChildren(Vec3i center, WorldFractal fractal, Random rand) {
            Vec3i min = center.subtractLocal(4, 0, 4);
            Vec3i max = min.add(9, 0, 9);
            double yAverage = TestPoiGenerator.findAverageElevation(min, max, fractal);
            min.y = (int)Math.round(yAverage);
            InsertInfo child = new InsertInfo("cliff" + this.size, min, max.subtract(min));
            return new InsertInfo[]{child};
        }

        @Override
        public void apply(Candidate[][] candidates) {
            double minRadius = 64 * this.size;
            double minRadiusSq = minRadius * minRadius;
            double cliffRadius = 512 * this.size;
            double cliffRadiusSq = cliffRadius * cliffRadius;
            double isolatedRadius = cliffRadius * 0.5;
            double isolatedRadiusSq = isolatedRadius * isolatedRadius;
            double maxRadius = Math.max(cliffRadius, isolatedRadius);
            int max = 128;
            int radius = (int)Math.round(cliffRadius / 128.0);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    double scale;
                    int i = this.loc.x + x;
                    int j = this.loc.z + z;
                    if (i < 0 || j < 0 || i >= max || j >= max) continue;
                    double dx = x * 128;
                    double dz = z * 128;
                    double dSq = dx * dx + dz * dz;
                    Candidate candidate = candidates[i][j];
                    if (candidate == null) continue;
                    if (dSq <= minRadiusSq) {
                        scale = dSq / minRadiusSq;
                        candidate.town = 0.0;
                        candidate.farm = 0.0;
                        candidate.cliff = 0.0;
                    } else if (dSq < cliffRadiusSq) {
                        scale = dSq / cliffRadiusSq;
                        candidate.cliff *= scale;
                    }
                    if (!(dSq < isolatedRadiusSq)) continue;
                    scale = dSq / isolatedRadiusSq;
                    candidate.isolated *= scale;
                }
            }
        }
    }

    private static abstract class PoiType {
        protected String name;
        protected Vec3i loc;
        protected int size;
        protected int worldRadius;

        private PoiType() {
        }

        public abstract void apply(Candidate[][] var1);

        public abstract InsertInfo[] createChildren(Vec3i var1, WorldFractal var2, Random var3);
    }

    private static class IsolatedRuinsType
    extends PoiType {
        public IsolatedRuinsType(Vec3i loc, int size) {
            this.loc = loc;
            this.size = size;
            if (size > 2) {
                this.name = "Isolated POI 3";
                this.worldRadius = 128;
            } else if (size > 1) {
                this.name = "Isolated POI 2";
                this.worldRadius = 64;
            } else {
                this.name = "Isolated POI 1";
                this.worldRadius = 32;
            }
            this.worldRadius = 16;
        }

        @Override
        public InsertInfo[] createChildren(Vec3i center, WorldFractal fractal, Random rand) {
            Vec3i min = center.subtractLocal(4, 0, 4);
            Vec3i max = min.add(9, 0, 9);
            double yAverage = TestPoiGenerator.findAverageElevation(min, max, fractal);
            min.y = (int)Math.round(yAverage);
            InsertInfo child = new InsertInfo("isolated" + this.size, min, max.subtract(min));
            return new InsertInfo[]{child};
        }

        @Override
        public void apply(Candidate[][] candidates) {
            double minRadius = 64 * this.size;
            double minRadiusSq = minRadius * minRadius;
            double poiRadius = 1024 * this.size;
            double poiRadiusSq = poiRadius * poiRadius;
            int max = 128;
            int radius = (int)Math.round(poiRadius / 128.0);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int i = this.loc.x + x;
                    int j = this.loc.z + z;
                    if (i < 0 || j < 0 || i >= max || j >= max) continue;
                    double dx = x * 128;
                    double dz = z * 128;
                    double dSq = dx * dx + dz * dz;
                    Candidate candidate = candidates[i][j];
                    if (candidate == null) continue;
                    if (dSq <= minRadiusSq) {
                        candidate.town = 0.0;
                        candidate.farm = 0.0;
                        candidate.cliff = 0.0;
                        candidate.isolated = 0.0;
                        continue;
                    }
                    if (!(dSq < poiRadiusSq)) continue;
                    double scale = dSq / poiRadiusSq;
                    candidate.town *= scale;
                    candidate.farm *= scale;
                    candidate.cliff *= scale;
                    candidate.isolated *= scale;
                }
            }
        }
    }
}

