/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.World;
import com.simsilica.mworld.WorldCellDataAdapter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockIterator
implements Iterator<Intersection> {
    static Logger log = LoggerFactory.getLogger(BlockIterator.class);
    private CellData cells;
    private Rayd ray;
    private double limit;
    private PlaneIntersector[] planeIntersects;
    private double[] dists = new double[3];
    private double distance;
    private Intersection next;

    public BlockIterator(World world, Rayd ray, double limit) {
        this(new WorldCellDataAdapter(world), ray, limit);
    }

    public BlockIterator(CellData cells, Rayd ray, double limit) {
        this.cells = cells;
        this.ray = ray;
        this.limit = limit;
        this.planeIntersects = new PlaneIntersector[]{new PlaneIntersector(ray, 0), new PlaneIntersector(ray, 1), new PlaneIntersector(ray, 2)};
    }

    private int minIndex(double ... vals) {
        int minIndex = 0;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == Double.NaN || !(vals[i] < min)) continue;
            min = vals[i];
            minIndex = i;
        }
        return minIndex;
    }

    public double getLimit() {
        return this.limit;
    }

    public Rayd getRay() {
        return this.ray;
    }

    protected void fetch() {
        if (this.next != null || this.distance >= this.limit) {
            return;
        }
        while (this.distance < this.limit) {
            int type;
            this.dists[0] = this.planeIntersects[0].getNextLength();
            this.dists[1] = this.planeIntersects[1].getNextLength();
            this.dists[2] = this.planeIntersects[2].getNextLength();
            int minIndex = this.minIndex(this.dists);
            PlaneIntersector plane = this.planeIntersects[minIndex];
            this.distance = plane.getNextLength();
            Vec3i blockIntersect = plane.getNextBlockIntersect();
            Vec3d intersect = plane.next();
            int value = this.cells.getCell(blockIntersect.x, blockIntersect.y, blockIntersect.z, -1);
            if (value == -1 || (type = MaskUtils.getType((int)value)) == 0) continue;
            this.next = new Intersection(intersect, blockIntersect, type, value, plane.normal);
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.next != null;
    }

    @Override
    public Intersection next() {
        this.fetch();
        Intersection result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported on intersectors.");
    }

    private static class PlaneIntersector {
        private Vec3d start;
        private int axis = 0;
        private int step = 0;
        private Vec3d normal;
        private double sign;
        private Vec3d dir;
        private double dirLength;
        private double nextLength;

        public PlaneIntersector(Rayd ray, int axis) {
            this.axis = axis;
            Vec3d pos = ray.getOrigin();
            Vec3d heading = ray.getDirection();
            this.sign = Math.signum(heading.get(axis));
            this.dir = heading.mult(this.sign / heading.get(axis));
            if (this.sign == 0.0) {
                this.dirLength = Double.POSITIVE_INFINITY;
            } else {
                this.dir.set(axis, this.sign);
                this.dirLength = this.dir.length();
            }
            this.normal = new Vec3d();
            this.normal.set(axis, -this.sign);
            double grid = Math.floor(pos.get(axis));
            if (this.sign > 0.0) {
                grid += 1.0;
            }
            double scale = (grid - pos.get(axis)) / this.sign;
            this.start = this.dir.mult(scale);
            this.nextLength = this.start.length();
            this.start.addLocal(pos);
        }

        public double getSign() {
            return this.sign;
        }

        public double getNextLength() {
            return this.nextLength;
        }

        public Vec3i getNextBlockIntersect() {
            Vec3d pos = this.getNextIntersect();
            Vec3i result = pos.floor();
            if (this.sign < 0.0) {
                result.set(this.axis, result.get(this.axis) - 1);
            }
            return result;
        }

        public Vec3d getNextIntersect() {
            return this.start.add(this.dir.mult((double)this.step));
        }

        public Vec3d next() {
            Vec3d last = this.getNextIntersect();
            this.nextLength += this.dirLength;
            ++this.step;
            return last;
        }
    }

    public static class Intersection {
        private Vec3d point;
        private Vec3i block;
        private Vec3d normal;
        private int type;
        private int value;

        public Intersection(Vec3d point, Vec3i block, int type, int value, Vec3d normal) {
            this.point = point;
            this.block = block;
            this.type = type;
            this.value = value;
            this.normal = normal;
        }

        public int getType() {
            return this.type;
        }

        public int getCellValue() {
            return this.value;
        }

        public Vec3d getPoint() {
            return this.point;
        }

        public Vec3d getNormal() {
            return this.normal;
        }

        public Vec3i getBlock() {
            return this.block;
        }

        public String toString() {
            return "Intersection[block:" + this.block + ", hit:" + this.point + ", type:" + this.type + ", normal:" + this.normal + "]";
        }
    }
}

