/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.LeafChangeListenerSupport;
import com.simsilica.mworld.net.WorldDataListener;
import com.simsilica.mworld.net.WorldDataSession;
import com.simsilica.mworld.net.client.RemoteWorldData;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldClientService
extends AbstractClientService
implements World {
    static Logger log = LoggerFactory.getLogger(WorldClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private WorldDataSession delegate;
    private RemoteWorldData remoteDb;
    private boolean cleanupBlockIndexes;
    private boolean cleanupTreeIndex;
    private WorldSessionCallback sessionCallback = new WorldSessionCallback();
    private List<CellChangeListener> cellListeners = new ArrayList<CellChangeListener>();
    private CellChangeListener[] cellListenerArray;
    private CellChangeListener[] emptyCellListenerArray = new CellChangeListener[0];
    private LeafChangeListenerSupport leafListeners = new LeafChangeListenerSupport();
    private CopyOnWriteArrayList<TileListener> tileListeners = new CopyOnWriteArrayList();

    public WorldClientService() {
        this(-2);
    }

    public WorldClientService(int channel) {
        this.channel = channel;
        this.remoteDb = new RemoteWorldData();
    }

    @Override
    public synchronized void addLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.add(l);
    }

    @Override
    public synchronized void removeLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.remove(l);
    }

    @Override
    public synchronized void addCellChangeListener(CellChangeListener l) {
        this.cellListeners.add(l);
        this.cellListenerArray = null;
    }

    @Override
    public synchronized void removeCellChangeListener(CellChangeListener l) {
        this.cellListeners.remove(l);
        this.cellListenerArray = null;
    }

    protected CellChangeListener[] getCellListenerArray() {
        if (this.cellListenerArray == null) {
            this.cellListenerArray = this.cellListeners.toArray(this.emptyCellListenerArray);
        }
        return this.cellListenerArray;
    }

    @Override
    public synchronized void addTileListener(TileListener l) {
        this.tileListeners.add(l);
    }

    @Override
    public synchronized void removeTileListener(TileListener l) {
        this.tileListeners.remove(l);
    }

    protected synchronized void fireLeafChanged(LeafChangeEvent event) {
        this.leafListeners.fireLeafChanged(event);
    }

    protected synchronized void fireCellChanged(CellChangeEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("fireCellChanged(" + event + ")");
        }
        for (CellChangeListener l : this.getCellListenerArray()) {
            l.cellChanged(event);
        }
    }

    protected synchronized void fireTileChanged(TileChangeEvent event) {
        for (TileListener l : this.tileListeners) {
            l.tileChanged(event);
        }
    }

    @Override
    public int getMaxY() {
        return this.remoteDb.getMaxY();
    }

    @Override
    public int setWorldCell(Vec3d world, int cellType) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLocalWorldCell(Vec3i world, int cellType) {
        if (world.y < 0) {
            return false;
        }
        Set<LeafId> changes = this.remoteDb.setLocalWorldCell(world, cellType);
        if (changes == null || changes.isEmpty()) {
            return false;
        }
        for (LeafId id : changes) {
            LeafChangeEvent event = new LeafChangeEvent(id, 0L);
            if (log.isTraceEnabled()) {
                log.trace("firing local event:" + event);
            }
            LeafChangeListenerSupport leafChangeListenerSupport = this.leafListeners;
            synchronized (leafChangeListenerSupport) {
                this.leafListeners.fireLeafChanged(event);
            }
        }
        return true;
    }

    @Override
    public int getWorldCell(Vec3d world) {
        if (world.y >= (double)this.getMaxY()) {
            return 0;
        }
        if (world.y < 0.0) {
            return -1;
        }
        LeafId id = LeafId.fromWorld(world);
        LeafData leaf = this.getLeaf(id);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell(world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell(world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell(world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    @Override
    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld(worldLocation));
    }

    protected boolean threadCheck() {
        return "jME3 Main".equals(Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeafData getLeaf(LeafId leafId) {
        if (leafId == null) {
            return null;
        }
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            LeafData leafData = this.remoteDb.getLeaf(leafId);
            return leafData;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LightData getLight(LeafId leafId) {
        if (leafId == null) {
            return null;
        }
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            LightData lightData = this.remoteDb.getLight(leafId);
            return lightData;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FluidData getFluid(LeafId leafId) {
        if (leafId == null) {
            return null;
        }
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            FluidData fluidData = this.remoteDb.getFluid(leafId);
            return fluidData;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    public LeafData getLeafIfPresent(LeafId leafId) {
        return this.remoteDb.getLeafIfPresent(leafId);
    }

    public LightData getLightIfPresent(LeafId leafId) {
        return this.remoteDb.getLightIfPresent(leafId);
    }

    public FluidData getFluidIfPresent(LeafId leafId) {
        return this.remoteDb.getFluidIfPresent(leafId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            TerrainImage terrainImage = this.remoteDb.getTerrainImage(id, type, res);
            return terrainImage;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            TreeLayer treeLayer = this.remoteDb.getTrees(id, res);
            return treeLayer;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        boolean check = this.threadCheck();
        long start = System.nanoTime();
        try {
            PointCloudLayer pointCloudLayer = this.remoteDb.getPointCloudLayer(id, res);
            return pointCloudLayer;
        }
        finally {
            long end = System.nanoTime();
            if (check && end - start > 1000000L) {
                log.info("Long-style query from JME update thread, took:" + (double)(end - start) / 1000000.0 + " ms", new Throwable("stack trace"));
            }
        }
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ") channel:" + this.channel);
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("WorldClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, WorldDataListener.class);
    }

    public void start() {
        log.debug("start()");
        super.start();
        this.remoteDb.start(this.getDelegate());
        log.info("TreeTypeIndex are blocks initialized:" + BlockTypeIndex.isInitialized());
        if (!BlockTypeIndex.isInitialized()) {
            log.info("Need to get blocks/fluids types from server.");
            BlockTypeIndex.initialize((BlockTypeData)this.remoteDb.getBlockTypeData());
            FluidTypeIndex.initialize((FluidTypeData)this.remoteDb.getFluidTypeData());
            this.cleanupBlockIndexes = true;
        }
        if (!TreeTypeIndex.getInstance().isInitialized()) {
            TreeTypeIndex.getInstance().initialize(this.remoteDb.getTreeTypeIndex());
            this.cleanupTreeIndex = true;
        }
    }

    public void terminate(ClientServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
        this.remoteDb.stop();
        if (this.cleanupBlockIndexes) {
            BlockTypeIndex.reset();
            FluidTypeIndex.reset();
        }
        if (this.cleanupTreeIndex) {
            TreeTypeIndex.getInstance().terminate();
        }
    }

    private WorldDataSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (WorldDataSession)this.rmiService.getRemoteObject(WorldDataSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No chat session found");
            }
        }
        return this.delegate;
    }

    private class WorldSessionCallback
    implements WorldDataListener {
        private WorldSessionCallback() {
        }

        @Override
        public void cellChanged(long leafId, byte[] eventData, boolean zipped) {
            CellChangeEvent event = WorldClientService.this.remoteDb.cellChanged(leafId, eventData, zipped);
            if (event != null && WorldClientService.this.remoteDb.applyChange(event)) {
                WorldClientService.this.fireCellChanged(event);
                WorldClientService.this.leafListeners.fireLeafChanged(new LeafChangeEvent(new LeafId(leafId), -1L));
            }
        }

        @Override
        public void leafChanged(long leafId, long leafVersion) {
            LeafChangeEvent event = new LeafChangeEvent(new LeafId(leafId), leafVersion);
            if (log.isTraceEnabled()) {
                log.trace("leafChanged(" + event + ")");
            }
            if (WorldClientService.this.remoteDb.applyChange(event)) {
                WorldClientService.this.leafListeners.fireLeafChanged(event);
            }
        }

        @Override
        public void tileChanged(Class dataType, long tileId, long dataVersion, Resolution res) {
            TileChangeEvent event = WorldClientService.this.remoteDb.tileChanged(dataType, tileId, dataVersion, res);
            if (event != null && WorldClientService.this.remoteDb.applyChange(event)) {
                WorldClientService.this.fireTileChanged(event);
            }
        }

        @Override
        public void partReceived(long requestId, byte part, byte total, byte[] data) {
            WorldClientService.this.remoteDb.partReceived(requestId, part, total, data);
        }
    }
}

