/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyTreeSplatsFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(ApplyTreeSplatsFunction.class);

    @Override
    public void accept(Tile tile) {
        TreeLayer trees = tile.get(TreeLayer.class);
        if (trees.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        log.info("Splatting trees for tile:" + tile);
        TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() >= 0L && fluid.getVersion().getLoadVersion() >= 0L) {
            log.info("terrain was already generated, tile:" + tile.getTileId().getWorld(null) + ", res:" + (Object)((Object)tile.getResolution()));
            return;
        }
        if (tile.getResolution() != Resolution.High) {
            return;
        }
        boolean changed = false;
        for (Tree tree : trees.getTrees()) {
            if (!tree.type.insertTree(tree, terrain)) continue;
            changed = true;
        }
    }
}

