/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.DebugKeysAppState;
import com.jme3.app.FlyCamAppState;
import com.jme3.app.LegacyApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ConstantVerifierState;
import com.jme3.audio.AudioListenerState;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.FlyByCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.profile.AppStep;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;

public abstract class SimpleApplication
extends LegacyApplication {
    public static final String INPUT_MAPPING_EXIT = "SIMPLEAPP_Exit";
    public static final String INPUT_MAPPING_CAMERA_POS = "SIMPLEAPP_CameraPos";
    public static final String INPUT_MAPPING_MEMORY = "SIMPLEAPP_Memory";
    public static final String INPUT_MAPPING_HIDE_STATS = "SIMPLEAPP_HideStats";
    protected Node rootNode = new Node("Root Node");
    protected Node guiNode = new Node("Gui Node");
    protected BitmapText fpsText;
    protected BitmapFont guiFont;
    protected FlyByCamera flyCam;
    protected boolean showSettings = true;
    private final AppActionListener actionListener = new AppActionListener();

    public SimpleApplication() {
        this(new StatsAppState(), new FlyCamAppState(), new AudioListenerState(), new DebugKeysAppState(), new ConstantVerifierState());
    }

    public SimpleApplication(AppState ... initialStates) {
        super(initialStates);
    }

    @Override
    public void start() {
        boolean loadSettings = false;
        if (this.settings == null) {
            this.setSettings(new AppSettings(true));
            loadSettings = true;
        }
        if (this.showSettings && !JmeSystem.showSettingsDialog(this.settings, loadSettings)) {
            return;
        }
        this.setSettings(this.settings);
        super.start();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public FlyByCamera getFlyByCamera() {
        return this.flyCam;
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean isShowSettings() {
        return this.showSettings;
    }

    public void setShowSettings(boolean showSettings) {
        this.showSettings = showSettings;
    }

    protected BitmapFont loadGuiFont() {
        return this.assetManager.loadFont("Interface/Fonts/Default.fnt");
    }

    @Override
    public void initialize() {
        super.initialize();
        this.guiFont = this.loadGuiFont();
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.viewPort.attachScene(this.rootNode);
        this.guiViewPort.attachScene(this.guiNode);
        if (this.inputManager != null) {
            if (this.stateManager.getState(FlyCamAppState.class) != null) {
                this.flyCam = new FlyByCamera(this.cam);
                this.flyCam.setMoveSpeed(1.0f);
                this.stateManager.getState(FlyCamAppState.class).setCamera(this.flyCam);
            }
            if (this.context.getType() == JmeContext.Type.Display) {
                this.inputManager.addMapping(INPUT_MAPPING_EXIT, new KeyTrigger(1));
            }
            if (this.stateManager.getState(StatsAppState.class) != null) {
                this.inputManager.addMapping(INPUT_MAPPING_HIDE_STATS, new KeyTrigger(63));
                this.inputManager.addListener(this.actionListener, INPUT_MAPPING_HIDE_STATS);
            }
            this.inputManager.addListener(this.actionListener, INPUT_MAPPING_EXIT);
        }
        if (this.stateManager.getState(StatsAppState.class) != null) {
            this.stateManager.getState(StatsAppState.class).setFont(this.guiFont);
            this.fpsText = this.stateManager.getState(StatsAppState.class).getFpsText();
        }
        this.simpleInitApp();
    }

    @Override
    public void update() {
        if (this.prof != null) {
            this.prof.appStep(AppStep.BeginFrame);
        }
        super.update();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        if (this.prof != null) {
            this.prof.appStep(AppStep.StateManagerUpdate);
        }
        this.stateManager.update(tpf);
        this.simpleUpdate(tpf);
        if (this.prof != null) {
            this.prof.appStep(AppStep.SpatialUpdate);
        }
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        if (this.prof != null) {
            this.prof.appStep(AppStep.StateManagerRender);
        }
        this.stateManager.render(this.renderManager);
        if (this.prof != null) {
            this.prof.appStep(AppStep.RenderFrame);
        }
        this.renderManager.render(tpf, this.context.isRenderable());
        this.simpleRender(this.renderManager);
        this.stateManager.postRender();
        if (this.prof != null) {
            this.prof.appStep(AppStep.EndFrame);
        }
    }

    public void setDisplayFps(boolean show) {
        if (this.stateManager.getState(StatsAppState.class) != null) {
            this.stateManager.getState(StatsAppState.class).setDisplayFps(show);
        }
    }

    public void setDisplayStatView(boolean show) {
        if (this.stateManager.getState(StatsAppState.class) != null) {
            this.stateManager.getState(StatsAppState.class).setDisplayStatView(show);
        }
    }

    public abstract void simpleInitApp();

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager rm) {
    }

    private class AppActionListener
    implements ActionListener {
        private AppActionListener() {
        }

        @Override
        public void onAction(String name, boolean value, float tpf) {
            if (!value) {
                return;
            }
            if (name.equals(SimpleApplication.INPUT_MAPPING_EXIT)) {
                SimpleApplication.this.stop();
            } else if (name.equals(SimpleApplication.INPUT_MAPPING_HIDE_STATS) && SimpleApplication.this.stateManager.getState(StatsAppState.class) != null) {
                SimpleApplication.this.stateManager.getState(StatsAppState.class).toggleStats();
            }
        }
    }
}

