#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Skinning.glsllib"
#import "Common/ShaderLib/Instancing.glsllib"
#import "Common/ShaderLib/MorphAnim.glsllib"
#import "Common/ShaderLib/Lighting.glsllib"
#import "Common/ShaderLib/BlinnPhongLighting.glsllib"
#import "MatDefs/ViewMask.glsllib"

attribute vec3 inPosition;
attribute vec3 inNormal;

#if defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPARATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

attribute vec2 inTexCoord;
attribute vec2 inTexCoord2;
attribute vec4 inColor;

varying vec2 texCoord1;
varying vec2 texCoord2;

varying vec4 vertColor;
#ifdef HAS_POINTSIZE
    uniform float m_PointSize;
#endif
uniform float m_Quadratic;
uniform vec3 g_CameraPosition;
uniform vec3 g_CameraDirection;

//const float SIZE_MULTIPLIER = 1.25;
// we add a little to the size to overcome the distance errors
// that cause gaps to appear between blocks when at the edges of the screen.
// Actually, I find gaps show up when looking straight down, too.
// We'll have to tweak this when we know actual screen distances.
const float SIZE_MULTIPLIER = 1.45;


// fog - jayfella
#ifdef USE_FOG
varying float fog_distance;
#endif

uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;
uniform vec4 g_LightDirection;

varying vec2 vertexLightValues;
varying vec3 lightVec;

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;
varying vec4 modelLight;

uniform float m_LocalLightStrength;

uniform float m_ClipDistance;

const float SHININESS = 1.0;

void main(){
    #ifdef NEED_TEXCOORD1
        texCoord1 = inTexCoord;
    #endif

    #ifdef SEPARATE_TEXCOORD
        texCoord2 = inTexCoord2;
    #endif

    //#ifdef HAS_VERTEXCOLOR
    //    vertColor = inColor;
    //#endif

    #ifdef HAS_POINTSIZE
        gl_PointSize = m_PointSize;
    #endif

    vec4 modelSpacePos = vec4(inPosition, 1.0);
    vec3 modelSpaceNorm = inNormal;
    modelLight = inColor;
    modelLight.xyz *= m_LocalLightStrength;

    #ifdef NUM_MORPH_TARGETS
        Morph_Compute(modelSpacePos);
    #endif

    #ifdef NUM_BONES
        Skinning_Compute(modelSpacePos);
    #endif

    // The point sprites should be oriented around the center of the
    // block, not its corner... model space position is in the corner.
    modelSpacePos.xyz += vec3(0.5, 0.5, 0.5);

    gl_Position = TransformWorldViewProjection(modelSpacePos);

    vec4 worldPos = g_WorldMatrix * modelSpacePos;
    vec3 offset = worldPos.xyz - g_CameraPosition.xyz;
    vec3 dir = normalize(offset);

    // Get the scale from the world matrix so we can scale our
    // point sprites if the model is scaled.
    float scale = length(g_WorldMatrix[0]);

    // Need to select an aligned normal based on the camera direction and the
    // masks encoded in the inNormal.  We want to use the active normal with
    // the best view direction 'dot'.  For this we'll assume our 'model' is
    // axis aligned already so rotation isn't a factor.  That way we don't have
    // to reorient our axes.
    //
    // I don't know if there is clever math to do this so we will 'brute force'
    // it by creating the 8 direction vectors and selecting the best one.
    // best = one that points most towards camera.  If none do, then we won't
    // render at all.  scale=0;

    // We want the best 'normal' that is facing the camera.  To do that, we'll
    // collect the best normal for each axis... which could also be 'none'.
    float xDot = 0.0;
    float xNorm = 0.0;
    if( modelSpaceNorm.x > 0.0 ) {
        if( dir.x > 0.0 ) {
            if( modelSpaceNorm.x <= 0.5 ) {
                xNorm = -1.0;
                xDot = dir.x;
            }
        } else if( dir.x < 0.0 ) {
            if( modelSpaceNorm.x >= 0.5 ) {
                xNorm = 1.0;
                xDot = -dir.x;
            }
        }
    }
    //scale = abs(xNorm);

    float yDot = 0.0;
    float yNorm = 0.0;
    if( modelSpaceNorm.y > 0.0 ) {
        if( dir.y > 0.0 ) {
            if( modelSpaceNorm.y <= 0.5 ) {
                yNorm = -1.0;
                yDot = dir.y;
            }
        } else if( dir.y < 0.0 ) {
            if( modelSpaceNorm.y >= 0.5 ) {
                yNorm = 1.0;
                yDot = -dir.y;
            }
        }
    }
    //scale = abs(yNorm);

    float zDot = 0.0;
    float zNorm = 0.0;
    if( modelSpaceNorm.z > 0.0 ) {
        if( dir.z > 0.0 ) {
            if( modelSpaceNorm.z <= 0.5 ) {
                zNorm = -1.0;
                zDot = dir.z;
            }
        } else if( dir.z < 0.0 ) {
            if( modelSpaceNorm.z >= 0.5 ) {
                zNorm = 1.0;
                zDot = -dir.z;
            }
        }
    }
    //scale = abs(zNorm);

//#define SELECTED_NORMALS
    #ifdef SELECTED_NORMALS
        // Now pick the best
        float bestDot = 0.0;
        modelSpaceNorm = vec3(0.0);
        if( xDot > bestDot ) {
            modelSpaceNorm = vec3(xNorm, 0.0, 0.0);
            bestDot = xDot;
        }
        if( yDot > bestDot ) {
            modelSpaceNorm = vec3(0.0, yNorm, 0.0);
            bestDot = yDot;
        }
        if( zDot > bestDot ) {
            modelSpaceNorm = vec3(0.0, 0.0, zNorm);
        }

        // Set scale to zero if there is no normal information, ie: no
        // sides visible.  Note: takes advantage of the fact that the normal
        // we create is always length=1 already.
        scale = length(modelSpaceNorm);
    #else

        #ifdef PREFER_FACING
            // Change the curves to favor directions pointing more towards the camera.
            xDot *= xDot;
            yDot *= yDot;
            zDot *= zDot;
            // In some ways it was a bit better, in other ways 'meh'.
            // Would be nice to have some toggles to try this stuff out in the future
        #endif

        // Combine the best
        modelSpaceNorm = vec3(xNorm * xDot, yNorm * yDot, zNorm * zDot);

        if( xDot + yDot + zDot == 0.0 ) {
            scale = 0.0;
        }
    #endif


    // The dot product is closer than the straight distance but still not right.  We
    // get gaps at the far edges of the screen.  Probably we need to be messing with
    // the world view matrix but for now I'll just up the scale a little.
    // I think it's because of the warping of our FoV the spaces them out a little
    // further at the periphery.
    float d = dot(offset, g_CameraDirection);

    // A brute force LOD clip until we can have proper column clipping
    //if( d < 96.0 ) {
    //    scale = 0.0;
    //}
    //if( length(offset) < 96.0 ) {
    //    scale = 0.0;
    //}

    vec4 maskValue = getViewMask(modelSpacePos.xyz);
    //if( maskValue.r > 0.0 ) {
    // The > 0.5 is what the terrain tiles material does and if we don't do it
    // here then when using the texture array form, we get a border around the
    // rendered blocks where our point cloud doesn't render.
    if( maskValue.r > 0.5 ) {
        scale = 0.0;
    }

    //float d = distance(g_CameraPosition.xyz, worldPos.xyz);
    float size = scale * (SIZE_MULTIPLIER * m_Quadratic) / d;
    if( length(offset.xz) > CLIP_DISTANCE ) {
        size = 0.0;
    }
    //gl_PointSize = max(1.0, size);
    gl_PointSize = size;

//modelSpaceNorm = vec3(0.0, 0.0, 1.0);

    vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz,clamp(g_LightColor.w,0.0,1.0)));
    wvLightPos.w = g_LightPosition.w;
    vec4 lightColor = g_LightColor;
    vec3 wvPosition = TransformWorldView(modelSpacePos).xyz;// (g_WorldViewMatrix * modelSpacePos).xyz;
    vec3 wvNormal  = normalize(TransformNormal(modelSpaceNorm));//normalize(g_NormalMatrix * modelSpaceNorm);
    vec3 viewDir = normalize(-wvPosition);

    float sunlight = modelLight.w;

    AmbientSum  = g_AmbientLightColor.rgb * sunlight;
    DiffuseSum  =  vec4(lightColor.rgb * sunlight, 1.0);
    SpecularSum = vec3(0.0);

    float spotFallOff = 1.0;
    vec4 vLightDir;
    lightComputeDir(wvPosition, lightColor.w, wvLightPos, vLightDir, lightVec);
    vertexLightValues = computeLighting(wvNormal, viewDir, vLightDir.xyz, vLightDir.w * spotFallOff, SHININESS);

    #ifdef USE_FOG
    fog_distance = distance(g_CameraPosition, (g_WorldMatrix * modelSpacePos).xyz);
    #endif

}





