/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.debug;

import com.google.common.base.MoreObjects;
import com.jme3.math.ColorRGBA;
import com.simsilica.es.EntityComponent;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugShape
implements EntityComponent {
    static Logger log = LoggerFactory.getLogger(DebugShape.class);
    public static final int TYPE_BOX = 0;
    public static final int TYPE_SPHERE = 1;
    public static final int TYPE_ARROW = 2;
    public static final int TYPE_AXES = 3;
    public static final int STYLE_SOLID = 1;
    public static final int STYLE_OVERLAY = 2;
    public static final int STYLE_LIT = 4;
    private int type;
    private Vec3d size;
    private ColorRGBA color;
    private int style;

    private DebugShape() {
    }

    public DebugShape(int type, Vec3d size, ColorRGBA color, int style) {
        this.type = type;
        this.size = size;
        this.color = color;
        this.style = style;
    }

    public int getType() {
        return this.type;
    }

    public Vec3d getSize() {
        return this.size;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean hasStyle(int mask) {
        return (this.style & mask) == mask;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("type", this.type).add("size", (Object)this.size).add("color", (Object)this.color).add("style", this.style).toString();
    }
}

