/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecoratingBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(AbstractDecoratingBehavior.class);
    private Behavior delegate;

    protected AbstractDecoratingBehavior(Behavior delegate) {
        this.delegate = delegate;
    }

    protected Behavior getDelegate() {
        return this.delegate;
    }

    protected boolean isActive() {
        return this.isRunning();
    }

    @Override
    public Reaction generateReaction(Brain brain, Signal signal) {
        if (this.isActive()) {
            return this.delegate.generateReaction(brain, signal);
        }
        return null;
    }

    @Override
    protected void onStart(Brain brain) {
        this.delegate.start(brain);
    }

    @Override
    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.isActive()) {
            return this.delegate.update(frameTime, step);
        }
        return false;
    }

    @Override
    protected void onStop() {
        this.delegate.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegate:" + this.delegate + "]";
    }
}

