/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainElevationGenerator
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TerrainElevationGenerator.class);
    private int seaLevel = 128;
    private int treeLine = 500;
    private WorldFractal fractal;

    public TerrainElevationGenerator(WorldFractal fractal) {
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() < 0L) {
            this.generateElevation(terrain);
        }
        if (fluid.getVersion().getLoadVersion() < 0L) {
            int size = fluid.getSize();
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    short elev = terrain.getElevation(x, z);
                    if (elev < this.seaLevel) {
                        fluid.setElevation(x, z, (short)this.seaLevel);
                        fluid.setType(x, z, (byte)1);
                        byte type = terrain.getType(x, z);
                        terrain.setType(x, z, TerrainTypes.setFoliageLevel(type, 0));
                        continue;
                    }
                    fluid.setElevation(x, z, (short)this.seaLevel);
                    fluid.setType(x, z, (byte)-1);
                }
            }
            fluid.getVersion().markChanged();
        }
    }

    protected void generateElevation(TerrainImage target) {
        TerrainImageId id = target.getId();
        Vec3i world = id.getTileId().getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        int scale = 1024 / id.getResolution().getSamples();
        int size = target.getSize();
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                double xp = xCorner + (double)(x * scale);
                double zp = zCorner + (double)(z * scale);
                double yp = this.fractal.getElevation(xp, zp);
                int elevation = (int)yp;
                target.setElevation(x, z, (short)elevation);
            }
        }
    }
}

