/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.Morphology;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphologyLayer {
    static Logger log = LoggerFactory.getLogger(MorphologyLayer.class);
    private static int COLUMN_SIZE = 32;
    private TileId tileId;
    private DataVersion version;
    private byte generationLevel;
    private List<Morphology> morphList;
    private ListMultimap<Short, Morphology> binIndex;

    public MorphologyLayer(TileId tileId, DataVersion version) {
        this(tileId, version, 0, new ArrayList<Morphology>());
    }

    public MorphologyLayer(TileId tileId, DataVersion version, int generationLevel, List<Morphology> morphList) {
        this.tileId = tileId;
        this.version = version;
        this.generationLevel = (byte)generationLevel;
        this.morphList = morphList;
        this.binIndex = MultimapBuilder.hashKeys().arrayListValues().build();
        for (Morphology m : morphList) {
            this.indexMorphology(m);
        }
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void setGenerationLevel(int generationLevel) {
        if (this.generationLevel > generationLevel) {
            throw new IllegalArgumentException("Generation level cannot go backwards.");
        }
        this.generationLevel = (byte)generationLevel;
    }

    public int getGenerationLevel() {
        return this.generationLevel;
    }

    public List<Morphology> getMorphology() {
        return this.morphList;
    }

    public <T extends Morphology> boolean hasMorphology(Class<T> type) {
        for (Morphology m : this.morphList) {
            if (!type.isInstance(m)) continue;
            return true;
        }
        return false;
    }

    public Set<Short> getActiveBinIds() {
        return this.binIndex.keySet();
    }

    public ListMultimap<Short, Morphology> getBinIndex() {
        return this.binIndex;
    }

    public boolean addMorphology(Morphology m) {
        if (this.indexMorphology(m)) {
            this.morphList.add(m);
            return true;
        }
        log.warn("Morphology:" + m + " did not hit any columns in:" + this.tileId + "(" + this.tileId.getWorld(null) + ")");
        return false;
    }

    protected boolean indexMorphology(Morphology m) {
        boolean hit = false;
        for (Short s : m.getAffectedColumns(this.tileId)) {
            this.binIndex.put((Object)s, (Object)m);
            hit = true;
        }
        return hit;
    }

    public boolean apply(Tile tile) {
        Random rand = new Random(tile.getTileId().getId());
        boolean changed = false;
        for (Morphology m : this.morphList) {
            if (!m.morph(tile, rand)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean apply(ColumnData colData, Tile tile) {
        Random rand = new Random(colData.getColumnId().getId());
        short binId = colData.getColumnId().getTileLocalIndexId();
        boolean changed = false;
        for (Morphology m : this.binIndex.get((Object)binId)) {
            if (!m.morph(colData, tile, rand)) continue;
            changed = true;
        }
        return changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[tileId:" + this.tileId + ", version:" + this.version + ", size:" + this.morphList.size() + "]";
    }
}

