/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.geom;

import com.jme3.math.Vector2f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;

public class TbtQuad
extends Mesh
implements Cloneable {
    private Vector2f size;
    private Vector2f imageSize;
    private float[] horzFolds;
    private float[] vertFolds;
    private float[] horzTexCoords;
    private float[] vertTexCoords;

    public TbtQuad(float width, float height) {
        this.size = new Vector2f(width, height);
        this.imageSize = new Vector2f(width, height);
        this.horzFolds = new float[]{width / 3.0f, 2.0f * width / 3.0f};
        this.vertFolds = new float[]{height / 3.0f, 2.0f * height / 3.0f};
        this.horzTexCoords = new float[]{0.0f, 0.33333334f, 0.6666667f, 1.0f};
        this.vertTexCoords = new float[]{0.0f, 0.33333334f, 0.6666667f, 1.0f};
        this.refreshGeometry();
    }

    public TbtQuad(float width, float height, int x1, int y1, int x2, int y2, int imageWidth, int imageHeight, float imageScale) {
        this.size = new Vector2f(width, height);
        float iw = (float)imageWidth * imageScale;
        float ih = (float)imageHeight * imageScale;
        this.imageSize = new Vector2f(iw, ih);
        this.horzFolds = new float[]{imageScale * (float)x1, imageScale * (float)x2};
        this.vertFolds = new float[]{imageScale * (float)y1, imageScale * (float)y2};
        this.horzFolds[1] = this.horzFolds[1] + (width - iw);
        this.vertFolds[1] = this.vertFolds[1] + (height - ih);
        this.horzTexCoords = new float[]{0.0f, (float)x1 / (float)imageWidth, (float)x2 / (float)imageWidth, 1.0f};
        this.vertTexCoords = new float[]{0.0f, (float)y1 / (float)imageHeight, (float)y2 / (float)imageHeight, 1.0f};
        this.refreshGeometry();
    }

    public TbtQuad clone() {
        TbtQuad result = (TbtQuad)super.deepClone();
        result.size = this.size.clone();
        result.imageSize = this.imageSize.clone();
        result.horzFolds = (float[])this.horzFolds.clone();
        result.vertFolds = (float[])this.vertFolds.clone();
        result.horzTexCoords = (float[])this.horzTexCoords.clone();
        result.vertTexCoords = (float[])this.vertTexCoords.clone();
        return result;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public void updateSize(float width, float height) {
        if (this.size.x == width && this.size.y == height) {
            return;
        }
        this.horzFolds[1] = this.horzFolds[1] - (this.size.x - this.imageSize.x);
        this.vertFolds[1] = this.vertFolds[1] - (this.size.y - this.imageSize.y);
        this.size.set(width, height);
        this.horzFolds[1] = this.horzFolds[1] + (this.size.x - this.imageSize.x);
        this.vertFolds[1] = this.vertFolds[1] + (this.size.y - this.imageSize.y);
        this.refreshGeometry();
    }

    protected void refreshGeometry() {
        this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 12, 0, 12, 11, 1, 2, 13, 1, 13, 12, 2, 3, 13, 3, 4, 13, 13, 4, 5, 13, 5, 14, 14, 5, 6, 14, 6, 7, 15, 14, 7, 15, 7, 8, 10, 15, 9, 15, 8, 9, 11, 12, 15, 11, 15, 10, 12, 13, 14, 12, 14, 15});
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, this.horzFolds[0], 0.0f, 0.0f, this.horzFolds[1], 0.0f, 0.0f, this.size.x, 0.0f, 0.0f, this.size.x, this.vertFolds[0], 0.0f, this.size.x, this.vertFolds[1], 0.0f, this.size.x, this.size.y, 0.0f, this.horzFolds[1], this.size.y, 0.0f, this.horzFolds[0], this.size.y, 0.0f, 0.0f, this.size.y, 0.0f, 0.0f, this.vertFolds[1], 0.0f, 0.0f, this.vertFolds[0], 0.0f, this.horzFolds[0], this.vertFolds[0], 0.0f, this.horzFolds[1], this.vertFolds[0], 0.0f, this.horzFolds[1], this.vertFolds[1], 0.0f, this.horzFolds[0], this.vertFolds[1], 0.0f});
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{this.horzTexCoords[0], this.vertTexCoords[0], this.horzTexCoords[1], this.vertTexCoords[0], this.horzTexCoords[2], this.vertTexCoords[0], this.horzTexCoords[3], this.vertTexCoords[0], this.horzTexCoords[3], this.vertTexCoords[1], this.horzTexCoords[3], this.vertTexCoords[2], this.horzTexCoords[3], this.vertTexCoords[3], this.horzTexCoords[2], this.vertTexCoords[3], this.horzTexCoords[1], this.vertTexCoords[3], this.horzTexCoords[0], this.vertTexCoords[3], this.horzTexCoords[0], this.vertTexCoords[2], this.horzTexCoords[0], this.vertTexCoords[1], this.horzTexCoords[1], this.vertTexCoords[1], this.horzTexCoords[2], this.vertTexCoords[1], this.horzTexCoords[2], this.vertTexCoords[2], this.horzTexCoords[1], this.vertTexCoords[2]});
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        this.updateBound();
    }
}

