/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.input;

import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.JoystickButton;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.Axis;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputConfigListener;
import com.simsilica.lemur.input.InputDevice;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.input.StateMethodDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputMapper {
    static Logger log = LoggerFactory.getLogger(InputMapper.class);
    private InputManager inputManager;
    private InputObserver listener;
    private List<InputConfigListener> configListeners = new CopyOnWriteArrayList<InputConfigListener>();
    private Set<String> activeGroups = new HashSet<String>();
    private Map<Object, StateGroupIndex> stateIndex = new HashMap<Object, StateGroupIndex>();
    private Set<StateGroup> activeStates = new HashSet<StateGroup>();
    private Map<Joystick, InputDevice> joystickMap = new HashMap<Joystick, InputDevice>();
    private Map<JoystickAxis, InputDevice.DeviceAxis> joystickAxisMap = new HashMap<JoystickAxis, InputDevice.DeviceAxis>();
    private Map<JoystickButton, InputDevice.DeviceButton> joystickButtonMap = new HashMap<JoystickButton, InputDevice.DeviceButton>();
    private Map<FunctionId, FunctionListeners> listenerMap = new HashMap<FunctionId, FunctionListeners>();
    private double tpf = 0.0;
    private long lastFrameNanos;

    public InputMapper(InputManager inputManager) {
        this.inputManager = inputManager;
        this.listener = new InputObserver();
        inputManager.addRawInputListener((RawInputListener)this.listener);
        Joystick[] sticks = inputManager.getJoysticks();
        if (sticks != null) {
            for (Joystick j : sticks) {
                this.mapJoystick(j);
            }
        }
        this.activeGroups.add("default");
        this.lastFrameNanos = System.nanoTime();
    }

    public void activateGroup(String group) {
        if (log.isTraceEnabled()) {
            log.trace("activate:" + group);
        }
        this.activeGroups.add(group);
    }

    public void deactivateGroup(String group) {
        if (log.isTraceEnabled()) {
            log.trace("deactivate:" + group);
        }
        this.activeGroups.remove(group);
    }

    public void release() {
        this.inputManager.removeRawInputListener((RawInputListener)this.listener);
    }

    protected void mapJoystick(Joystick j) {
        InputDevice device = InputDevice.joystick(this.joystickMap.size() + 1);
        this.joystickMap.put(j, device);
        log.info("Registered:" + j + " as:" + device);
        if (j.getAxis("rz") != null || j.getAxis("z") != null) {
            this.mapGamepad(device, j);
            return;
        }
        log.info("map basic joystick:" + j);
        this.joystickAxisMap.put(j.getXAxis(), device.axis(Axis.JOYSTICK_X));
        this.joystickAxisMap.put(j.getYAxis(), device.axis(Axis.JOYSTICK_Y));
        this.joystickAxisMap.put(j.getPovXAxis(), device.axis(Axis.JOYSTICK_HAT_X));
        this.joystickAxisMap.put(j.getPovYAxis(), device.axis(Axis.JOYSTICK_HAT_Y));
        for (JoystickButton b : j.getButtons()) {
            String id = b.getLogicalId();
            if (!Character.isDigit(id.charAt(0))) continue;
            int idVal = Integer.parseInt(id) + 1;
            Button button = new Button("joystick_" + idVal, "Button " + idVal);
            this.joystickButtonMap.put(b, device.button(button));
        }
    }

    protected void mapGamepad(InputDevice device, Joystick j) {
        String name;
        log.info("mapGamepad(" + j + ")");
        this.joystickAxisMap.put(j.getXAxis(), device.axis(Axis.JOYSTICK_LEFT_X));
        this.joystickAxisMap.put(j.getYAxis(), device.axis(Axis.JOYSTICK_LEFT_Y));
        this.joystickAxisMap.put(j.getAxis("z"), device.axis(Axis.JOYSTICK_RIGHT_X));
        this.joystickAxisMap.put(j.getAxis("rz"), device.axis(Axis.JOYSTICK_RIGHT_Y));
        this.joystickAxisMap.put(j.getAxis("rx"), device.axis(Axis.JOYSTICK_LEFT_TRIGGER));
        this.joystickAxisMap.put(j.getAxis("ry"), device.axis(Axis.JOYSTICK_RIGHT_TRIGGER));
        this.joystickAxisMap.put(j.getPovXAxis(), device.axis(Axis.JOYSTICK_HAT_X));
        this.joystickAxisMap.put(j.getPovYAxis(), device.axis(Axis.JOYSTICK_HAT_Y));
        this.joystickButtonMap.put(j.getButton("0"), device.button(Button.JOYSTICK_BUTTON1));
        this.joystickButtonMap.put(j.getButton("1"), device.button(Button.JOYSTICK_BUTTON2));
        this.joystickButtonMap.put(j.getButton("2"), device.button(Button.JOYSTICK_BUTTON3));
        this.joystickButtonMap.put(j.getButton("3"), device.button(Button.JOYSTICK_BUTTON4));
        this.joystickButtonMap.put(j.getButton("4"), device.button(Button.JOYSTICK_LEFT1));
        this.joystickButtonMap.put(j.getButton("5"), device.button(Button.JOYSTICK_RIGHT1));
        this.joystickButtonMap.put(j.getButton("6"), device.button(Button.JOYSTICK_LEFT2));
        this.joystickButtonMap.put(j.getButton("7"), device.button(Button.JOYSTICK_RIGHT2));
        this.joystickButtonMap.put(j.getButton("8"), device.button(Button.JOYSTICK_SELECT));
        this.joystickButtonMap.put(j.getButton("9"), device.button(Button.JOYSTICK_START));
        this.joystickButtonMap.put(j.getButton("10"), device.button(Button.JOYSTICK_LEFT3));
        this.joystickButtonMap.put(j.getButton("11"), device.button(Button.JOYSTICK_RIGHT3));
        for (JoystickButton b : j.getButtons()) {
            if (this.joystickButtonMap.containsKey(b)) continue;
            String id = b.getLogicalId();
            name = b.getName();
            if (Character.isDigit(id.charAt(0))) {
                int idVal = Integer.parseInt(id) + 1;
                id = String.valueOf(idVal);
                name = "Button " + id;
            }
            String targetId = "joystick_" + id;
            log.warn("No mapping for button:" + b + "  Defaulting to:" + targetId + " name:" + name);
            this.joystickButtonMap.put(b, device.button(new Button(targetId, name)));
        }
        for (JoystickAxis a : j.getAxes()) {
            if (this.joystickAxisMap.containsKey(a)) continue;
            String targetId = "joystick_" + a.getLogicalId();
            name = "Joystick " + a.getName();
            log.warn("no mapping for axis:" + a + "  Defaulting to:" + targetId + " name:" + name);
            this.joystickAxisMap.put(a, device.axis(new Axis(targetId, name)));
        }
    }

    protected StateGroupIndex getIndex(Object state, boolean create) {
        StateGroupIndex result = this.stateIndex.get(state);
        if (result == null && create) {
            result = new StateGroupIndex(state);
            this.stateIndex.put(state, result);
        }
        return result;
    }

    protected FunctionListeners getFunctionListeners(FunctionId f, boolean create) {
        FunctionListeners result = this.listenerMap.get(f);
        if (result == null && create) {
            result = new FunctionListeners();
            this.listenerMap.put(f, result);
        }
        return result;
    }

    public Mapping map(FunctionId function, Axis axis, Object ... pressed) {
        return this.addMapping(function, 1.0, axis, pressed);
    }

    public Mapping map(FunctionId function, InputState bias, Axis axis, Object ... pressed) {
        return this.addMapping(function, bias.asNumber(), axis, pressed);
    }

    public Mapping map(FunctionId function, Button button, Object ... pressed) {
        return this.addMapping(function, 1.0, button, pressed);
    }

    public Mapping map(FunctionId function, InputState bias, Button button, Object ... pressed) {
        return this.addMapping(function, bias.asNumber(), button, pressed);
    }

    public Mapping map(FunctionId function, int mainKeyCode, Object ... pressed) {
        return this.map(function, InputState.Positive, mainKeyCode, pressed);
    }

    public Mapping map(FunctionId function, InputState bias, int mainKeyCode, Object ... pressed) {
        return this.addMapping(function, bias.asNumber(), mainKeyCode, pressed);
    }

    protected Mapping addMapping(FunctionId function, double scale, Object primary, Object ... modifiers) {
        StateGroup g = new StateGroup(function, scale, primary, modifiers);
        this.getIndex(primary, true).addGroup(g);
        for (Object o : modifiers) {
            this.getIndex(o, true).addGroup(g);
        }
        this.fireMappingAdded(g);
        return g;
    }

    protected StateGroup findMapping(FunctionId function, Object primary, Object ... modifiers) {
        StateGroupIndex index = this.getIndex(primary, false);
        if (index == null) {
            return null;
        }
        return index.findGroup(function, modifiers);
    }

    public Mapping getMapping(FunctionId function, Object primary, Object ... modifiers) {
        return this.findMapping(function, primary, modifiers);
    }

    public void removeMapping(FunctionId function, Object primary, Object ... modifiers) {
        this.removeMapping(this.findMapping(function, primary, modifiers));
    }

    public void removeMapping(Mapping mapping) {
        StateGroup group = (StateGroup)mapping;
        boolean removed = false;
        for (StateGroupIndex index : this.stateIndex.values()) {
            if (!index.removeGroup(group)) continue;
            removed = true;
        }
        if (removed) {
            this.fireMappingRemoved(mapping);
        }
    }

    public boolean hasMappings(FunctionId function) {
        for (StateGroupIndex index : this.stateIndex.values()) {
            for (StateGroup group : index.groups) {
                if (!Objects.equals(function, group.function)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<FunctionId> getFunctionIds() {
        HashSet<FunctionId> results = new HashSet<FunctionId>();
        results.addAll(this.listenerMap.keySet());
        for (StateGroupIndex index : this.stateIndex.values()) {
            for (StateGroup group : index.groups) {
                results.add(group.function);
            }
        }
        return results;
    }

    public Set<Mapping> getMappings(FunctionId function) {
        LinkedHashSet<Mapping> results = new LinkedHashSet<Mapping>();
        for (StateGroupIndex index : this.stateIndex.values()) {
            for (StateGroup group : index.groups) {
                if (!Objects.equals(function, group.function)) continue;
                results.add(group);
            }
        }
        return results;
    }

    public void addStateListener(StateFunctionListener l, FunctionId ... functions) {
        if (functions == null || functions.length == 0) {
            throw new RuntimeException("No function IDs specified.");
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        for (FunctionId function : functions) {
            FunctionListeners listeners = this.getFunctionListeners(function, true);
            listeners.stateListeners.add((Object)l);
        }
    }

    public void removeStateListener(StateFunctionListener l, FunctionId ... functions) {
        if (functions == null || functions.length == 0) {
            throw new RuntimeException("No function IDs specified.");
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        for (FunctionId function : functions) {
            FunctionListeners listeners = this.getFunctionListeners(function, false);
            if (listeners == null) continue;
            listeners.stateListeners.remove((Object)l);
        }
    }

    public void addAnalogListener(AnalogFunctionListener l, FunctionId ... functions) {
        if (functions == null || functions.length == 0) {
            throw new RuntimeException("No function IDs specified.");
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        for (FunctionId function : functions) {
            FunctionListeners listeners = this.getFunctionListeners(function, true);
            listeners.analogListeners.add((Object)l);
        }
    }

    public void removeAnalogListener(AnalogFunctionListener l, FunctionId ... functions) {
        if (functions == null || functions.length == 0) {
            throw new RuntimeException("No function IDs specified.");
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        for (FunctionId function : functions) {
            FunctionListeners listeners = this.getFunctionListeners(function, false);
            if (listeners == null) continue;
            listeners.analogListeners.remove((Object)l);
        }
    }

    public void addDelegate(FunctionId func, Object target, String methodName) {
        this.addDelegate(func, target, methodName, false);
    }

    public void addDelegate(FunctionId func, Object target, String methodName, boolean passArgument) {
        this.addStateListener(new StateMethodDelegate(target, methodName, passArgument), func);
    }

    public void removeDelegate(FunctionId func, Object target, String methodName) {
        FunctionListeners listeners = this.getFunctionListeners(func, false);
        if (listeners == null) {
            return;
        }
        for (StateFunctionListener l : listeners.stateListeners) {
            StateMethodDelegate smd;
            if (!(l instanceof StateMethodDelegate) || (smd = (StateMethodDelegate)l).getTarget() != target || !smd.getMethodName().equals(methodName)) continue;
            listeners.stateListeners.remove((Object)l);
        }
    }

    protected void activate(StateGroup g) {
        if (!this.activeStates.add(g)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("activate(" + g.function + ":" + g.scale + ")");
        }
    }

    protected void deactivate(StateGroup g) {
        if (!this.activeStates.remove(g)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("deactivate(" + g.function + ":" + g.scale + ")");
        }
        this.notifyValueActive(g.getFunction(), 0.0);
        g.resetValue();
    }

    public void update() {
        for (StateGroup g : this.activeStates) {
            double value = this.getIndex(g.getPrimary(), false).getValue();
            g.updateValue(value);
            this.notifyValueActive(g.getFunction(), g.getValue());
        }
    }

    protected void notifyStateChanged(FunctionId function, InputState value) {
        FunctionListeners listeners = this.getFunctionListeners(function, false);
        if (listeners == null) {
            return;
        }
        listeners.notifyStateChanged(function, value);
    }

    protected void notifyValueActive(FunctionId function, double value) {
        FunctionListeners listeners = this.getFunctionListeners(function, false);
        if (listeners == null) {
            return;
        }
        listeners.notifyAnalogUpdate(function, value);
    }

    protected InputState valueToState(double val) {
        if (val < -0.01) {
            return InputState.Negative;
        }
        if (val > 0.01) {
            return InputState.Positive;
        }
        return InputState.Off;
    }

    public void addInputConfigListener(InputConfigListener l) {
        this.configListeners.add(l);
    }

    public void removeInputConfigListener(InputConfigListener l) {
        this.configListeners.remove(l);
    }

    protected void fireMappingAdded(Mapping m) {
        for (InputConfigListener l : this.configListeners) {
            l.mappingAdded(m);
        }
    }

    protected void fireMappingRemoved(Mapping m) {
        for (InputConfigListener l : this.configListeners) {
            l.mappingRemoved(m);
        }
    }

    protected void fireMappingChanged(Mapping m) {
        for (InputConfigListener l : this.configListeners) {
            l.mappingChanged(m);
        }
    }

    protected class InputObserver
    implements RawInputListener {
        protected InputObserver() {
        }

        public void onJoyAxisEvent(JoyAxisEvent evt) {
            InputDevice.DeviceAxis axis;
            if (log.isTraceEnabled()) {
                log.trace("onJoyAxisEvent(axis:" + evt.getAxis() + ", val:" + evt.getValue() + ")");
            }
            JoystickAxis a = evt.getAxis();
            Joystick j = a.getJoystick();
            float val = evt.getValue();
            float aVal = Math.abs(val);
            if ((double)aVal <= 0.01 || aVal <= Math.max(a.getDeadZone(), InputMapper.this.inputManager.getAxisDeadZone())) {
                val = 0.0f;
            }
            if ((axis = (InputDevice.DeviceAxis)InputMapper.this.joystickAxisMap.get(a)) == null) {
                log.warn("No axis mapping for:" + a);
                return;
            }
            StateGroupIndex index = InputMapper.this.getIndex(axis, false);
            if (index != null) {
                index.updateValue(val);
            }
            if ((index = InputMapper.this.getIndex(axis.getAxis(), false)) != null) {
                index.updateValue(val);
            }
        }

        public void onJoyButtonEvent(JoyButtonEvent evt) {
            InputDevice.DeviceButton b;
            if (log.isTraceEnabled()) {
                log.trace("onJoyButtonEvent(button:" + evt.getButton() + ", pressed:" + evt.isPressed() + ")");
            }
            if ((b = (InputDevice.DeviceButton)InputMapper.this.joystickButtonMap.get(evt.getButton())) == null) {
                log.warn("No button mapping for:" + evt.getButton());
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Forwarding events to button mapping:" + b);
            }
            double value = evt.isPressed() ? 1.0 : 0.0;
            StateGroupIndex index = InputMapper.this.getIndex(b, false);
            if (index != null) {
                index.updateValue(value);
            }
            if ((index = InputMapper.this.getIndex(b.getButton(), false)) != null) {
                index.updateValue(value);
            }
        }

        public void beginInput() {
            long time = System.nanoTime();
            InputMapper.this.tpf = (double)(time - InputMapper.this.lastFrameNanos) / 1.0E9;
            InputMapper.this.lastFrameNanos = time;
        }

        public void endInput() {
            InputMapper.this.update();
        }

        protected void instantUpdate(Axis a, double value) {
            StateGroupIndex index = InputMapper.this.getIndex(a, false);
            if (index == null) {
                return;
            }
            index.instantUpdate(value);
        }

        public void onMouseMotionEvent(MouseMotionEvent evt) {
            if (log.isTraceEnabled()) {
                log.trace("onMouseMotionEvent(" + evt + ")");
            }
            if (evt.getDeltaWheel() != 0) {
                this.instantUpdate(Axis.MOUSE_WHEEL, (double)evt.getDeltaWheel() / 120.0);
            }
            if (evt.getDX() != 0) {
                this.instantUpdate(Axis.MOUSE_X, (double)evt.getDX() / (1024.0 * InputMapper.this.tpf));
            }
            if (evt.getDY() != 0) {
                this.instantUpdate(Axis.MOUSE_Y, (double)evt.getDY() / (1024.0 * InputMapper.this.tpf));
            }
        }

        public void onMouseButtonEvent(MouseButtonEvent evt) {
            Button b;
            if (log.isTraceEnabled()) {
                log.trace("onMouseButtonEvent(" + evt + ")");
            }
            switch (evt.getButtonIndex()) {
                case 0: {
                    b = Button.MOUSE_BUTTON1;
                    break;
                }
                case 1: {
                    b = Button.MOUSE_BUTTON2;
                    break;
                }
                case 2: {
                    b = Button.MOUSE_BUTTON3;
                    break;
                }
                default: {
                    int i = evt.getButtonIndex() + 1;
                    b = new Button("mouse_" + i, "Mouse Button " + i);
                }
            }
            StateGroupIndex index = InputMapper.this.getIndex(b, false);
            if (index == null) {
                return;
            }
            double value = evt.isPressed() ? 1.0 : 0.0;
            index.updateValue(value);
        }

        public void onKeyEvent(KeyInputEvent evt) {
            if (log.isTraceEnabled()) {
                log.trace("onKeyEvent(" + evt + ")");
            }
            if (evt.isRepeating()) {
                return;
            }
            StateGroupIndex index = InputMapper.this.getIndex(evt.getKeyCode(), false);
            if (index == null) {
                return;
            }
            double value = evt.isPressed() ? 1.0 : 0.0;
            index.updateValue(value);
        }

        public void onTouchEvent(TouchEvent evt) {
        }
    }

    protected class StateGroupIndex {
        Object localState;
        List<StateGroup> groups = new ArrayList<StateGroup>();
        double lastValue;

        public StateGroupIndex(Object localState) {
            this.localState = localState;
        }

        public boolean isOn() {
            return InputMapper.this.valueToState(this.lastValue) != InputState.Off;
        }

        public double getValue() {
            return this.lastValue;
        }

        public StateGroup findGroup(FunctionId function, Object[] modifiers) {
            for (StateGroup g : this.groups) {
                if (!g.getFunction().equals(function) || modifiers.length != 0 && !g.hasSameModifiers(modifiers)) continue;
                return g;
            }
            return null;
        }

        public StateGroup addGroup(StateGroup g) {
            for (int i = 0; i < this.groups.size(); ++i) {
                StateGroup existing = this.groups.get(i);
                if (existing.compareTo(g) <= 0) continue;
                this.groups.add(i, g);
                return g;
            }
            this.groups.add(g);
            return g;
        }

        public boolean removeGroup(StateGroup g) {
            if (this.groups.remove(g)) {
                this.refresh();
                return true;
            }
            return false;
        }

        public void refresh() {
            boolean activatePrimary = this.isOn();
            for (StateGroup g : this.groups) {
                Object primary;
                if (!g.isTrue()) {
                    InputMapper.this.deactivate(g);
                    if (g.isPrimary(this.localState)) continue;
                    primary = g.getPrimary();
                    InputMapper.this.getIndex(primary, false).refresh();
                    continue;
                }
                if (g.isPrimary(this.localState)) {
                    if (activatePrimary) {
                        InputMapper.this.activate(g);
                        activatePrimary = false;
                        continue;
                    }
                    InputMapper.this.deactivate(g);
                    continue;
                }
                primary = g.getPrimary();
                InputMapper.this.getIndex(primary, false).refresh();
            }
        }

        public void updateValue(double val) {
            if (this.lastValue == val) {
                return;
            }
            this.lastValue = val;
            this.refresh();
        }

        public void instantUpdate(double val) {
            for (StateGroup g : this.groups) {
                if (!g.areModifiersTrue() || !g.isPrimary(this.localState)) continue;
                InputState state = InputMapper.this.valueToState(val *= g.getScale());
                InputMapper.this.notifyStateChanged(g.getFunction(), state);
                InputMapper.this.notifyValueActive(g.getFunction(), val);
                break;
            }
        }

        public String toString() {
            return "StateGroupIndex[" + this.localState + "]";
        }
    }

    protected class StateGroup
    implements Comparable<StateGroup>,
    Mapping {
        Object primaryState;
        Object[] modifiers;
        FunctionId function;
        double scale;
        double lastValue;
        InputState lastState;

        public StateGroup(FunctionId function, double scale, Object primaryState, Object ... modifiers) {
            this.function = function;
            this.scale = scale;
            this.primaryState = primaryState;
            this.modifiers = modifiers;
            this.resetValue();
        }

        @Override
        public Object getPrimaryActivator() {
            return this.primaryState;
        }

        @Override
        public List<Object> getModifiers() {
            return Collections.unmodifiableList(Arrays.asList(this.modifiers));
        }

        @Override
        public void setScale(double scale) {
            if (scale == 0.0) {
                throw new IllegalArgumentException("Scale cannot be 0.");
            }
            this.scale = scale;
            InputMapper.this.fireMappingChanged(this);
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        public boolean hasSameModifiers(Object[] mods) {
            if (mods.length != this.modifiers.length) {
                return false;
            }
            for (int i = 0; i < this.modifiers.length; ++i) {
                if (Objects.equals(mods[i], this.modifiers[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(StateGroup other) {
            int c = this.modifiers == null ? 0 : this.modifiers.length;
            int oc = other.modifiers == null ? 0 : other.modifiers.length;
            return oc - c;
        }

        @Override
        public FunctionId getFunction() {
            return this.function;
        }

        public double getValue() {
            return this.lastValue;
        }

        public void updateValue(double value) {
            double adjusted = value * this.scale;
            if (this.lastValue == adjusted) {
                return;
            }
            this.lastValue = adjusted;
            if (log.isTraceEnabled()) {
                log.trace("Value changed for:" + this.function + " scale:" + this.scale);
            }
            InputState state = InputMapper.this.valueToState(adjusted);
            this.updateState(state);
        }

        public void updateState(InputState state) {
            if (this.lastState == state) {
                return;
            }
            this.lastState = state;
            InputMapper.this.notifyStateChanged(this.function, this.lastState);
        }

        public void resetValue() {
            if (InputMapper.this.valueToState(this.lastValue) == InputState.Off) {
                return;
            }
            this.lastValue = 0.0;
            this.lastState = InputState.Off;
            InputMapper.this.notifyStateChanged(this.function, this.lastState);
        }

        public Object getPrimary() {
            return this.primaryState;
        }

        public boolean isPrimary(Object state) {
            if (state == this.primaryState) {
                return true;
            }
            return Objects.equals(state, this.primaryState);
        }

        public boolean isTrue() {
            if (!InputMapper.this.activeGroups.contains(this.function.getGroup())) {
                return false;
            }
            if (!InputMapper.this.getIndex(this.primaryState, false).isOn()) {
                return false;
            }
            for (Object o : this.modifiers) {
                if (InputMapper.this.getIndex(o, false).isOn()) continue;
                return false;
            }
            return true;
        }

        public boolean areModifiersTrue() {
            if (!InputMapper.this.activeGroups.contains(this.function.getGroup())) {
                return false;
            }
            for (Object o : this.modifiers) {
                if (InputMapper.this.getIndex(o, false).isOn()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "StateGroup[" + this.function + ":" + this.scale + ", " + this.primaryState + "]";
        }
    }

    public static interface Mapping {
        public FunctionId getFunction();

        public void setScale(double var1);

        public double getScale();

        public Object getPrimaryActivator();

        public List<Object> getModifiers();
    }

    protected class FunctionListeners {
        SafeArrayList<StateFunctionListener> stateListeners = new SafeArrayList(StateFunctionListener.class);
        SafeArrayList<AnalogFunctionListener> analogListeners = new SafeArrayList(AnalogFunctionListener.class);

        protected FunctionListeners() {
        }

        public void notifyStateChanged(FunctionId function, InputState value) {
            for (StateFunctionListener l : (StateFunctionListener[])this.stateListeners.getArray()) {
                l.valueChanged(function, value, InputMapper.this.tpf);
            }
        }

        public void notifyAnalogUpdate(FunctionId function, double value) {
            for (AnalogFunctionListener l : (AnalogFunctionListener[])this.analogListeners.getArray()) {
                l.valueActive(function, value, InputMapper.this.tpf);
            }
        }
    }
}

