/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.account.Account;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptProvider;
import com.simsilica.action.PromptType;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.net.BodyVisibility;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.es.MixConfig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mphys.DynArray;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.RecurringTaskSystem;
import com.simsilica.sim.SimTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import mythruna.GameConstants;
import mythruna.assembly.db.SubassemblyId;
import mythruna.assembly.db.SubassemblyStorage;
import mythruna.assembly.io.SubassemblyProtocol;
import mythruna.cmd.Command;
import mythruna.cmd.CommandSystem;
import mythruna.cmd.Context;
import mythruna.es.AssemblyBlueprintInfo;
import mythruna.es.BlueprintInfo;
import mythruna.es.ClothingInfo;
import mythruna.es.EntityLink;
import mythruna.es.Holding;
import mythruna.es.MovementInput;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.net.AssemblyBlueprintData;
import mythruna.net.BlueprintData;
import mythruna.net.ClothingData;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.server.AccountHostedService;
import mythruna.shape.ShapeName;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellService;
import mythruna.sim.Activator;
import mythruna.sim.PathRecorderSystem;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionHostedService
extends AbstractHostedConnectionService
implements Function<SimTime, Boolean> {
    static Logger log = LoggerFactory.getLogger(GameSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = GameSessionHostedService.class.getName();
    private static final String ATTRIBUTE_SHELL = "playerShell";
    private static final MovementInput EMPTY_INPUT = new MovementInput(new Vec3d(), new Quatd(), 0);
    private GameSystemManager gameSystems;
    private EntityData ed;
    private CommandSystem<GameSessionImpl, EntityId> cmdProc;
    private RmiHostedService rmiService;
    private DynArray<GameSessionImpl> players = new DynArray(GameSessionImpl.class);
    private GameSessionImpl[] playerArray = (GameSessionImpl[])this.players.getArray();
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;
    private ObjectType<Activator, EntityId> wandType;
    private Map<EntityId, ActionEnvironment<Activator, EntityId>> playerEnvs = new ConcurrentHashMap<EntityId, ActionEnvironment<Activator, EntityId>>();

    public GameSessionHostedService(GameSystemManager gameSystems) {
        this.gameSystems = gameSystems;
        this.setAutoHost(false);
    }

    public static CommandShell getShell(HostedConnection conn) {
        return (CommandShell)conn.getAttribute(ATTRIBUTE_SHELL);
    }

    public Map<EntityId, ActionEnvironment<Activator, EntityId>> getPlayerEnvs() {
        return this.playerEnvs;
    }

    protected void setupObjectTypes() {
        this.objectTypes = (ObjectTypeRegistry)this.gameSystems.get(ObjectTypeRegistry.class);
        this.wandType = this.objectTypes.getType("BuildWand");
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionHostedService requires an RMI service.");
        }
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
    }

    public void start() {
        super.start();
        EntityDataHostedService eds = (EntityDataHostedService)this.getService(EntityDataHostedService.class);
        if (eds == null) {
            throw new RuntimeException("GameSessionHostedService requires an EntityDataHostedService");
        }
        this.ed = eds.getEntityData();
        RecurringTaskSystem tasks = (RecurringTaskSystem)this.gameSystems.get(RecurringTaskSystem.class, true);
        tasks.addRecurringTask((Function)this);
        this.cmdProc = (CommandSystem)((Object)this.gameSystems.get(CommandSystem.class));
        this.cmdProc.registerCommand("record", new RecordCommand(), new Class[0]);
        this.cmdProc.registerCommand("play", new PlayCommand(), new Class[0]);
        this.cmdProc.registerCommand("stop", new StopCommand(), new Class[0]);
        ActivateCommand activate = new ActivateCommand();
        this.cmdProc.registerCommand("activatePrimary", activate, new Class[0]);
        this.cmdProc.registerCommand("activatePrimaryAlt", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondary", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondaryAlt", activate, new Class[0]);
        for (String s : this.cmdProc.getCommandNames()) {
            this.ed.getStrings().getStringId(s, true);
        }
        this.setupObjectTypes();
        for (ObjectType type : this.objectTypes) {
            for (String s : type.getActionNames()) {
                this.ed.getStrings().getStringId(s, true);
            }
        }
        ObjectType defaultType = this.objectTypes.getDefaultType();
        if (defaultType != null) {
            for (String s : defaultType.getActionNames()) {
                this.ed.getStrings().getStringId(s, true);
            }
        }
    }

    public void stop() {
        super.stop();
        RecurringTaskSystem tasks = (RecurringTaskSystem)this.gameSystems.get(RecurringTaskSystem.class, true);
        tasks.removeRecurringTask((Function)this);
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHostingOnConnection(HostedConnection conn, EntityId character) {
        log.debug("startHostingOnConnection(" + conn + ", " + character + ")");
        GameSessionImpl session = new GameSessionImpl(conn, character);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        EventBus.publish((EventType)PlayerEntityEvent.playerEntityJoining, (Object)new PlayerEntityEvent(character, conn));
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)session, GameSession.class);
        DynArray<GameSessionImpl> dynArray = this.players;
        synchronized (dynArray) {
            this.players.add((Object)session);
            this.playerArray = (GameSessionImpl[])this.players.getArray();
        }
        session.initialize();
        ((ChatHostedService)this.getService(ChatHostedService.class)).startHostingOnConnection(conn, session.getPlayerName());
    }

    protected static GameSessionImpl getGameSession(HostedConnection conn) {
        return (GameSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        GameSessionImpl session = GameSessionHostedService.getGameSession(conn);
        if (session != null) {
            session.close();
            DynArray<GameSessionImpl> dynArray = this.players;
            synchronized (dynArray) {
                this.players.remove((Object)session);
                this.playerArray = (GameSessionImpl[])this.players.getArray();
            }
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    @Override
    public Boolean apply(SimTime time) {
        for (GameSessionImpl sess : this.playerArray) {
            sess.update(time);
        }
        return Boolean.TRUE;
    }

    protected EntityId findEntity(Class<? extends EntityComponent> type, String field, Object value) {
        ComponentFilter filter = Filters.fieldEquals(type, (String)field, (Object)value);
        return this.ed.findEntity(filter, new Class[]{type});
    }

    protected EntityId findEntityLink(String type, EntityId target) {
        ComponentFilter<EntityLink> filter = EntityLink.filter(type, null, target, this.ed);
        return this.ed.findEntity(filter, new Class[]{EntityLink.class});
    }

    private class GameSessionImpl
    implements GameSession {
        private HostedConnection conn;
        private GameSessionListener callback;
        private EntityId characterEntity;
        private EntityId avatarEntity;
        private EntityId backupEntity;
        private CommandShell shell;
        private Vec3d spawnLoc;
        private Quatd spawnRot;
        private Context<GameSessionImpl> commandContext;
        private ActivatorImpl activator;
        private ActionEnvironment<Activator, EntityId> actionEnv;
        private long lastMoveTime = System.currentTimeMillis();
        private MovementInput lastInput;
        private boolean clearedInput;

        public GameSessionImpl(HostedConnection conn, EntityId characterEntity) {
            this.conn = conn;
            this.characterEntity = characterEntity;
            this.avatarEntity = characterEntity;
            this.backupEntity = GameSessionHostedService.this.findEntityLink("backup", this.avatarEntity);
            ShapeInfo existingShape = null;
            if (this.backupEntity != null) {
                log.info("Found:" + this.avatarEntity + " backup:" + this.backupEntity);
                existingShape = (ShapeInfo)GameSessionHostedService.this.ed.getComponent(this.backupEntity, ShapeInfo.class);
            } else {
                this.backupEntity = GameSessionHostedService.this.ed.createEntity();
                GameSessionHostedService.this.ed.setComponents(this.backupEntity, new EntityComponent[]{EntityLink.create(this.backupEntity, this.avatarEntity, "backup", GameSessionHostedService.this.ed)});
                log.info("Created:" + this.avatarEntity + " backup:" + this.backupEntity);
            }
            this.shell = ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).createChildShell(this.avatarEntity);
            this.shell.setOutput(line -> this.callback.newConsoleMessage((String)line));
            conn.setAttribute(GameSessionHostedService.ATTRIBUTE_SHELL, (Object)this.shell);
            this.shell.put("avatar", this.avatarEntity);
            this.shell.put("connection", conn);
            this.commandContext = new Context<GameSessionImpl>(this);
            this.activator = new ActivatorImpl(this, this.avatarEntity, GameSessionHostedService.this.gameSystems);
            WorldManager world = (WorldManager)GameSessionHostedService.this.gameSystems.get(WorldManager.class, true);
            SpawnPosition pos = (SpawnPosition)GameSessionHostedService.this.ed.getComponent(characterEntity, SpawnPosition.class);
            if (pos == null) {
                log.info("Player has no previous spawn position, getting it from the world...");
                this.spawnLoc = world.getInfo().getSpawnPoint();
                log.info("spawnLoc:" + this.spawnLoc);
                this.spawnLoc.y += 20.0;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, new Quatd());
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            this.spawnLoc = pos.getLocation();
            this.spawnRot = pos.getOrientation();
            if (Math.floor(this.spawnLoc.x) == this.spawnLoc.x && Math.floor(this.spawnLoc.z) == this.spawnLoc.z) {
                log.info("Adjusting spawn loc to block center");
                this.spawnLoc.x += 0.5;
                this.spawnLoc.z += 0.5;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
            GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            int elevation = world.getElevation((int)this.spawnLoc.x, (int)this.spawnLoc.z);
            log.info("spawn loc:" + this.spawnLoc + "  real elevation:" + elevation);
            ShapeInfo avatarShape = (ShapeInfo)GameSessionHostedService.this.ed.getComponent(this.avatarEntity, ShapeInfo.class);
            if (avatarShape == null) {
                avatarShape = existingShape;
            }
            if (avatarShape == null) {
                log.info("No existing shape info found for:" + this.avatarEntity + " creating default");
                avatarShape = ShapeInfo.create((String)"human/female/human-female.rig", (double)1.0, (EntityData)GameSessionHostedService.this.ed);
            }
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{new Mass(60.0), new MovementInput(new Vec3d(), this.spawnRot, 0), avatarShape});
            log.info("Adding animation config to:" + this.avatarEntity);
            EntityId anim = GameSessionHostedService.this.ed.createEntity();
            GameSessionHostedService.this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.avatarEntity, new Object[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Jog", "Swing", "SwingDownRightShoulder"}), new MixConfig("Swing")})});
            this.actionEnv = GameSessionHostedService.this.objectTypes.createEnvironment((Object)this.activator);
            this.actionEnv.setPromptProvider((PromptProvider)new UserPrompts(GameSessionHostedService.this, this));
            this.shell.setVariables(this.actionEnv.getVariables());
            this.activator.vars = this.actionEnv.getVariables();
            Account account = AccountHostedService.getAccount(conn);
            if (account == null) {
                // empty if block
            }
            this.actionEnv.setVar("account", (Object)account);
            GameSessionHostedService.this.playerEnvs.put(this.avatarEntity, this.actionEnv);
            Holding holding = (Holding)GameSessionHostedService.this.ed.getComponent(this.avatarEntity, Holding.class);
            if (holding != null && GameSessionHostedService.this.ed.getComponent(holding.getTarget(), ObjectTypeInfo.class) == null) {
                log.info("Unknown object type for held entity:" + holding.getTarget() + "  Removing holding component.");
                GameSessionHostedService.this.ed.removeComponent(this.avatarEntity, Holding.class);
            }
        }

        public String getPlayerName() {
            Name name = (Name)GameSessionHostedService.this.ed.getComponent(this.characterEntity, Name.class);
            return name.getName();
        }

        public ActionEnvironment<Activator, EntityId> getActionEnvironment() {
            return this.actionEnv;
        }

        public void initialize() {
            log.info("GameSessionImpl.initialize()");
            if (this.getCallback(false) != null) {
                this.getCallback(true).setAvatar(this.avatarEntity);
            } else {
                log.warn("No game session callback registered so can't send avatar entity.");
            }
            log.info("Spawning user at:" + this.spawnLoc);
            EtherealHost ethereal = (EtherealHost)GameSessionHostedService.this.getService(EtherealHost.class);
            ethereal.startHostingOnConnection(this.conn);
            ethereal.setConnectionObject(this.conn, Long.valueOf(this.characterEntity.getId()), this.spawnLoc);
            EntityDataHostedService eds = (EntityDataHostedService)GameSessionHostedService.this.getService(EntityDataHostedService.class);
            HostedEntityData hed = eds.getHostedEntityData(this.conn);
            if (hed == null) {
                throw new RuntimeException("Can't get hosted entity data for:" + this.conn);
            }
            hed.registerComponentVisibility((ComponentVisibility)new BodyVisibility(ethereal.getStateListener(this.conn)));
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityJoined, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
            log.info("GameSessionImpl.initialized()");
        }

        public void close() {
            log.debug("Closing game session for:" + this.conn);
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityLeaving, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
            ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).removeShell(this.avatarEntity);
            ShapeInfo shape = (ShapeInfo)GameSessionHostedService.this.ed.getComponent(this.avatarEntity, ShapeInfo.class);
            if (shape == null) {
                log.error("Player:" + this.avatarEntity + " has no shape to backup to:" + this.backupEntity);
            }
            GameSessionHostedService.this.ed.setComponent(this.backupEntity, (EntityComponent)shape);
            GameSessionHostedService.this.ed.removeComponent(this.avatarEntity, ShapeInfo.class);
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityLeft, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
            GameSessionHostedService.this.playerEnvs.remove(this.avatarEntity);
        }

        @Override
        public EntityId getCharacter() {
            return this.characterEntity;
        }

        @Override
        public EntityId getAvatar() {
            return this.avatarEntity;
        }

        @Override
        public void setMovementInput(MovementInput input) {
            this.lastMoveTime = System.currentTimeMillis();
            this.clearedInput = false;
            if (input.equals(this.lastInput)) {
                return;
            }
            try {
                boolean isDrag1;
                Holding holding = (Holding)GameSessionHostedService.this.ed.getComponent(this.avatarEntity, Holding.class);
                EntityId target = holding == null ? null : holding.getTarget();
                boolean wasDrag1 = this.lastInput == null || target == null ? false : this.lastInput.isDrag1();
                boolean bl = isDrag1 = input.isDrag1() && target != null;
                if (isDrag1) {
                    if (wasDrag1) {
                        this.actionEnv.runAction((Object)target, "swing", new Object[]{input.getFacing()});
                    } else {
                        this.actionEnv.runAction((Object)target, "startSwing", new Object[]{input.getFacing()});
                    }
                } else if (wasDrag1) {
                    this.actionEnv.runAction((Object)target, "stopSwing", new Object[]{input.getFacing()});
                }
            }
            catch (RuntimeException e) {
                log.error("Error processing swing event", (Throwable)e);
            }
            this.lastInput = input;
            GameSessionHostedService.this.ed.setComponent(this.avatarEntity, (EntityComponent)input);
        }

        public void update(SimTime time) {
            long t;
            if (!this.clearedInput && this.lastInput != null && (t = System.currentTimeMillis()) - this.lastMoveTime > 200L) {
                log.warn("Clearing input because of lag:" + this.conn + "  entity:" + this.avatarEntity);
                this.setMovementInput(EMPTY_INPUT.changeFacing(this.lastInput.getFacing()));
                this.clearedInput = true;
            }
        }

        @Override
        public void executeShell(String cmd) {
            GameSessionHostedService.this.gameSystems.enqueue(() -> {
                if (log.isTraceEnabled()) {
                    log.trace("shell push:" + this.actionEnv);
                }
                ActionEnvironment.pushCurrentEnvironment(this.actionEnv);
                try {
                    this.shell.execute(cmd);
                }
                catch (Exception e) {
                    log.error(this.conn + ":Error running command:" + cmd, (Throwable)e);
                    this.echo("Error:" + e.getMessage());
                }
                finally {
                    if (log.isTraceEnabled()) {
                        log.trace("shell pop:" + this.actionEnv);
                    }
                    ActionEnvironment.popCurrentEnvironment(this.actionEnv);
                }
                return null;
            });
        }

        @Override
        public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(cmdId);
            this.executeCommand(cmd, subject, parms);
        }

        @Override
        public void executeCommand(String cmd, EntityId subject, Object ... parms) {
            GameSessionHostedService.this.gameSystems.enqueue(() -> {
                if (log.isTraceEnabled()) {
                    log.trace("command push:" + this.actionEnv);
                }
                ActionEnvironment.pushCurrentEnvironment(this.actionEnv);
                try {
                    GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    if (log.isTraceEnabled()) {
                        log.trace("command pop:" + this.actionEnv);
                    }
                    ActionEnvironment.popCurrentEnvironment(this.actionEnv);
                }
            });
        }

        @Override
        public void runAction(EntityId target, int actionId, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(actionId);
            this.runAction(target, cmd, parms);
        }

        @Override
        public void runAction(EntityId target, String actionName, Object ... parms) {
            GameSessionHostedService.this.gameSystems.enqueue(() -> {
                try {
                    this.actionEnv.runAction((Object)target, actionName, parms);
                }
                catch (RuntimeException e) {
                    log.error("Error running action:" + actionName + " on target:" + target + " with:" + Arrays.asList(parms), (Throwable)e);
                }
                return null;
            });
        }

        @Override
        public void runActionIfExists(EntityId target, int actionId, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(actionId);
            this.runActionIfExists(target, cmd, parms);
        }

        @Override
        public void runActionIfExists(EntityId target, String actionName, Object ... parms) {
            GameSessionHostedService.this.gameSystems.enqueue(() -> {
                try {
                    this.actionEnv.runActionIfExists((Object)target, actionName, parms);
                }
                catch (RuntimeException e) {
                    log.error("Error running action:" + actionName + " on target:" + target + " with:" + Arrays.asList(parms), (Throwable)e);
                }
                return null;
            });
        }

        @Override
        public byte[] getCellArrayBytes(long id) {
            CellArray array = ((CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(new CellArrayId(id));
            return CellArrayProtocol.toBytes((CellArray)array);
        }

        @Override
        public CellArray getCellArray(CellArrayId id) {
            return ((CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(id);
        }

        @Override
        public void saveBlueprintData(BlueprintData bpData, byte[] cellArray) {
            BlueprintInfo info;
            EntityId bpEntity;
            bpData.array = CellArrayProtocol.fromBytes((byte[])cellArray);
            log.info("Need to save:" + bpData + "  bytes:" + cellArray.length);
            if (bpData.blueprintId == null) {
                bpEntity = GameSessionHostedService.this.ed.createEntity();
                info = new BlueprintInfo(this.avatarEntity, bpData.name, bpData.offset);
            } else {
                bpEntity = bpData.blueprintId;
                info = (BlueprintInfo)GameSessionHostedService.this.ed.getComponent(bpEntity, BlueprintInfo.class);
                if (info == null) {
                    log.error("BlueprintData refers to non-blueprint ID:" + bpData);
                    return;
                }
                if (!Objects.equals(info.getParent(), this.avatarEntity)) {
                    log.error("BlueprintData does not belong to this player:" + this.avatarEntity + " data:" + bpData);
                    return;
                }
                info = info.changeOffset(bpData.offset);
                info = info.changeName(bpData.name);
            }
            CellArrayStorage storage = (CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class);
            CellArrayId cellId = storage.store(bpData.array);
            Object shapeName = cellId.toFileName();
            if (bpData.carved) {
                shapeName = "c_" + (String)shapeName;
            }
            GameSessionHostedService.this.ed.setComponents(bpEntity, new EntityComponent[]{info, ObjectName.create(bpData.objectName, GameSessionHostedService.this.ed), ShapeInfo.create((String)shapeName, (double)bpData.scale, (EntityData)GameSessionHostedService.this.ed), new CreatedBy(this.avatarEntity)});
        }

        @Override
        public void saveBlueprintData(BlueprintData bpData) {
            byte[] bytes = CellArrayProtocol.toBytes((CellArray)bpData.array);
            this.saveBlueprintData(bpData, bytes);
        }

        @Override
        public void saveAssemblyBlueprintData(AssemblyBlueprintData bpData, byte[] bytes) {
            AssemblyBlueprintInfo info;
            EntityId bpEntity;
            bpData.subassembly = SubassemblyProtocol.fromBytes(bytes);
            log.info("Need to save:" + bpData + "  bytes:" + bytes.length);
            if (bpData.blueprintId == null) {
                bpEntity = GameSessionHostedService.this.ed.createEntity();
                info = new AssemblyBlueprintInfo(this.avatarEntity, bpData.name);
            } else {
                bpEntity = bpData.blueprintId;
                info = (AssemblyBlueprintInfo)GameSessionHostedService.this.ed.getComponent(bpEntity, AssemblyBlueprintInfo.class);
                if (info == null) {
                    log.error("AssemblyBlueprintData refers to non-blueprint ID:" + bpData);
                    return;
                }
                if (!Objects.equals(info.getParent(), this.avatarEntity)) {
                    log.error("AssemblyBlueprintData does not belong to this player:" + this.avatarEntity + " data:" + bpData);
                    return;
                }
                info = info.changeName(bpData.name);
            }
            SubassemblyStorage storage = (SubassemblyStorage)GameSessionHostedService.this.gameSystems.get(SubassemblyStorage.class);
            SubassemblyId asmId = storage.store(bpData.subassembly);
            String shapeName = asmId.toFileName();
            GameSessionHostedService.this.ed.setComponents(bpEntity, new EntityComponent[]{info, ObjectName.create(bpData.objectName, GameSessionHostedService.this.ed), ShapeInfo.create((String)shapeName, (double)1.0, (EntityData)GameSessionHostedService.this.ed), new CreatedBy(this.avatarEntity)});
        }

        @Override
        public void saveAssemblyBlueprintData(AssemblyBlueprintData bpData) {
            byte[] bytes = SubassemblyProtocol.toBytes(bpData.subassembly);
            this.saveAssemblyBlueprintData(bpData, bytes);
        }

        @Override
        public void saveClothingData(ClothingData cData, byte[] cellArray) {
            ClothingInfo info;
            EntityId clothingEntity;
            cData.array = CellArrayProtocol.fromBytes((byte[])cellArray);
            log.info("Need to save:" + cData + "  bytes:" + cellArray.length);
            if (cData.clothingId == null) {
                clothingEntity = GameSessionHostedService.this.ed.createEntity();
                info = new ClothingInfo(this.avatarEntity, cData.name);
            } else {
                clothingEntity = cData.clothingId;
                info = (ClothingInfo)GameSessionHostedService.this.ed.getComponent(clothingEntity, ClothingInfo.class);
                if (info == null) {
                    log.error("ClothingData refers to non-clothing ID:" + cData);
                    return;
                }
                if (!Objects.equals(info.getParent(), this.avatarEntity)) {
                    log.error("ClothingData does not belong to this player:" + this.avatarEntity + " data:" + cData);
                    return;
                }
                info = info.changeName(cData.name);
            }
            CellArrayStorage storage = (CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class);
            CellArrayId cellId = storage.store(cData.array);
            ShapeName shapeName = new ShapeName("fab", cellId.toIdString());
            GameSessionHostedService.this.ed.setComponents(clothingEntity, new EntityComponent[]{info, ObjectName.create(cData.objectName, GameSessionHostedService.this.ed), ObjectTypeInfo.create("ClothingDesign", GameSessionHostedService.this.ed), ShapeInfo.create((String)shapeName.toCompositeString(), (double)1.0, (EntityData)GameSessionHostedService.this.ed), new CreatedBy(this.avatarEntity)});
        }

        @Override
        public void saveClothingData(ClothingData cData) {
            byte[] bytes = CellArrayProtocol.toBytes((CellArray)cData.array);
            this.saveClothingData(cData, bytes);
        }

        protected void echo(String val) {
            this.shell.getOutput().accept(val);
        }

        protected GameSessionListener getCallback(boolean failFast) {
            if (this.callback == null) {
                RmiRegistry rmi = GameSessionHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (GameSessionListener)rmi.getRemoteObject(GameSessionListener.class);
                if (this.callback == null) {
                    if (failFast) {
                        throw new RuntimeException("Unable to locate client callback for GameSessionListener");
                    }
                    log.warn("Unable to locate client callback for GameSessionListener");
                }
            }
            return this.callback;
        }
    }

    private class RecordCommand
    implements Command<GameSessionImpl, EntityId> {
        private RecordCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).record(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class PlayCommand
    implements Command<GameSessionImpl, EntityId> {
        private PlayCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).play(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class StopCommand
    implements Command<GameSessionImpl, EntityId> {
        private StopCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                long duration = ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).stop(subject);
                context.getSource().echo(String.format("%.02f", (double)duration / 1.0E9));
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class ActivateCommand
    implements Command<GameSessionImpl, EntityId> {
        private ActivateCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info(this.getClass().getSimpleName() + "(" + cmd + ", " + Arrays.asList(parms) + ")");
            log.info("parms[0] class:" + parms[0].getClass());
            boolean pressed = Boolean.TRUE.equals(parms[0]);
            if ("activatePrimary".equals(cmd)) {
                throw new UnsupportedOperationException();
            }
            if ("activatePrimaryAlt".equals(cmd)) {
                throw new UnsupportedOperationException();
            }
            if ("activateSecondary".equals(cmd)) {
                if (!pressed) {
                    return;
                }
                log.info("-------------------recalculating lighting----------");
                Iterator<BlockIterator.Intersection> it = context.getSource().activator.pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    DefaultWorld world = (DefaultWorld)GameSessionHostedService.this.gameSystems.get(World.class);
                    ColumnId colId = ColumnId.fromWorld((Vec3d)intersect.getPoint());
                    long start = System.nanoTime();
                    world.recalculateLighting(colId);
                    long end = System.nanoTime();
                    context.getSource().echo(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
                    log.info("-------------------Done: recalculating lighting----------");
                }
            } else {
                context.getSource().echo("Unknown command:" + cmd);
            }
        }
    }

    public static class ActivatorImpl
    implements Activator {
        private GameSessionImpl session;
        private EntityData ed;
        private EntityId entity;
        private BodyPosition bPos;
        private MBlockCollisionSystem collisionSystem;
        private Map<String, Object> vars;

        public ActivatorImpl(GameSessionImpl session, EntityId entity, GameSystemManager gameSystems) {
            this.session = session;
            this.entity = entity;
            this.collisionSystem = (MBlockCollisionSystem)((MPhysSystem)gameSystems.get(MPhysSystem.class, true)).getCollisionSystem();
            this.ed = (EntityData)gameSystems.get(EntityData.class, true);
        }

        @Override
        public EntityId getId() {
            return this.entity;
        }

        private BodyPosition getBodyPosition() {
            if (this.bPos == null) {
                this.bPos = this.getAt(BodyPosition.class);
            }
            return this.bPos;
        }

        @Override
        public Vec3d getEyePos() {
            Vec3d pos = this.getPos();
            return pos.add(0.0, 1.5, 0.0);
        }

        @Override
        public Vec3d getPos() {
            return this.getBodyPosition().getLastLocation();
        }

        @Override
        public Vec3d getLookDir() {
            return this.getLookOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Vec3d getDir() {
            return this.getOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Quatd getLookOrientation() {
            MovementInput mi = this.getAt(MovementInput.class);
            if (mi == null) {
                return null;
            }
            return mi.getFacing();
        }

        @Override
        public Quatd getOrientation() {
            return this.getBodyPosition().getLastOrientation();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick() {
            Rayd ray = new Rayd(this.getEyePos(), this.getLookDir());
            return this.collisionSystem.rayIterator(ray, 10.0);
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick(Rayd ray, double limit) {
            return this.collisionSystem.rayIterator(ray, limit);
        }

        @Override
        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(this.ed.getComponent(this.entity, type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }

        @Override
        public Object getProperty(String name) {
            if (log.isDebugEnabled()) {
                log.debug("getProperty(" + name + ")");
            }
            return this.vars.get(name);
        }

        @Override
        public void setProperty(String name, Object newValue) {
            if (log.isDebugEnabled()) {
                log.debug("setProperty(" + name + ", " + newValue + ")");
            }
            this.vars.put(name, newValue);
        }

        public void openContainer(EntityId target) {
            this.session.getCallback(true).openContainer(target);
        }

        public void closeContainer(EntityId target) {
            this.session.getCallback(true).closeContainer(target);
        }
    }

    private class UserPrompts
    implements PromptProvider<Activator, EntityId> {
        private GameSessionImpl session;

        public UserPrompts(GameSessionHostedService gameSessionHostedService, GameSessionImpl session) {
            this.session = session;
        }

        public void showPrompt(EntityId target, PromptType type, String prompt) {
            this.session.getCallback(true).showPrompt(target, type, prompt);
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options) {
            this.session.getCallback(true).showOptions(target, options);
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options, Option<EntityId> closeOption) {
            this.session.getCallback(true).showOptions(target, options, closeOption);
        }
    }
}

