/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.Frustum;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.QueryFilter;
import com.simsilica.mphys.QueryVolume;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.SphereVolume;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.es.AgentType;
import mythruna.sim.ai.Agent;
import mythruna.sim.ai.AgentChatProvider;
import mythruna.sim.ai.AgentMovementInput;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.PerceptionSet;
import mythruna.sim.ai.RigAnimator;
import mythruna.sim.ai.RigidBodyMover;
import mythruna.sim.ai.SteeringPrimitive;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentDriver
extends AbstractControlDriver<EntityId, MBlockShape>
implements Agent {
    static Logger log = LoggerFactory.getLogger(AgentDriver.class);
    private MPhysSystem<MBlockShape> physics;
    private EntityData ed;
    private EntityId agent;
    private AgentType type;
    private AgentChatProvider chatProvider;
    private double upThreshold = 0.7;
    private boolean enabled = true;
    private boolean flying = false;
    private int groundContactCount = 0;
    private Vec3d groundVelocity = new Vec3d();
    private EntityId groundEntity;
    private boolean onGround = false;
    private boolean blocked = true;
    private Vec3d lastPosition = new Vec3d();
    private Vec3d actualVelocity = new Vec3d();
    private double[] angles = new double[3];
    private ContactAvoidance nearContactSteering;
    private Brain brain;
    private Probe probe;
    private SteeringPrimitive steer;
    private RigidBodyMover mover;
    private AgentMovementInput movementInput = new AgentMovementInput();
    private AgentMovementInput probeMovementInput = new AgentMovementInput();
    private RigAnimator rigAnimator;
    private MBlockShape nearPerception;
    private MBlockShape farPerception;
    private Vec3d warpTo;
    private Frustum sightVolume;
    private PerceptionSet sightPerception;
    private AttachmentPoint eyeAttachment;
    private SphereVolume spaceVolume;
    private PerceptionSet personalSpace;
    private AttachmentPoint cogAttachment;
    public boolean debugAgent = false;
    private long nextSpawnUpdateTime = 0L;
    private long updateInterval = 5000000000L;

    public AgentDriver(MPhysSystem<MBlockShape> physics, AgentChatProvider chatProvider, EntityId agent) {
        this.physics = physics;
        this.ed = physics.getEntityData();
        this.agent = agent;
        this.chatProvider = chatProvider;
        this.brain = new Brain(this.ed, this);
        double yRads = Math.toRadians(20.0);
        double xRads = Math.toRadians(60.0);
        this.sightVolume = new Frustum(16.0, xRads, yRads);
        this.sightPerception = new PerceptionSet((QueryVolume)this.sightVolume, (PhysicsSpace<EntityId, MBlockShape>)physics.getPhysicsSpace());
        this.sightPerception.setSkip(agent);
        this.spaceVolume = new SphereVolume(new Vec3d(), 2.0);
        this.personalSpace = new PerceptionSet((QueryVolume)this.spaceVolume, (PhysicsSpace<EntityId, MBlockShape>)physics.getPhysicsSpace());
        this.personalSpace.setSkip(agent);
    }

    public RigidBody<EntityId, MBlockShape> getAgentBody() {
        return super.getBody();
    }

    public Frustum getSightVolume() {
        return this.sightVolume;
    }

    public SphereVolume getPersonalSpaceVolume() {
        return this.spaceVolume;
    }

    public PerceptionSet getSightPerceptionSet() {
        return this.sightPerception;
    }

    public PerceptionSet getPersonalSpaceSet() {
        return this.personalSpace;
    }

    public Brain getBrain() {
        return this.brain;
    }

    @Override
    public EntityId getEntityId() {
        return this.agent;
    }

    public AgentChatProvider getChatProvider() {
        return this.chatProvider;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setFlying(boolean flying) {
        if (this.flying == flying) {
            return;
        }
        this.flying = flying;
        if (this.mover != null) {
            this.mover.setFlying(flying);
        }
        if (this.rigAnimator != null) {
            this.rigAnimator.setFlying(flying);
        }
    }

    public boolean isFlying() {
        return this.flying;
    }

    @Override
    public Vec3d getLocation() {
        return this.getBody().position;
    }

    @Override
    public Quatd getOrientation() {
        return this.getBody().orientation;
    }

    @Override
    public Vec3d getLinearVelocity() {
        return this.getBody().getLinearVelocity().subtract(this.groundVelocity);
    }

    public Vec3d getProbeOffset() {
        return this.probe.offset;
    }

    public double getProbeRadius() {
        return this.probe.radius;
    }

    public void setNearPerception(Vec3d offset, double radius) {
        this.nearPerception = MBlockShape.createGhost((double)radius);
        this.nearPerception.getPart().setLocalPosition(offset);
    }

    public void setFarPerception(Vec3d offset, double radius) {
        this.farPerception = MBlockShape.createGhost((double)radius);
        this.farPerception.getPart().setLocalPosition(offset);
    }

    public List<RigidBody<EntityId, MBlockShape>> queryNearBodies() {
        RigidBody body = this.getBody();
        QueryFilter filter = new QueryFilter(12);
        ContactResults contacts = new ContactResults();
        this.physics.getPhysicsSpace().queryContacts(body.position, body.orientation, (AbstractShape)this.nearPerception, filter, (ContactListener)contacts);
        ArrayList<RigidBody<EntityId, MBlockShape>> bodies = new ArrayList<RigidBody<EntityId, MBlockShape>>();
        for (Contact<EntityId, MBlockShape> c : contacts) {
            if (c.body1 != body && c.body1 != null && c.body1.id != null && c.body1 instanceof RigidBody) {
                bodies.add((RigidBody<EntityId, MBlockShape>)c.body1);
                continue;
            }
            if (c.body2 == body || c.body2 == null || c.body2.id == null || !(c.body2 instanceof RigidBody)) continue;
            bodies.add((RigidBody<EntityId, MBlockShape>)((RigidBody)c.body2));
        }
        return bodies;
    }

    public List<RigidBody<EntityId, MBlockShape>> queryFarBodies() {
        RigidBody body = this.getBody();
        QueryFilter filter = new QueryFilter(12);
        ContactResults contacts = new ContactResults();
        this.physics.getPhysicsSpace().queryContacts(body.position, body.orientation, (AbstractShape)this.farPerception, filter, (ContactListener)contacts);
        ArrayList<RigidBody<EntityId, MBlockShape>> bodies = new ArrayList<RigidBody<EntityId, MBlockShape>>();
        for (Contact<EntityId, MBlockShape> c : contacts) {
            if (c.body1 != body && c.body1 != null && c.body1.id != null && c.body1 instanceof RigidBody) {
                bodies.add((RigidBody<EntityId, MBlockShape>)c.body1);
                continue;
            }
            if (c.body2 == body || c.body2 == null || c.body2.id == null || !(c.body2 instanceof RigidBody)) continue;
            bodies.add((RigidBody<EntityId, MBlockShape>)((RigidBody)c.body2));
        }
        return bodies;
    }

    public boolean isInFarRange(Vec3d loc) {
        RigidBody body = this.getBody();
        Vec3d center = body.position.add(this.farPerception.getPart().getLocalPosition());
        double radius = this.farPerception.getBoundsRadius();
        double radiusSq = radius * radius;
        double distSq = loc.distanceSq(center);
        return distSq <= radiusSq;
    }

    public void initialize(RigidBody<EntityId, MBlockShape> body) {
        super.initialize(body);
        if (body == null) {
            log.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"initialize(null)"})));
        } else {
            log.info("initialize(" + body.id + ")");
        }
        body.setLinearDamping(0.999);
        if (body.shape instanceof RigShape) {
            RigShape rig = (RigShape)body.shape;
            this.rigAnimator = new RigAnimator(rig, 0.7, 0.7, this.flying);
            if (log.isTraceEnabled()) {
                log.trace("rig shape:" + rig);
            }
            this.rigAnimator.human = rig.hasAction("Jog");
            if (log.isTraceEnabled()) {
                log.trace("init: set human to:" + this.rigAnimator.human);
            }
            this.eyeAttachment = rig.getAttachmentPoint("eye");
            if (this.eyeAttachment == null && log.isTraceEnabled()) {
                log.trace("shape has no eye:" + ((ShapeInfo)this.ed.getComponent(this.agent, ShapeInfo.class)).toString(this.ed));
            }
            this.cogAttachment = rig.getAttachmentPoint("com");
            if (this.cogAttachment == null) {
                log.warn("shape has no com:" + ((ShapeInfo)this.ed.getComponent(this.agent, ShapeInfo.class)).toString(this.ed));
            }
        }
        this.lastPosition.set(body.position);
        this.steer = SteeringPrimitives.constant(0.0, 0.0, 0.0);
        this.mover = new RigidBodyMover(body, this.flying);
        this.nearContactSteering = new ContactAvoidance();
        this.warpTo = this.brain.getInitialPosition();
        if (this.type != null) {
            this.updateType(this.type);
        }
    }

    public void setSteering(SteeringPrimitive steer) {
        this.steer = steer;
    }

    public void setDefaultAction(String action) {
        if (this.rigAnimator == null) {
            log.warn("No rigAnimator found, not setting default action");
            return;
        }
        this.rigAnimator.setDefaultAction(action);
    }

    public String getDefaultAction() {
        return this.rigAnimator == null ? null : this.rigAnimator.getDefaultAction();
    }

    public AgentType getAgentType() {
        return this.type;
    }

    public void changeAgentType(AgentType type) {
        if (log.isTraceEnabled()) {
            log.trace("changeAgentType(" + type + ")");
        }
        if (Objects.equals(this.type, type)) {
            return;
        }
        this.type = type;
        if (this.getBody() != null) {
            this.updateType(type);
        }
    }

    protected void updateType(AgentType type) {
        String typeString;
        ComponentFilter filter = Filters.fieldEquals(AnimationConfig.class, (String)"target", (Object)this.agent);
        EntityId anim = this.ed.findEntity(filter, new Class[]{AnimationConfig.class});
        if (anim == null) {
            log.info("Creating new anim entity...");
            anim = this.ed.createEntity();
        }
        if ("Gaefen".equals(typeString = type.getTypeName(this.ed))) {
            log.info("setting up gaefen animation config for:" + this.agent);
            this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.agent, new Object[]{new LayerConfig(null, new String[]{"Eat", "Idle", "Walk", "Run"})})});
            RigShape rig = (RigShape)this.getBody().shape;
            this.rigAnimator = new RigAnimator(rig, 0.7, 0.7, this.flying);
            this.probe = new Probe(new Vec3d(0.0, 0.25, 0.5), 0.25);
            if (this.rigAnimator != null) {
                this.rigAnimator.human = false;
            }
            this.sightVolume.setFar(3.0);
            this.sightVolume.setHorizontalFov(Math.toRadians(50.0));
            this.sightVolume.setVerticalFov(Math.toRadians(20.0));
            this.spaceVolume.setRadius(2.0);
        } else if ("Bird".equals(typeString)) {
            log.info("setting up bird animation config for:" + this.agent);
            this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.agent, new Object[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Jog", "Run"})})});
            RigShape rig = (RigShape)this.getBody().shape;
            this.rigAnimator = new RigAnimator(rig, 0.7, 4.0, this.flying);
            this.rigAnimator.walkMultiplier = 2.0;
            this.rigAnimator.jogMultiplier = 1.0;
            this.probe = new Probe(new Vec3d(0.0, 0.25, 0.5), 0.25);
            if (this.rigAnimator != null) {
                this.rigAnimator.human = false;
            }
            this.sightVolume.setFar(3.0);
            this.sightVolume.setHorizontalFov(Math.toRadians(50.0));
            this.sightVolume.setVerticalFov(Math.toRadians(20.0));
            this.spaceVolume.setRadius(2.0);
        } else if ("Butterfly".equals(typeString)) {
            log.info("setting up butterfly animation config for:" + this.agent);
            this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.agent, new Object[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Run"})})});
            RigShape rig = (RigShape)this.getBody().shape;
            this.rigAnimator = new RigAnimator(rig, 0.7, 0.7, this.flying);
            this.rigAnimator.walkMultiplier = 1.5;
            this.rigAnimator.runMultiplier = 1.5;
            this.mover.setDefaultGravity(GameConstants.WATER_GRAVITY);
            this.probe = new Probe(new Vec3d(0.0, 0.15, 0.15), 0.1);
            if (this.rigAnimator != null) {
                this.rigAnimator.human = false;
            }
            this.sightVolume.setFar(0.0);
            this.sightVolume.setHorizontalFov(0.0);
            this.sightVolume.setVerticalFov(0.0);
            this.spaceVolume.setRadius(0.25);
            this.setFlying(true);
        } else if ("Dog".equals(typeString)) {
            log.info("setting up Dog animation config for:" + this.agent);
            this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.agent, new Object[]{new LayerConfig(null, new String[]{"Idle", "Idle2", "Walk", "Run"})})});
            RigShape rig = (RigShape)this.getBody().shape;
            this.rigAnimator = new RigAnimator(rig, 5.0, 5.0, this.flying);
            this.probe = new Probe(new Vec3d(0.0, 0.5, 0.5), 0.25);
            this.sightVolume.setFar(12.0);
            this.sightVolume.setHorizontalFov(Math.toRadians(60.0));
            this.sightVolume.setVerticalFov(Math.toRadians(30.0));
            this.spaceVolume.setRadius(2.0);
            if (this.rigAnimator != null) {
                this.rigAnimator.human = false;
            }
        } else if ("Basic NPC".equals(typeString)) {
            log.info("setting up basic NPC animation config for:" + this.agent);
            this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.agent, new Object[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Jog"})})});
            this.probe = new Probe(new Vec3d(0.0, 0.5, 0.5), 0.25);
            this.sightVolume.setFar(24.0);
            this.sightVolume.setHorizontalFov(Math.toRadians(40.0));
            this.sightVolume.setVerticalFov(Math.toRadians(30.0));
            this.spaceVolume.setRadius(1.5);
            if (this.rigAnimator != null) {
                this.rigAnimator.human = true;
            }
        }
        if (this.brain != null) {
            this.brain.setAgentType(typeString, type.getLevel());
        }
    }

    public void newContact(Contact<EntityId, MBlockShape> contact) {
        RigidBody body = this.getBody();
        contact.friction = 0.01;
        double upness = Vec3d.UNIT_Y.dot(contact.contactNormal);
        if (upness < this.upThreshold) {
            Vec3d dir = body.orientation.mult(Vec3d.UNIT_Z);
            double front = dir.dot(contact.contactNormal);
            if (front < 0.0) {
                this.blocked = true;
                this.nearContactSteering.newContact(contact);
            }
            return;
        }
        this.onGround = true;
        RigidBody other = null;
        if (contact.body1 == body) {
            if (contact.body2 instanceof RigidBody) {
                other = (RigidBody)contact.body2;
            }
        } else if (contact.body2 == body && contact.body1 instanceof RigidBody) {
            other = contact.body1;
        }
        if (other != null) {
            this.groundVelocity.addLocal(other.getLinearVelocity());
            ++this.groundContactCount;
            this.groundEntity = (EntityId)other.id;
        }
    }

    protected void calculateCollisionData() {
        if (this.groundContactCount > 0) {
            this.groundVelocity.multLocal(1.0 / (double)this.groundContactCount);
            if (log.isDebugEnabled()) {
                log.debug("walk: groundVelocity:" + this.groundVelocity);
            }
        }
    }

    protected void invalidateCollisionData() {
        this.groundEntity = null;
        this.groundContactCount = 0;
        this.groundVelocity.set(0.0, 0.0, 0.0);
        this.onGround = false;
        this.blocked = false;
        this.lastPosition.set(this.getBody().position);
        this.nearContactSteering.reset();
    }

    protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
        body.orientation.toAngles(this.angles);
        if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
            this.angles[0] = 0.0;
            this.angles[2] = 0.0;
            body.orientation.fromAngles(this.angles);
        }
        Vec3d rot = body.getRotationalVelocity();
        if (rot.x != 0.0 || rot.z != 0.0) {
            rot.x = 0.0;
            rot.z = 0.0;
            body.setRotationalVelocity(rot);
        }
        if (body.position.y < 0.0) {
            body.position.y = 700.0;
        }
    }

    public void update(long frameTime, double step) {
        Quatd worldRot;
        Vec3d bodyRelative;
        if (!this.enabled) {
            return;
        }
        if (this.warpTo != null) {
            log.info("Warping to:" + this.warpTo);
            this.physics.getPhysicsSpace().teleport((Object)this.agent, this.warpTo, new Quatd());
            this.warpTo = null;
            return;
        }
        RigidBody body = this.getBody();
        if (log.isTraceEnabled()) {
            log.trace("update(" + step + ")  temperature:" + body.getTemperature());
        }
        if (this.debugAgent) {
            log.info("update(" + step + ")  temperature:" + body.getTemperature());
        }
        this.calculateCollisionData();
        this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)body);
        if (this.eyeAttachment != null) {
            this.eyeAttachment.update();
            bodyRelative = ((MBlockShape)body.shape).shapeToBody(this.eyeAttachment.getTranslation(), null);
            worldRot = body.orientation.mult(this.eyeAttachment.getRotation());
            this.sightVolume.set(body.localToWorld(bodyRelative, null), worldRot);
        } else {
            this.sightVolume.set(body.position.add(0.0, 0.8, 0.0), body.orientation);
        }
        this.sightPerception.update(step);
        if (this.cogAttachment != null) {
            this.cogAttachment.update();
            bodyRelative = ((MBlockShape)body.shape).shapeToBody(this.cogAttachment.getTranslation(), null);
            worldRot = body.orientation.mult(this.cogAttachment.getRotation());
            this.spaceVolume.setPosition(body.localToWorld(bodyRelative, null));
        } else {
            this.spaceVolume.setPosition(body.position.add(0.0, 0.8, 0.0));
        }
        this.personalSpace.update(step);
        if (step > 0.0) {
            this.actualVelocity.set(body.position);
            this.actualVelocity.subtractLocal(this.lastPosition);
            if (this.actualVelocity.lengthSq() < 4.0E-6) {
                this.actualVelocity.set(0.0, 0.0, 0.0);
            }
            this.actualVelocity.multLocal(1.0 / step);
        } else {
            this.actualVelocity.set(body.getLinearVelocity());
        }
        this.actualVelocity.subtractLocal(this.groundVelocity);
        this.brain.update(frameTime, step);
        this.movementInput.clear();
        this.probeMovementInput.clear();
        this.steer.calculateSteering(this.movementInput);
        if (this.debugAgent) {
            log.info("steer:" + this.steer);
            log.info("steer output:" + this.movementInput.move);
        }
        if (this.nearContactSteering.calculateSteering(this.probeMovementInput)) {
            if (this.debugAgent) {
                log.info("--------- avoiding ----------");
            }
            s = this.movementInput.move;
            p = this.probeMovementInput.move;
            if (this.debugAgent) {
                log.info("blocked s:" + s + "  p:" + p);
            }
            if (s.x < 0.0 && p.x < 0.0) {
                this.movementInput.move.x = Math.min(s.x, p.x);
            } else if (s.x > 0.0 && p.x > 0.0) {
                this.movementInput.move.x = Math.max(s.x, p.x);
            } else if (p.x != 0.0) {
                this.movementInput.move.x = p.x;
            }
            if (Math.abs(this.probeMovementInput.move.z) > 0.0) {
                this.movementInput.move.z = s.z * p.z;
            }
        } else if (this.probe != null) {
            if (this.debugAgent) {
                log.info("--------- probing ----------");
            }
            this.probe.reset();
            this.physics.getPhysicsSpace().queryContacts(this.probe.position, this.probe.orientation, (AbstractShape)this.probe.shape, this.probe.filter, (ContactListener)this.probe);
            if (this.probe.calculateSteering(this.probeMovementInput)) {
                s = this.movementInput.move;
                p = this.probeMovementInput.move;
                if (s.x < 0.0 && p.x < 0.0) {
                    this.movementInput.move.x = Math.min(s.x, p.x);
                } else if (s.x > 0.0 && p.x > 0.0) {
                    this.movementInput.move.x = Math.max(s.x, p.x);
                } else if (p.x != 0.0) {
                    this.movementInput.move.x = p.x;
                }
                if (Math.abs(this.probeMovementInput.move.z) > 0.0) {
                    this.movementInput.move.z = s.z * p.z;
                }
            }
        }
        if (this.blocked && this.debugAgent) {
            log.info("**** Blocked ****");
        }
        if (this.debugAgent) {
            log.info("movementInput:" + this.movementInput.move + "   actualVelocity:" + this.actualVelocity);
        }
        this.mover.steer(this.movementInput, this.actualVelocity, this.onGround, step);
        if (this.rigAnimator != null) {
            this.rigAnimator.update(this.movementInput, this.actualVelocity, this.onGround, step);
        }
        body.wakeUp(true);
        if (this.debugAgent) {
            log.info("wakeup body:" + body.id);
        }
        this.invalidateCollisionData();
        if (frameTime > this.nextSpawnUpdateTime) {
            this.nextSpawnUpdateTime = frameTime + this.updateInterval;
            Vec3d wPos = ((MBlockShape)body.shape).getWorldShapeOrigin((AbstractBody)body);
            this.ed.setComponent(this.agent, (EntityComponent)new SpawnPosition(GameConstants.PHYSICS_GRID, wPos, body.orientation));
        }
    }

    private class Probe
    implements ContactListener<EntityId, MBlockShape> {
        private MBlockShape shape;
        private double radius;
        private Vec3d offset;
        private Quatd orientation = new Quatd();
        private QueryFilter<EntityId, MBlockShape> filter = new QueryFilter(255);
        private Vec3d position = new Vec3d();
        private ContactAvoidance avoidance = new ContactAvoidance();

        public Probe(Vec3d offset, double radius) {
            this.radius = radius;
            this.shape = MBlockShape.createGhost((double)radius);
            this.offset = offset;
        }

        public boolean calculateSteering(AgentMovementInput target) {
            return this.avoidance.calculateSteering(target);
        }

        public void reset() {
            if (this.offset != null) {
                AgentDriver.this.getBody().localToWorld(this.offset, this.position);
            }
            this.avoidance.reset();
        }

        public void newContact(Contact<EntityId, MBlockShape> contact) {
            if (contact.body1 == AgentDriver.this.getBody() || contact.body2 == AgentDriver.this.getBody()) {
                return;
            }
            this.avoidance.newContact(contact);
        }
    }

    private static class ContactResults
    implements ContactListener<EntityId, MBlockShape>,
    Iterable<Contact<EntityId, MBlockShape>> {
        private List<Contact<EntityId, MBlockShape>> results = new ArrayList<Contact<EntityId, MBlockShape>>();

        @Override
        public Iterator<Contact<EntityId, MBlockShape>> iterator() {
            return this.results.iterator();
        }

        public void newContact(Contact<EntityId, MBlockShape> contact) {
            this.results.add(contact);
        }
    }

    private class ContactAvoidance
    implements SteeringPrimitive,
    ContactListener<EntityId, MBlockShape> {
        private Vec3d dir = new Vec3d();
        private Vec3d left = new Vec3d();
        private double minDistanceSq;
        private Contact<EntityId, MBlockShape> closest;
        private double forward;
        private double side;
        private Vec3d relative = new Vec3d();
        private List<Contact<EntityId, MBlockShape>> contacts = new ArrayList<Contact<EntityId, MBlockShape>>();

        public void reset() {
            this.minDistanceSq = Double.POSITIVE_INFINITY;
            this.closest = null;
            ((AgentDriver)AgentDriver.this).getBody().orientation.mult(Vec3d.UNIT_Z, this.dir);
            ((AgentDriver)AgentDriver.this).getBody().orientation.mult(Vec3d.UNIT_X, this.left);
            this.side = 0.0;
            this.forward = 0.0;
            this.contacts.clear();
        }

        public void newContact(Contact<EntityId, MBlockShape> contact) {
            this.contacts.add(contact);
            this.relative.set(contact.contactPoint).subtractLocal(((AgentDriver)AgentDriver.this).getBody().position);
            double facing = contact.contactNormal.dot(this.relative);
            if (facing > 0.0) {
                return;
            }
            double fwd = this.relative.dot(this.dir);
            if (fwd < 0.0) {
                return;
            }
            double distSq = contact.contactPoint.distanceSq(((AgentDriver)AgentDriver.this).getBody().position);
            if (distSq < this.minDistanceSq) {
                this.closest = contact;
                this.minDistanceSq = distSq;
                this.side = this.relative.dot(this.left);
                this.forward = fwd;
            }
        }

        @Override
        public boolean calculateSteering(AgentMovementInput target) {
            if (this.forward > 0.0) {
                double steer = Math.min(1.0, 1.0 - Math.abs(this.side));
                if (this.side > 0.0) {
                    steer *= -1.0;
                }
                target.move.set(steer, 0.0, 0.8);
                return true;
            }
            return false;
        }
    }
}

