/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.mathd.Vec3d;
import java.util.Random;
import mythruna.sim.ai.AgentDriver;
import mythruna.sim.ai.AgentMovementInput;
import mythruna.sim.ai.SteeringPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SteeringPrimitives {
    static Logger log = LoggerFactory.getLogger(SteeringPrimitives.class);
    private static final double TWO_PI = Math.PI * 2;

    public static SteeringPrimitive constant(double x, double y, double z) {
        return new Constant(x, y, z);
    }

    public static SteeringPrimitive wander(double distance, double radius, double rate) {
        return SteeringPrimitives.wander(null, distance, radius, rate);
    }

    public static SteeringPrimitive wander(Random rand, double distance, double radius, double rate) {
        return new Wander(rand, distance, radius, rate);
    }

    public static Arrive arrive(AgentDriver agent, Vec3d location, double distance) {
        return new Arrive(agent, location, distance);
    }

    public static SteeringPrimitive scaleSpeed(SteeringPrimitive delegate, double scale) {
        return new ScaleSpeed(delegate, scale);
    }

    public static SteeringPrimitive faceLocation(AgentDriver agent, Vec3d location) {
        return new Face(agent, location);
    }

    private static class Constant
    implements SteeringPrimitive {
        private double x;
        private double y;
        private double z;

        public Constant(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean calculateSteering(AgentMovementInput target) {
            target.move.set(this.x, this.y, this.z);
            return true;
        }
    }

    private static class Wander
    implements SteeringPrimitive {
        private Random rand;
        private double distance;
        private double radius;
        private double rate;
        private double angle = 0.0;
        private Vec3d seekTarget = new Vec3d();

        public Wander(Random rand, double distance, double radius, double rate) {
            this.rand = rand;
            this.distance = distance;
            this.radius = radius;
            this.rate = rate;
        }

        protected void resetSeekTarget() {
            double cos = Math.cos(this.angle);
            double sin = Math.sin(this.angle);
            this.seekTarget.set(0.0, 0.0, this.distance);
            this.seekTarget.addLocal(sin * this.radius, 0.0, cos * this.radius);
        }

        @Override
        public boolean calculateSteering(AgentMovementInput target) {
            double r = this.rand != null ? this.rand.nextDouble() : Math.random();
            this.angle += (r -= 0.5) * this.rate;
            if (this.angle < 0.0) {
                this.angle += Math.PI * 2;
            } else if (this.angle > Math.PI * 2) {
                this.angle -= Math.PI * 2;
            }
            this.resetSeekTarget();
            Vec3d dir = this.seekTarget.normalize();
            double turn = dir.x;
            if (dir.z < 0.0) {
                turn = Math.signum(dir.x);
            }
            if (Math.abs(turn - target.move.x) > 0.001) {
                target.move.x = turn;
                target.move.z = 1.0;
                return true;
            }
            return false;
        }
    }

    public static class Arrive
    implements SteeringPrimitive {
        private AgentDriver agent;
        private Vec3d target;
        private double distance;
        private double distanceSq;

        public Arrive(AgentDriver agent, Vec3d location, double distance) {
            this.agent = agent;
            this.target = location;
            this.distance = distance;
            this.distanceSq = distance * distance;
        }

        public void setTarget(Vec3d target) {
            this.target = target;
        }

        public Vec3d getTarget() {
            return this.target;
        }

        @Override
        public boolean calculateSteering(AgentMovementInput movement) {
            Vec3d dir = this.agent.getOrientation().mult(Vec3d.UNIT_Z);
            Vec3d left = this.agent.getOrientation().mult(Vec3d.UNIT_X);
            Vec3d up = this.agent.getOrientation().mult(Vec3d.UNIT_Y);
            Vec3d loc = this.agent.getLocation();
            Vec3d relative = this.target.subtract(loc);
            if (relative.lengthSq() < this.distanceSq) {
                return false;
            }
            double targetDistance = relative.length();
            Vec3d targetDir = relative.mult(1.0 / targetDistance);
            if (targetDistance < 2.0 * this.distance) {
                double scale = (targetDistance - this.distance) / this.distance;
                movement.move.z = 0.25 + scale * 0.75;
            } else {
                movement.move.z = 1.0;
            }
            double fwd = dir.dot(targetDir);
            double upDown = up.dot(targetDir);
            double turn = left.dot(targetDir);
            if (fwd < 0.0) {
                turn = turn != 0.0 ? Math.signum(turn) : 1.0;
                movement.move.z *= 0.25;
            }
            movement.move.x = turn;
            return true;
        }
    }

    private static class ScaleSpeed
    implements SteeringPrimitive {
        private SteeringPrimitive delegate;
        private double scale;

        public ScaleSpeed(SteeringPrimitive delegate, double scale) {
            this.delegate = delegate;
            this.scale = scale;
        }

        @Override
        public boolean calculateSteering(AgentMovementInput target) {
            if (this.delegate.calculateSteering(target)) {
                target.move.z *= this.scale;
                return true;
            }
            return false;
        }
    }

    private static class Face
    implements SteeringPrimitive {
        private AgentDriver agent;
        private Vec3d target;

        public Face(AgentDriver agent, Vec3d location) {
            this.agent = agent;
            this.target = location;
        }

        @Override
        public boolean calculateSteering(AgentMovementInput movement) {
            Vec3d dir = this.agent.getOrientation().mult(Vec3d.UNIT_Z);
            Vec3d left = this.agent.getOrientation().mult(Vec3d.UNIT_X);
            Vec3d loc = this.agent.getLocation();
            Vec3d targetDir = this.target.subtract(loc).normalizeLocal();
            movement.move.z = 0.0;
            double fwd = dir.dot(targetDir);
            double turn = left.dot(targetDir);
            if (fwd < 0.0) {
                turn = turn != 0.0 ? Math.signum(turn) : 1.0;
            }
            movement.move.x = turn;
            return true;
        }
    }
}

