/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.lemur.style.ElementId;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.SpatialComponent;
import mythruna.client.ui.assembly.AssemblyEditorState;
import mythruna.es.AssemblyBlueprintInfo;
import mythruna.es.ObjectName;
import mythruna.net.AssemblyBlueprintData;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblySelectorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(AssemblySelectorState.class);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private Container window;
    private ActionButton editButton;
    private ActionButton copyButton;
    private ActionButton deleteButton;
    private AssemblyContainer designs;
    private VersionedList<Design> designModel = new VersionedList();
    private ListBox<Design> designList;
    private VersionedReference<Integer> selectionRef;
    private Design selectedDesign;
    private AssemblyBlueprintData editing = null;
    private HelpPopup help;

    public AssemblySelectorState() {
        this.setEnabled(false);
    }

    protected void resetEditing() {
        log.info("resetEditing:" + this.editing);
        if (this.editing == null) {
            log.info("AssemblyEditorState setting enabled false");
            ((AssemblyEditorState)this.getState(AssemblyEditorState.class)).setEnabled(false);
            this.show();
        } else {
            ((AssemblyEditorState)this.getState(AssemblyEditorState.class)).editDesign(this.editing);
            this.hide();
        }
    }

    protected void newDesign() {
        log.info("Setting new editing");
        this.editing = new AssemblyBlueprintData(null, "New Design", "Object", new Subassembly("base", null));
        this.resetEditing();
    }

    protected void editDesign() {
        if (this.selectedDesign == null) {
            return;
        }
        if (this.selectedDesign.subassembly == null) {
            log.error("Design subassembly is null:" + this.selectedDesign);
            ((GuiState)this.getState(GuiState.class)).showError("Invalid Design", "Selected design has no data.");
            return;
        }
        AssemblyBlueprintInfo info = this.selectedDesign.bpInfo;
        String bpName = info.getName();
        String objectName = this.selectedDesign.objectName.getName(this.ed);
        log.info("Setting edit editing");
        this.editing = new AssemblyBlueprintData(this.selectedDesign.entity.getId(), bpName, objectName, this.selectedDesign.subassembly);
        this.resetEditing();
    }

    protected void copyDesign() {
        if (this.selectedDesign == null) {
            return;
        }
        AssemblyBlueprintInfo info = this.selectedDesign.bpInfo;
        String bpName = info.getName() + " Copy";
        String objectName = this.selectedDesign.objectName.getName(this.ed);
        log.info("Setting copy editing");
        this.editing = new AssemblyBlueprintData(null, bpName, objectName, this.selectedDesign.subassembly);
        this.resetEditing();
    }

    protected void deleteDesign() {
        if (this.selectedDesign == null) {
            return;
        }
        AssemblyBlueprintInfo info = this.selectedDesign.bpInfo;
        ((OptionPanelState)this.getState(OptionPanelState.class)).show("Delete Design?", "Really delete " + info.getName() + "?", new Action[]{new CallMethodAction("Delete", (Object)this, "doDelete"), new EmptyAction("Cancel")});
    }

    protected void doDelete() {
        this.sessionState.getGameSession().runAction(this.player, "deleteBlueprint", new Object[]{this.selectedDesign.entity.getId()});
    }

    protected void saveEdit(AssemblyBlueprintData design, boolean close) {
        this.sessionState.getGameSession().saveAssemblyBlueprintData(design);
        if (close) {
            log.info("Setting editing to null");
            this.editing = null;
            this.resetEditing();
        }
    }

    protected void cancelEdit() {
        log.info("Setting editing to null");
        this.editing = null;
        this.resetEditing();
    }

    protected void initialize(Application app) {
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        this.player = this.sessionState.getGameSession().getAvatar();
        this.designs = new AssemblyContainer(this.player, this.ed);
        this.window = new Container(new ElementId("window"));
        this.window.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.window.addChild((Node)new Label("Temporary Design Selector", new ElementId("window.title")), new Object[0]);
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "newDesign")), new Object[0]);
        this.window.addChild((Node)new Label("Your Designs:"), new Object[0]);
        this.designList = (ListBox)this.window.addChild((Node)new ListBox(this.designModel), new Object[0]);
        this.designList.setCellRenderer((ValueRenderer)new DefaultCellRenderer<Design>(this){

            public Panel getView(Design bp, boolean selected, Panel existing) {
                existing = super.getView((Object)bp, selected, existing);
                Button b = (Button)existing;
                b.setTextVAlignment(VAlignment.Center);
                SpatialComponent spatialComponent = new SpatialComponent((Spatial)bp.model);
                spatialComponent.setMargin(15.0f, 5.0f, 0.0f);
                spatialComponent.setMaxSize(50.0, 50.0, 50.0);
                spatialComponent.setHAlignment(HAlignment.Right);
                b.setIcon((GuiComponent)spatialComponent);
                return b;
            }
        });
        this.selectionRef = this.designList.getSelectionModel().createSelectionReference();
        this.editButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "editDesign")), new Object[0]);
        this.editButton.setEnabled(false);
        this.copyButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "copyDesign")), new Object[0]);
        this.copyButton.setEnabled(false);
        this.deleteButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "deleteDesign")), new Object[0]);
        this.deleteButton.setEnabled(false);
        this.help = new HelpPopup((Spatial)this.window, ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class))::getGuiLocation, "Designs");
        this.help.setText("Select 'New Design' to create a new design.", "", "Select an existing blue print and click 'Edit' or", "'Copy' to edit that design or a copy of that", "design.", "", "To use a design in the world, open the player", "inventory (i) and equip the Object Tool.", "With the Object Tool equipped, the mouse wheel will", "select a design for placing in the world. The", "selected design will appear at the bottom center", "of the screen.");
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Workbench", (AppState)this);
    }

    protected void cleanup(Application app) {
    }

    public void show() {
        ((PlayerMenuState)this.getState(PlayerMenuState.class)).show();
        if (this.isEnabled()) {
            ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.window);
        }
    }

    public void hide() {
        ((PlayerMenuState)this.getState(PlayerMenuState.class)).hide();
        this.window.removeFromParent();
    }

    protected void onEnable() {
        this.designs.start();
        this.updateDialogPosition();
        this.resetEditing();
        this.help.attach();
    }

    public void update(float tpf) {
        boolean invalid = false;
        if (this.designs.update()) {
            invalid = true;
        }
        if (this.selectionRef.update()) {
            this.updateSelection();
            invalid = true;
        }
        this.updateDialogPosition();
    }

    protected void onDisable() {
        log.info("AssemblyEditorState setting enabled false");
        ((AssemblyEditorState)this.getState(AssemblyEditorState.class)).setEnabled(false);
        this.help.detach();
        this.designs.stop();
        this.window.removeFromParent();
        this.designModel.clear();
    }

    protected void updateDialogPosition() {
        Vector2f screen = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        Vector3f pref = this.window.getSize();
        this.window.setLocalTranslation(screen.x * 0.5f - pref.x - 0.5f, screen.y * 0.5f + pref.y * 0.5f, 0.0f);
    }

    protected void updateSelection() {
        log.info("updateSelection() to:" + this.designList.getSelectedItem());
        Design bp = (Design)this.designList.getSelectedItem();
        if (bp == this.selectedDesign) {
            return;
        }
        this.selectedDesign = bp;
        this.editButton.setEnabled(this.selectedDesign != null);
        this.copyButton.setEnabled(this.selectedDesign != null);
        this.deleteButton.setEnabled(this.selectedDesign != null);
    }

    protected void resetSelection() {
        log.info("resetSelection()");
        Integer index = this.designList.getSelectionModel().getSelection();
        log.info("Existing index:" + index);
        if (index == null) {
            return;
        }
        this.designList.getSelectionModel().clear();
        this.designList.getSelectionModel().setSelection(index);
    }

    private class Design {
        private Entity entity;
        private AssemblyBlueprintInfo bpInfo;
        private ObjectName objectName;
        private ShapeInfo shape;
        private SubassemblyId subassemblyId;
        private Subassembly subassembly;
        private Node model;

        public Design(Entity entity) {
            this.entity = entity;
            this.model = new Node("model:" + entity.getId());
            this.model.setLocalScale(10.0f);
        }

        public void update() {
            this.bpInfo = (AssemblyBlueprintInfo)this.entity.get(AssemblyBlueprintInfo.class);
            this.objectName = (ObjectName)this.entity.get(ObjectName.class);
            this.shape = (ShapeInfo)this.entity.get(ShapeInfo.class);
            this.model.setName("model:" + this.entity.getId() + ", " + this.bpInfo.getName());
            ShapeName name = ShapeName.parse((String)this.shape.getShapeName(AssemblySelectorState.this.ed));
            SubassemblyId id = "asm".equals(name.getType()) ? SubassemblyId.fromString((String)name.getName()) : null;
            log.info("id:" + id);
            if (!Objects.equals(this.subassemblyId, id)) {
                this.subassemblyId = id;
                this.subassembly = this.subassemblyId != null ? AssemblySelectorState.this.sessionState.getDataSession().getSubassembly(this.subassemblyId) : null;
            }
        }

        public String toString() {
            return this.bpInfo.getName();
        }
    }

    private class AssemblyContainer
    extends EntityContainer<Design> {
        private Comparator<? super Design> comparator;

        public AssemblyContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{AssemblyBlueprintInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            this.setFilter(AssemblyBlueprintInfo.parentFilter((EntityId)player));
        }

        protected Design addObject(Entity e) {
            log.info("addObject(" + e + ")");
            Design object = new Design(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(AssemblySelectorState.this.designModel, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                AssemblySelectorState.this.designModel.add(index, (Object)object);
            } else {
                AssemblySelectorState.this.designModel.add((Object)object);
            }
            AssemblySelectorState.this.resetSelection();
            return object;
        }

        protected void updateObject(Design object, Entity e) {
            object.update();
        }

        protected void removeObject(Design object, Entity e) {
            AssemblySelectorState.this.designModel.remove((Object)object);
            AssemblySelectorState.this.resetSelection();
        }
    }
}

