/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.SpatialComponent;
import mythruna.client.ui.clothing.ClothingEditorState;
import mythruna.es.ClothingInfo;
import mythruna.es.ObjectName;
import mythruna.net.ClothingData;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingSelectorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClothingSelectorState.class);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private GeometryFactory geomFactory;
    private Predicate<Geometry> carveIncludes;
    private Container window;
    private ActionButton editButton;
    private ActionButton copyButton;
    private ClothingContainer clothes;
    private VersionedList<Clothing> clothingModel = new VersionedList();
    private ListBox<Clothing> clothingList;
    private VersionedReference<Integer> selectionRef;
    private Clothing selectedClothing;
    private ClothingData editing = null;
    private HelpPopup help;

    public ClothingSelectorState() {
        this.setEnabled(false);
    }

    protected void resetEditing() {
        if (this.editing == null) {
            ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.window);
            ((ClothingEditorState)this.getState(ClothingEditorState.class)).setEnabled(false);
        } else {
            ((ClothingEditorState)this.getState(ClothingEditorState.class)).editClothing(this.editing);
            this.window.removeFromParent();
        }
    }

    protected void newClothing() {
        this.editing = new ClothingData(null, "New Clothing", "Object", new CellArray(32));
        this.resetEditing();
    }

    protected void editClothing() {
        if (this.selectedClothing == null) {
            return;
        }
        if (this.selectedClothing.cellArray == null) {
            log.error("Clothing array is null:" + this.selectedClothing);
            ((GuiState)this.getState(GuiState.class)).showError("Invalid Clothing", "Selected clothing has no cell data.");
            return;
        }
        ClothingInfo info = this.selectedClothing.bpInfo;
        String bpName = info.getName();
        String objectName = this.selectedClothing.objectName.getName(this.ed);
        this.editing = new ClothingData(this.selectedClothing.entity.getId(), bpName, objectName, this.selectedClothing.cellArray);
        this.resetEditing();
    }

    protected void copyClothing() {
        if (this.selectedClothing == null) {
            return;
        }
        ClothingInfo info = this.selectedClothing.bpInfo;
        String bpName = info.getName() + " Copy";
        String objectName = this.selectedClothing.objectName.getName(this.ed);
        this.editing = new ClothingData(null, bpName, objectName, this.selectedClothing.cellArray);
        this.resetEditing();
    }

    protected void saveEdit(ClothingData clothing, boolean close) {
        this.sessionState.getGameSession().saveClothingData(clothing);
        if (close) {
            this.editing = null;
            this.resetEditing();
        }
    }

    protected void cancelEdit() {
        this.editing = null;
        this.resetEditing();
    }

    protected void initialize(Application app) {
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        this.player = this.sessionState.getGameSession().getAvatar();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.carveIncludes = ((GameSessionState)this.getState(GameSessionState.class, true)).getCarveIncludes();
        this.clothes = new ClothingContainer(this.player, this.ed);
        this.window = new Container(new ElementId("window"));
        this.window.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.window.addChild((Node)new Label("Temporary Clothing Selector", new ElementId("window.title")), new Object[0]);
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "newClothing")), new Object[0]);
        this.window.addChild((Node)new Label("Your Clothings:"), new Object[0]);
        this.clothingList = (ListBox)this.window.addChild((Node)new ListBox(this.clothingModel), new Object[0]);
        this.clothingList.setCellRenderer((ValueRenderer)new DefaultCellRenderer<Clothing>(this){

            public Panel getView(Clothing bp, boolean selected, Panel existing) {
                existing = super.getView((Object)bp, selected, existing);
                Button b = (Button)existing;
                b.setTextVAlignment(VAlignment.Center);
                SpatialComponent spatialComponent = new SpatialComponent((Spatial)bp.model);
                spatialComponent.setMargin(15.0f, 5.0f, 0.0f);
                spatialComponent.setMaxSize(50.0, 50.0, 50.0);
                spatialComponent.setHAlignment(HAlignment.Right);
                b.setIcon((GuiComponent)spatialComponent);
                return b;
            }
        });
        this.selectionRef = this.clothingList.getSelectionModel().createSelectionReference();
        this.editButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "editClothing")), new Object[0]);
        this.editButton.setEnabled(false);
        this.copyButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "copyClothing")), new Object[0]);
        this.copyButton.setEnabled(false);
        this.help = new HelpPopup((Spatial)this.window, ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class))::getGuiLocation, "Clothing");
        this.help.setText("Select 'New Clothing' to create a new clothing.", "", "Select an existing clothing design and click 'Edit'", "or 'Copy' to edit that clothing or a copy of that", "clothing.", "", "To use clothing in the world, open the 'Character'", "menu and select an item of clothing from the 'Clothing", "Selector' list and click 'Wear'.", "To remove clothing, select it in the lower 'Weairing'", "list and click 'Remove'.", "", "Clothing is layered in the order that it is worn.");
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Clothing", (AppState)this);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.clothes.start();
        this.updateDialogPosition();
        this.resetEditing();
        this.help.attach();
    }

    public void update(float tpf) {
        boolean invalid = false;
        if (this.clothes.update()) {
            invalid = true;
        }
        if (this.selectionRef.update()) {
            this.updateSelection();
            invalid = true;
        }
        this.updateDialogPosition();
    }

    protected void onDisable() {
        this.help.detach();
        this.clothes.stop();
        this.window.removeFromParent();
        this.clothingModel.clear();
    }

    protected void updateDialogPosition() {
        Vector2f screen = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        Vector3f pref = this.window.getSize();
        this.window.setLocalTranslation(screen.x * 0.5f - pref.x - 0.5f, screen.y * 0.5f + pref.y * 0.5f, 0.0f);
    }

    protected void updateSelection() {
        Clothing bp = (Clothing)this.clothingList.getSelectedItem();
        if (bp == this.selectedClothing) {
            return;
        }
        this.selectedClothing = bp;
        this.editButton.setEnabled(this.selectedClothing != null);
        this.copyButton.setEnabled(this.selectedClothing != null);
    }

    private class Clothing {
        private Entity entity;
        private ClothingInfo bpInfo;
        private ObjectName objectName;
        private ShapeInfo shape;
        private boolean carved;
        private CellArrayId cellArrayId;
        private CellArray cellArray;
        private Node model;

        public Clothing(Entity entity) {
            this.entity = entity;
            this.model = new Node("model:" + entity.getId());
            this.model.setLocalScale(10.0f);
        }

        public void update() {
            this.bpInfo = (ClothingInfo)this.entity.get(ClothingInfo.class);
            this.objectName = (ObjectName)this.entity.get(ObjectName.class);
            this.shape = (ShapeInfo)this.entity.get(ShapeInfo.class);
            this.model.setName("model:" + this.entity.getId() + ", " + this.bpInfo.getName());
            String shapeId = this.shape.getShapeName(ClothingSelectorState.this.ed);
            log.info("shapeId:" + shapeId);
            ShapeName shapeName = ShapeName.parse((String)shapeId);
            log.info("shapeName:" + shapeName);
            if (shapeId.startsWith("f_")) {
                if ((shapeId = shapeId.substring(2)).endsWith(".ca")) {
                    shapeId = shapeId.substring(0, shapeId.length() - 3);
                }
                shapeName = new ShapeName("fab", shapeId);
                log.info("backwards compat: shapeName:" + shapeName);
            }
            CellArrayId id = "fab".equals(shapeName.getType()) ? CellArrayId.fromString((String)shapeName.getName()) : null;
            log.info("id:" + id);
            if (!Objects.equals(this.cellArrayId, id)) {
                this.cellArrayId = id;
                if (this.cellArrayId != null) {
                    this.cellArray = ClothingSelectorState.this.sessionState.getGameSession().getCellArray(this.cellArrayId);
                    log.info("cellArray:" + this.cellArray);
                    ClothingSelectorState.this.geomFactory.generateBlocks(this.model, this.cellArray, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
                } else {
                    this.cellArray = null;
                }
            }
        }

        public String toString() {
            return this.bpInfo.getName();
        }
    }

    private class ClothingContainer
    extends EntityContainer<Clothing> {
        private Comparator<? super Clothing> comparator;

        public ClothingContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{ClothingInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            ComponentFilter filter = Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)player);
            this.setFilter(filter);
        }

        protected Clothing addObject(Entity e) {
            log.info("addObject(" + e + ")");
            Clothing object = new Clothing(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(ClothingSelectorState.this.clothingModel, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                ClothingSelectorState.this.clothingModel.add(index, (Object)object);
            } else {
                ClothingSelectorState.this.clothingModel.add((Object)object);
            }
            return object;
        }

        protected void updateObject(Clothing object, Entity e) {
            object.update();
        }

        protected void removeObject(Clothing object, Entity e) {
            ClothingSelectorState.this.clothingModel.remove((Object)object);
        }
    }
}

